/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import ch.wsl.fps.juwapfl.model.RueckegassenModel;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class RueckegassenVerfahrenPanel
extends AbstractInputPanel {
    private final AbstractMainWindow mainWindow;
    private final JComboBox<RueckegassenModel.Hilfskraft> cmbHilfskraft = new JComboBox<RueckegassenModel.Hilfskraft>(RueckegassenModel.Hilfskraft.values());
    private final JComboBox<RueckegassenModel.Ortskenntnisse> cmbOrtskenntnisse = new JComboBox<RueckegassenModel.Ortskenntnisse>(RueckegassenModel.Ortskenntnisse.values());
    private final JComboBox<RueckegassenModel.UebungPlanungsverfahren> cmbUebungPlanungsverfahren = new JComboBox<RueckegassenModel.UebungPlanungsverfahren>(RueckegassenModel.UebungPlanungsverfahren.values());

    public RueckegassenVerfahrenPanel(AbstractMainWindow mainWindow) {
        super(Messages.getString("Rueckegassen.TitelVerfahren"));
        this.mainWindow = mainWindow;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(new JLabel(Messages.getString("Rueckegassen.Hilfskraft")));
        this.add(Utilities.getPanelWithInfoButton(this.cmbHilfskraft, Messages.getString("Rueckegassen.HilfskraftInfoButton")));
        this.add(new JLabel(Messages.getString("Rueckegassen.Ortskenntnisse")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbOrtskenntnisse));
        this.add(new JLabel(Messages.getString("Rueckegassen.UebungPlanungsverfahren")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbUebungPlanungsverfahren));
        this.cmbHilfskraft.setSelectedItem((Object)RueckegassenModel.Hilfskraft.getDefault());
        this.cmbOrtskenntnisse.setSelectedItem((Object)RueckegassenModel.Ortskenntnisse.getDefault());
        this.cmbUebungPlanungsverfahren.setSelectedItem((Object)RueckegassenModel.UebungPlanungsverfahren.getDefault());
        this.initListeners();
    }

    private void initListeners() {
        this.cmbHilfskraft.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbOrtskenntnisse.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbUebungPlanungsverfahren.addActionListener(this.mainWindow.getDefaultActionListener());
    }

    public RueckegassenModel.Hilfskraft getHilfskraft() {
        return this.cmbHilfskraft.getItemAt(this.cmbHilfskraft.getSelectedIndex());
    }

    public RueckegassenModel.Ortskenntnisse getOrtskenntnisse() {
        return this.cmbOrtskenntnisse.getItemAt(this.cmbOrtskenntnisse.getSelectedIndex());
    }

    public RueckegassenModel.UebungPlanungsverfahren getUebungPlanungsverfahren() {
        return this.cmbUebungPlanungsverfahren.getItemAt(this.cmbUebungPlanungsverfahren.getSelectedIndex());
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Rueckegassen.TitelVerfahren") + "\"> ");
        sb.append(this.getXmlEntry(Messages.getString("Rueckegassen.Hilfskraft"), (Object)this.getHilfskraft()));
        sb.append(this.getXmlEntry(Messages.getString("Rueckegassen.Ortskenntnisse"), (Object)this.getOrtskenntnisse()));
        sb.append(this.getXmlEntry(Messages.getString("Rueckegassen.UebungPlanungsverfahren"), (Object)this.getUebungPlanungsverfahren()));
        sb.append("</section> ");
        return sb.toString();
    }
}

