/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.PflanzungMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import ch.wsl.fps.juwapfl.model.PflanzungWinkelpflanzungModel;
import java.awt.GridLayout;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class PflanzungWinkelpflanzungPanel
extends AbstractInputPanel {
    private final PflanzungMainWindow mainWindow;
    private final JComboBox<PflanzungWinkelpflanzungModel.Bodenvegetation> cmbBodenvegetation = new JComboBox<PflanzungWinkelpflanzungModel.Bodenvegetation>(PflanzungWinkelpflanzungModel.Bodenvegetation.values());
    private final JComboBox<PflanzungWinkelpflanzungModel.Schlagabraum> cmbSchlagabraum = new JComboBox<PflanzungWinkelpflanzungModel.Schlagabraum>(PflanzungWinkelpflanzungModel.Schlagabraum.values());
    private final JComboBox<PflanzungWinkelpflanzungModel.Hangneigung> cmbHangneigung = new JComboBox<PflanzungWinkelpflanzungModel.Hangneigung>(PflanzungWinkelpflanzungModel.Hangneigung.values());
    private final JComboBox<PflanzungWinkelpflanzungModel.Pflanzenhoehe> cmbPflanzenhoehe = new JComboBox<PflanzungWinkelpflanzungModel.Pflanzenhoehe>(PflanzungWinkelpflanzungModel.Pflanzenhoehe.values());
    private final JComboBox<PflanzungWinkelpflanzungModel.Transportdistanz> cmbTransportdistanz = new JComboBox<PflanzungWinkelpflanzungModel.Transportdistanz>(PflanzungWinkelpflanzungModel.Transportdistanz.values());

    public PflanzungWinkelpflanzungPanel(PflanzungMainWindow mainWindow) {
        super(Messages.getString("Pflanzung.Winkelpflanzung.Titel"));
        this.mainWindow = mainWindow;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(new JLabel(Messages.getString("Pflanzung.Winkelpflanzung.HinderlicheBodenvegetation")));
        String msg = Messages.getString("Pflanzung.Winkelpflanzung.InfoButtonBodenvegetation");
        this.add(Utilities.getPanelWithInfoButton(this.cmbBodenvegetation, msg));
        this.add(new JLabel(Messages.getString("Pflanzung.Winkelpflanzung.BeseitigungSchlagabraum")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbSchlagabraum));
        this.add(new JLabel(Messages.getString("Pflanzung.Winkelpflanzung.Hangneigung")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbHangneigung));
        this.add(new JLabel(Messages.getString("Pflanzung.Winkelpflanzung.Pflanzenhoehe")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbPflanzenhoehe));
        this.add(new JLabel(Messages.getString("Pflanzung.Winkelpflanzung.PflanzentransportZuFuss")));
        String infoButtonTransportdistanz = Messages.getString("Pflanzung.Winkelpflanzung.InfoButtonPflanzentransportZuFuss");
        this.add(Utilities.getPanelWithInfoButton(this.cmbTransportdistanz, infoButtonTransportdistanz));
        this.cmbBodenvegetation.setSelectedItem(PflanzungWinkelpflanzungModel.Bodenvegetation.getDefault());
        this.cmbSchlagabraum.setSelectedItem(PflanzungWinkelpflanzungModel.Schlagabraum.getDefault());
        this.cmbHangneigung.setSelectedItem(PflanzungWinkelpflanzungModel.Hangneigung.getDefault());
        this.cmbPflanzenhoehe.setSelectedItem(PflanzungWinkelpflanzungModel.Pflanzenhoehe.getDefault());
        this.cmbTransportdistanz.setSelectedItem(PflanzungWinkelpflanzungModel.Transportdistanz.getDefault());
        this.initListeners();
    }

    private void initListeners() {
        this.cmbBodenvegetation.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbSchlagabraum.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbHangneigung.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbPflanzenhoehe.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbTransportdistanz.addActionListener(this.mainWindow.getDefaultActionListener());
    }

    private PflanzungWinkelpflanzungModel.Bodenvegetation getBodenvegetation() {
        return this.cmbBodenvegetation.getItemAt(this.cmbBodenvegetation.getSelectedIndex());
    }

    private PflanzungWinkelpflanzungModel.Schlagabraum getSchlagabraum() {
        return this.cmbSchlagabraum.getItemAt(this.cmbSchlagabraum.getSelectedIndex());
    }

    private PflanzungWinkelpflanzungModel.Hangneigung getHangneigung() {
        return this.cmbHangneigung.getItemAt(this.cmbHangneigung.getSelectedIndex());
    }

    private PflanzungWinkelpflanzungModel.Pflanzenhoehe getPflanzenhoehe() {
        return this.cmbPflanzenhoehe.getItemAt(this.cmbPflanzenhoehe.getSelectedIndex());
    }

    private PflanzungWinkelpflanzungModel.Transportdistanz getTransportdistanz() {
        return this.cmbTransportdistanz.getItemAt(this.cmbTransportdistanz.getSelectedIndex());
    }

    public PflanzungWinkelpflanzungModel getWinkelpflanzungModel() {
        PflanzungWinkelpflanzungModel result = new PflanzungWinkelpflanzungModel();
        result.setBodenvegetation(this.getBodenvegetation());
        result.setSchlagabraum(this.getSchlagabraum());
        result.setHangneigung(this.getHangneigung());
        result.setPflanzenhoehe(this.getPflanzenhoehe());
        result.setTransportdistanz(this.getTransportdistanz());
        return result;
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Pflanzung.Winkelpflanzung.Titel") + "\"> ");
        sb.append(this.getXmlEntry(Messages.getString("Pflanzung.Winkelpflanzung.HinderlicheBodenvegetation"), this.getBodenvegetation()));
        sb.append(this.getXmlEntry(Messages.getString("Pflanzung.Winkelpflanzung.BeseitigungSchlagabraum"), this.getSchlagabraum()));
        sb.append(this.getXmlEntry(Messages.getString("Pflanzung.Winkelpflanzung.Hangneigung"), this.getHangneigung()));
        sb.append(this.getXmlEntry(Messages.getString("Pflanzung.Winkelpflanzung.Pflanzenhoehe"), this.getPflanzenhoehe()));
        sb.append(this.getXmlEntry(Messages.getString("Pflanzung.Winkelpflanzung.PflanzentransportZuFuss"), this.getTransportdistanz()));
        sb.append("</section> ");
        return sb.toString();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Arrays.asList(this.getComponents()).forEach(c -> c.setEnabled(enabled));
    }
}

