/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.main.PflanzungMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import ch.wsl.fps.juwapfl.model.PflanzungModel;
import java.awt.GridLayout;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class PflanzungPanel
extends AbstractInputPanel {
    private final int DEFAULT_ANZAHL_PFLANZEN = 200;
    private final PflanzungMainWindow mainWindow;
    private final JLabel lblPflanztechnik = new JLabel(Messages.getString("Pflanzung.Pflanztechnik"));
    private final JLabel lblBaumart = new JLabel(Messages.getString("Pflanzung.Baumart"));
    private final JSpinner txtAnzahlPflanzen = new JSpinner(new SpinnerNumberModel(200, 0, 10000, 1));
    private final JComboBox<PflanzungModel.Pflanzwerkzeug> cmbPflanzwerkzeug = new JComboBox<PflanzungModel.Pflanzwerkzeug>(PflanzungModel.Pflanzwerkzeug.values());
    private final JComboBox<PflanzungModel.Pflanztechnik> cmbPflanztechnik = new JComboBox<PflanzungModel.Pflanztechnik>(PflanzungModel.Pflanztechnik.values());
    private final JComboBox<PflanzungModel.Baumart> cmbBaumart = new JComboBox<PflanzungModel.Baumart>(PflanzungModel.Baumart.values());
    private final JComboBox<PflanzungModel.Schwierigkeitsgrad> cmbSchwierigkeitsgrad = new JComboBox<PflanzungModel.Schwierigkeitsgrad>(PflanzungModel.Schwierigkeitsgrad.values());

    public PflanzungPanel(PflanzungMainWindow mainWindow) {
        super(Messages.getString("Pflanzung.Titel"), Messages.getString("Pflanzung.InfoButtonPflanzungPanel"));
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtAnzahlPflanzen, false);
        this.mainWindow = mainWindow;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(new JLabel(Messages.getString("Pflanzung.AnzahlPflanzen")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtAnzahlPflanzen));
        this.add(new JLabel(Messages.getString("Pflanzung.Pflanzwerkzeug")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbPflanzwerkzeug));
        this.add(this.lblPflanztechnik);
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbPflanztechnik));
        this.add(this.lblBaumart);
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbBaumart));
        this.add(new JLabel(Messages.getString("Pflanzung.Schwierigkeitsgrad")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbSchwierigkeitsgrad));
        this.cmbPflanzwerkzeug.setSelectedItem((Object)PflanzungModel.Pflanzwerkzeug.getDefault());
        this.cmbPflanztechnik.setSelectedItem((Object)PflanzungModel.Pflanztechnik.getDefault());
        this.cmbBaumart.setSelectedItem((Object)PflanzungModel.Baumart.getDefault());
        this.cmbSchwierigkeitsgrad.setSelectedItem((Object)PflanzungModel.Schwierigkeitsgrad.getDefault());
        this.updateCombos();
        this.initListeners();
    }

    private void initListeners() {
        this.txtAnzahlPflanzen.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.cmbPflanzwerkzeug.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbPflanztechnik.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbBaumart.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbSchwierigkeitsgrad.addActionListener(this.mainWindow.getDefaultActionListener());
    }

    public void onInputChangedBeforeCalculation() {
        this.updateCombos();
    }

    private void updateCombos() {
        this.updateCmbPflanztechnik();
        this.updateCmbBaumart();
        this.updateCmbSchwierigkeitsgrad();
    }

    private void updateCmbPflanztechnik() {
        PflanzungModel.Pflanztechnik selection = (PflanzungModel.Pflanztechnik)((Object)this.cmbPflanztechnik.getSelectedItem());
        this.cmbPflanztechnik.removeAllItems();
        PflanzungModel.Pflanztechnik[] pflanztechniken = PflanzungModel.Pflanztechnik.getPflanztechniken((PflanzungModel.Pflanzwerkzeug)((Object)this.cmbPflanzwerkzeug.getSelectedItem()));
        Arrays.asList(pflanztechniken).forEach(item -> this.cmbPflanztechnik.addItem((PflanzungModel.Pflanztechnik)((Object)item)));
        this.cmbPflanztechnik.setEnabled(this.cmbPflanztechnik.getItemCount() > 1);
        if (selection != null) {
            this.cmbPflanztechnik.setSelectedItem((Object)selection);
        }
    }

    private void updateCmbBaumart() {
        PflanzungModel.Baumart selection = (PflanzungModel.Baumart)((Object)this.cmbBaumart.getSelectedItem());
        this.cmbBaumart.removeAllItems();
        if (this.isWiedeholzhaueWinkelpflanzung()) {
            Arrays.asList(PflanzungModel.Baumart.values()).forEach(item -> this.cmbBaumart.addItem((PflanzungModel.Baumart)((Object)item)));
        }
        this.cmbBaumart.setEnabled(this.cmbBaumart.getItemCount() > 1);
        if (selection != null) {
            this.cmbBaumart.setSelectedItem((Object)selection);
        }
    }

    private void updateCmbSchwierigkeitsgrad() {
        boolean isWiedeholzhaueWinkelpflanzung = this.isWiedeholzhaueWinkelpflanzung();
        this.cmbSchwierigkeitsgrad.setEnabled(!isWiedeholzhaueWinkelpflanzung);
        if (isWiedeholzhaueWinkelpflanzung && this.cmbSchwierigkeitsgrad.getItemCount() > 0) {
            this.cmbSchwierigkeitsgrad.removeAllItems();
        }
        if (!isWiedeholzhaueWinkelpflanzung && this.cmbSchwierigkeitsgrad.getItemCount() == 0) {
            Arrays.asList(PflanzungModel.Schwierigkeitsgrad.values()).forEach(item -> this.cmbSchwierigkeitsgrad.addItem((PflanzungModel.Schwierigkeitsgrad)((Object)item)));
            this.cmbSchwierigkeitsgrad.setSelectedItem((Object)PflanzungModel.Schwierigkeitsgrad.getDefault());
        }
    }

    public int getAnzahlPflanzen() {
        return (Integer)this.txtAnzahlPflanzen.getValue();
    }

    public PflanzungModel.Pflanzwerkzeug getPflanzwerkzeug() {
        return this.cmbPflanzwerkzeug.getItemAt(this.cmbPflanzwerkzeug.getSelectedIndex());
    }

    public PflanzungModel.Pflanztechnik getPflanztechnik() {
        return this.cmbPflanztechnik.getItemAt(this.cmbPflanztechnik.getSelectedIndex());
    }

    public PflanzungModel.Baumart getBaumart() {
        return this.cmbBaumart.getItemAt(this.cmbBaumart.getSelectedIndex());
    }

    public PflanzungModel.Schwierigkeitsgrad getSchwierigkeitsgrad() {
        return this.cmbSchwierigkeitsgrad.getItemAt(this.cmbSchwierigkeitsgrad.getSelectedIndex());
    }

    public boolean isWiedeholzhaueWinkelpflanzung() {
        return this.cmbPflanzwerkzeug.getSelectedItem() == PflanzungModel.Pflanzwerkzeug.WIEDEHOPFHAUE && this.cmbPflanztechnik.getSelectedItem() == PflanzungModel.Pflanztechnik.WINKELPFLANZUNG;
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Pflanzung.Titel") + "\"> ");
        sb.append(this.getXmlEntry(Messages.getString("Pflanzung.AnzahlPflanzen"), this.getAnzahlPflanzen()));
        sb.append(this.getXmlEntry(Messages.getString("Pflanzung.Pflanzwerkzeug"), (Object)this.getPflanzwerkzeug()));
        sb.append(this.getXmlEntry(Messages.getString("Pflanzung.Pflanztechnik"), (Object)this.getPflanztechnik()));
        if (this.cmbBaumart.isEnabled()) {
            sb.append(this.getXmlEntry(Messages.getString("Pflanzung.Baumart"), (Object)this.getBaumart()));
        }
        if (this.cmbSchwierigkeitsgrad.isEnabled()) {
            sb.append(this.getXmlEntry(Messages.getString("Pflanzung.Schwierigkeitsgrad"), (Object)this.getSchwierigkeitsgrad()));
        }
        sb.append("</section> ");
        return sb.toString();
    }
}

