/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.CurrencySensitive;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class FahrzeugkostenPanel
extends AbstractInputPanel
implements CurrencySensitive {
    private final AbstractMainWindow mainWindow;
    private final JLabel lblKostenAufbau = new JLabel();
    private final JLabel lblKostenUnterhalt = new JLabel();
    private final JLabel lblKostenAbbau = new JLabel();
    private final JSpinner txtKostenAufbau = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 10000.0, 1.0));
    private final JSpinner txtKostenUnterhalt = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 10000.0, 1.0));
    private final JSpinner txtKostenAbbau = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 10000.0, 1.0));

    public FahrzeugkostenPanel(AbstractMainWindow mainWindow) {
        super(Messages.getString("Common.TitelFahrzeugkosten"));
        this.mainWindow = mainWindow;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(this.lblKostenAufbau);
        this.add(Utilities.getPanelWithoutInfoButton(this.txtKostenAufbau));
        this.add(this.lblKostenUnterhalt);
        this.add(Utilities.getPanelWithoutInfoButton(this.txtKostenUnterhalt));
        this.add(this.lblKostenAbbau);
        this.add(Utilities.getPanelWithoutInfoButton(this.txtKostenAbbau));
        this.initFields();
        this.initListeners();
        mainWindow.registerForCurrencyUpdates(this);
    }

    private void initFields() {
        this.txtKostenAufbau.setEditor(new JSpinner.NumberEditor(this.txtKostenAufbau, "0.00"));
        this.txtKostenUnterhalt.setEditor(new JSpinner.NumberEditor(this.txtKostenUnterhalt, "0.00"));
        this.txtKostenAbbau.setEditor(new JSpinner.NumberEditor(this.txtKostenAbbau, "0.00"));
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtKostenAufbau, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtKostenUnterhalt, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtKostenAbbau, false);
    }

    private void initListeners() {
        this.txtKostenAufbau.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtKostenUnterhalt.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtKostenAbbau.addChangeListener(this.mainWindow.getDefaultChangeListener());
    }

    public Double getFahrzeugkostenAufbauPauschal() {
        return (Double)this.txtKostenAufbau.getValue();
    }

    public Double getFahrzeugkostenUnterhaltPauschal() {
        return (Double)this.txtKostenUnterhalt.getValue();
    }

    public Double getFahrzeugkostenAbbauPauschal() {
        return (Double)this.txtKostenAbbau.getValue();
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Common.TitelFahrzeugkosten") + "\"> ");
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Common.FahrzeugkostenAufbauPauschal")) + " [" + this.mainWindow.getCurrency() + "]", this.getFahrzeugkostenAufbauPauschal()));
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Common.FahrzeugkostenUnterhaltPauschal")) + " [" + this.mainWindow.getCurrency() + "]", this.getFahrzeugkostenUnterhaltPauschal()));
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Common.FahrzeugkostenAbbauPauschal")) + " [" + this.mainWindow.getCurrency() + "]", this.getFahrzeugkostenAbbauPauschal()));
        sb.append("</section> ");
        return sb.toString();
    }

    @Override
    public void updateCurrency() {
        this.lblKostenAufbau.setText(String.valueOf(Messages.getString("Common.FahrzeugkostenAufbauPauschal")) + " [" + this.mainWindow.getCurrency() + "]");
        this.lblKostenUnterhalt.setText(String.valueOf(Messages.getString("Common.FahrzeugkostenUnterhaltPauschal")) + " [" + this.mainWindow.getCurrency() + "]");
        this.lblKostenAbbau.setText(String.valueOf(Messages.getString("Common.FahrzeugkostenAbbauPauschal")) + " [" + this.mainWindow.getCurrency() + "]");
    }
}

