/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.ergebnis;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.main.BegehungswegeMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.ergebnis.AbstractErgebnisPanel;
import ch.wsl.fps.juwapfl.model.BegehungswegeErgebnis;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class BegehungswegeErgebnisPanel
extends AbstractErgebnisPanel<BegehungswegeMainWindow, BegehungswegeErgebnis> {
    private final JTextField txtZeitPersonal = BegehungswegeErgebnisPanel.getNewLockedTextField();
    private final JTextField txtZeitMaschine = BegehungswegeErgebnisPanel.getNewLockedTextField();
    private final JTextField txtKostenPersonal = BegehungswegeErgebnisPanel.getNewLockedTextField();
    private final JTextField txtKostenMaschine = BegehungswegeErgebnisPanel.getNewLockedTextField();
    private final JTextField txtKostenGesamt = BegehungswegeErgebnisPanel.getNewLockedTextFieldBold();

    public BegehungswegeErgebnisPanel(BegehungswegeMainWindow mainWindow) {
        super(mainWindow);
        AbstractMainWindow.initTitledBorder(this, Messages.getString("Common.TitelErgebnis"));
        this.setBackground(AbstractErgebnisPanel.ERGEBNIS_PANEL_BACKGROUND_COLOR);
        int row = 0;
        int col = 0;
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(), BegehungswegeErgebnisPanel.getGBC(col++, row));
        this.add((Component)new JLabel("<html><center>" + Messages.getString("Common.TitelZeiten") + "</center></html>", 0), BegehungswegeErgebnisPanel.getGBC(col++, row));
        this.add((Component)new JLabel(), BegehungswegeErgebnisPanel.getGBC(col++, row));
        this.add((Component)this.lblKostenTitle, BegehungswegeErgebnisPanel.getGBC(col++, row));
        this.add((Component)new JLabel(), BegehungswegeErgebnisPanel.getGBC(col++, row));
        col = 0;
        this.add((Component)new JLabel(String.valueOf(Messages.getString("Common.TitelPersonalWPPH")) + "  ", 4), BegehungswegeErgebnisPanel.getGBC(col++, ++row));
        this.add((Component)this.txtZeitPersonal, BegehungswegeErgebnisPanel.getGBC(col++, row));
        int n = ++col;
        ++col;
        this.add((Component)this.txtKostenPersonal, BegehungswegeErgebnisPanel.getGBC(n, row));
        col = 0;
        this.add((Component)new JLabel(String.valueOf(Messages.getString("Common.TitelMaschinePMH15")) + "  ", 4), BegehungswegeErgebnisPanel.getGBC(col++, ++row));
        this.add((Component)this.txtZeitMaschine, BegehungswegeErgebnisPanel.getGBC(col++, row));
        int n2 = ++col;
        ++col;
        this.add((Component)this.txtKostenMaschine, BegehungswegeErgebnisPanel.getGBC(n2, row));
        col = 0;
        this.add((Component)this.getLabelGesamt(), BegehungswegeErgebnisPanel.getGBC(col++, ++row));
        this.add((Component)new JLabel(), BegehungswegeErgebnisPanel.getGBC(col++, row));
        int n3 = ++col;
        ++col;
        this.add((Component)this.txtKostenGesamt, BegehungswegeErgebnisPanel.getGBC(n3, row));
        mainWindow.registerForCurrencyUpdates(this);
    }

    @Override
    public void setErgebnis(BegehungswegeErgebnis ergebnis) {
        this.txtZeitPersonal.setText(BegehungswegeErgebnisPanel.formatMinutes(ergebnis.getZeitPersonal_min()));
        this.txtZeitMaschine.setText(BegehungswegeErgebnisPanel.formatMinutes(ergebnis.getZeitMaschine_min()));
        this.txtKostenPersonal.setText(BegehungswegeErgebnisPanel.format(ergebnis.getKostenPersonal()));
        this.txtKostenMaschine.setText(BegehungswegeErgebnisPanel.format(ergebnis.getKostenMaschine()));
        this.txtKostenGesamt.setText(BegehungswegeErgebnisPanel.format(ergebnis.getKostenGesamt()));
    }

    @Override
    public String[][] getErgebnisAsStringArray() {
        String[][] strings = new String[][]{{Messages.getString("Common.TitelPersonalWPPH"), this.txtZeitPersonal.getText(), this.txtKostenPersonal.getText()}, {Messages.getString("Common.TitelMaschinePMH15"), this.txtZeitMaschine.getText(), this.txtKostenMaschine.getText()}, {Messages.getString("Common.TitelGesamt"), "", "<b>" + this.txtKostenGesamt.getText() + "</b>"}};
        return strings;
    }
}

