/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.ergebnis;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.CurrencySensitive;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.model.AbstractErgebnis;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.text.DecimalFormat;
import java.time.Duration;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class AbstractErgebnisPanel<M extends AbstractMainWindow, E extends AbstractErgebnis>
extends JPanel
implements CurrencySensitive {
    public static final Color ERGEBNIS_PANEL_BACKGROUND_COLOR = new Color(255, 255, 225);
    protected static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat(",##0.00");
    protected static final String TWO_SPACES = "  ";
    protected final M mainWindow;
    protected final JLabel lblKostenTitle = new JLabel("", 0);

    protected AbstractErgebnisPanel(M mainWindow) {
        this.mainWindow = mainWindow;
    }

    protected static GridBagConstraints getGBC(int x, int y) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.ipady = 8;
        return gbc;
    }

    protected static GridBagConstraints getGBC(int x, int y, int gridwidth) {
        GridBagConstraints gbc = AbstractErgebnisPanel.getGBC(x, y);
        gbc.gridwidth = gridwidth;
        gbc.ipady = 0;
        return gbc;
    }

    protected JLabel getLabelGesamt() {
        String infoButtonText = Utilities.normalizeTooltipText(Messages.getString("Common.InfoButtonRundung"));
        JLabel lblGesamt = Utilities.getInfoButtonBlue(infoButtonText);
        lblGesamt.setText(String.valueOf(Messages.getString("Common.ErgebnisGesamt")) + TWO_SPACES);
        lblGesamt.setHorizontalAlignment(4);
        lblGesamt.setHorizontalTextPosition(4);
        return lblGesamt;
    }

    protected static String format(double value) {
        return DECIMAL_FORMAT.format(value);
    }

    protected static String formatMinutes(double totalMinutes) {
        boolean SHOW_SECONDS = false;
        Duration d = Duration.ofSeconds(Math.round(totalMinutes * 60.0));
        long hours = d.toHours();
        long minutes = d.toMinutes() - 60L * d.toHours();
        long seconds = d.getSeconds() - 60L * d.toMinutes();
        if (seconds >= 30L && ++minutes == 60L) {
            ++hours;
            minutes = 0L;
        }
        if (hours > 0L) {
            return String.format("%dh %dmin", hours, minutes);
        }
        return String.format("%dmin", minutes);
    }

    protected static JTextField getNewLockedTextFieldBold() {
        JTextField result = AbstractErgebnisPanel.getNewLockedTextField();
        result.setFont(result.getFont().deriveFont(1));
        return result;
    }

    protected static JTextField getNewLockedTextField() {
        return AbstractErgebnisPanel.getNewLockedTextField(false);
    }

    protected static JTextField getNewLockedTextField(boolean isAlwaysEmpty) {
        JTextField textField = new JTextField();
        textField.setEditable(false);
        if (isAlwaysEmpty) {
            textField.setText("-");
            textField.setHorizontalAlignment(0);
        } else {
            textField.setBackground(Color.WHITE);
            textField.setHorizontalAlignment(4);
        }
        return textField;
    }

    public abstract void setErgebnis(E var1);

    public abstract String[][] getErgebnisAsStringArray();

    @Override
    public void updateCurrency() {
        this.lblKostenTitle.setText("<html><center>" + Messages.getString("Common.ErgebnisKosten") + " [" + ((AbstractMainWindow)this.mainWindow).getCurrency() + "]</center></html>");
    }
}

