/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.main;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.ergebnis.ZBaumDurchforstungErgebnisPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.ZBaumDurchforstungBestandPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.ZBaumDurchforstungKronenschnittPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.ZBaumDurchforstungPersonalMaschinenPanel;
import ch.wsl.fps.juwapfl.model.ZBaumDurchforstungErgebnis;
import ch.wsl.fps.juwapfl.model.ZBaumDurchforstungModel;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class ZBaumDurchforstungMainWindow
extends AbstractMainWindow {
    private ZBaumDurchforstungBestandPanel panelBestand;
    private ZBaumDurchforstungKronenschnittPanel panelKronenschnitt;
    private ZBaumDurchforstungPersonalMaschinenPanel panelPersonalMaschinen;
    private ZBaumDurchforstungErgebnisPanel panelErgebnis;

    public static void main(String[] args) {
        AbstractMainWindow.main(args, () -> {
            ZBaumDurchforstungMainWindow zBaumDurchforstungMainWindow = new ZBaumDurchforstungMainWindow();
        });
    }

    public ZBaumDurchforstungMainWindow() {
        this.setTitle(Messages.getString("ZBaumDurchforstung.FensterTitel"));
        this.setSize(this.getWindowSize(760), this.getWindowSize(800));
        this.init();
    }

    @Override
    protected String[] getDokuPdfFileNames() {
        String[] stringArray = new String[2];
        stringArray[0] = "DokuZBaumDurchforstung.pdf";
        return stringArray;
    }

    @Override
    protected String getModelAsXmlString() {
        String xmlModelName = "<modellname>" + Messages.getString("ZBaumDurchforstung.Titel") + "</modellname>";
        String xmlInfo = this.getMetaInformationAsXmlString();
        String xmlPdfTitles = this.getPdfTitlesAsXmlString();
        String xmlEingaben = "<eingaben>";
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelBestand.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelKronenschnitt.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelPersonalMaschinen.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + "</eingaben>";
        String xmlErgebnis = ZBaumDurchforstungMainWindow.getErgebnisAsXmlString(this.panelErgebnis);
        String result = String.valueOf(xmlModelName) + xmlInfo + xmlPdfTitles + xmlEingaben + xmlErgebnis;
        return result;
    }

    @Override
    protected String getXsltFilePath() {
        return "data/kalkulation2fo-zbaum.xsl";
    }

    @Override
    protected Map<String, String> getAdditionalPdfTitles() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("pro-z-baum", Messages.getString("ZBaumDurchforstung.proZBaum"));
        result.put("pro-hektare", Messages.getString("ZBaumDurchforstung.proHektare"));
        result.put("bestand", Messages.getString("ZBaumDurchforstung.Bestand"));
        return result;
    }

    @Override
    protected JPanel createPanelInput() {
        JPanel pnlInput = new JPanel();
        ZBaumDurchforstungMainWindow.initTitledBorder(pnlInput, Messages.getString("Common.TitelEingaben"));
        pnlInput.setLayout(new BoxLayout(pnlInput, 3));
        pnlInput.add(Box.createVerticalStrut(5));
        this.panelBestand = new ZBaumDurchforstungBestandPanel(this);
        pnlInput.add(this.panelBestand);
        pnlInput.add(Box.createVerticalStrut(10));
        this.panelKronenschnitt = new ZBaumDurchforstungKronenschnittPanel(this, this.panelBestand);
        pnlInput.add(this.panelKronenschnitt);
        pnlInput.add(Box.createVerticalStrut(10));
        this.panelPersonalMaschinen = new ZBaumDurchforstungPersonalMaschinenPanel(this, this.panelBestand);
        pnlInput.add(this.panelPersonalMaschinen);
        pnlInput.add(Box.createVerticalGlue());
        pnlInput.add(Box.createRigidArea(new Dimension(1, 220)));
        return pnlInput;
    }

    @Override
    protected void onInputChangedBeforeCalculation() {
        this.panelBestand.onInputChangedBeforeCalculation();
        this.panelKronenschnitt.onInputChangedBeforeCalculation();
        this.panelPersonalMaschinen.onInputChangedBeforeCalculation();
    }

    @Override
    protected void displayErgebnis() {
        ZBaumDurchforstungModel model = new ZBaumDurchforstungModel();
        model.setFlaeche_ha(this.panelBestand.getFlaeche_ha());
        model.setEntwicklungsstufe(this.panelBestand.getEntwicklungsstufe());
        model.setAnzahlZBaeumeProHa(this.panelBestand.getAnzahlZBaeumeProHektare());
        model.setAnzahlKonkurrentenProZBaum(this.panelBestand.getAnzahlKonkurrentenProZBaum());
        model.setBaendeln(this.panelBestand.getBaendeln());
        model.setHangneigung(this.panelBestand.getHangneigung());
        model.setBelaubung(this.panelBestand.getBelaubung());
        model.setVerunkrautung(this.panelBestand.getVerunkrautung());
        model.setRueckegassenVorhanden(this.panelBestand.getRueckegassenVorhanden());
        model.setTemperatur(this.panelBestand.getTemperatur());
        model.setZersaegen(this.panelBestand.getZersaegen());
        model.setAnzahlZBaeumeMitKronenschnittProHektare(this.panelKronenschnitt.getAnzahlZBaeumeMitKronenschnittProHektare());
        model.setAusfuehrungshoeheKronenschnitt(this.panelKronenschnitt.getAusfuehrungshoeheKronenschnitt());
        model.setKostenPersonal_proH(this.panelPersonalMaschinen.getKostenPersonalProPerson().intValue());
        model.setKostenMotorsaege_proLiter(this.panelPersonalMaschinen.getKostenMotorsaege());
        model.setKostenKronenschnittUnten_proBaum(this.panelPersonalMaschinen.getKostenKronenschnittUnten());
        model.setKostenKronenschnittOben_proBaum(this.panelPersonalMaschinen.getKostenKronenschnittOben());
        model.setFaktorWegzeitenUndPausen(this.panelPersonalMaschinen.getFaktorWegzeitenUndPausen());
        ZBaumDurchforstungErgebnis ergebnis = model.getErgebnis();
        this.panelErgebnis.setErgebnis(ergebnis);
    }

    @Override
    protected JPanel createPanelOutput() {
        this.panelErgebnis = new ZBaumDurchforstungErgebnisPanel(this);
        return this.panelErgebnis;
    }
}

