/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.main;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.ergebnis.WildschutzErgebnisPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.FahrzeugkostenPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.SimplePersonalPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.WildschutzChartPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.WildschutzKorrekturfaktorenPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.WildschutzPanel;
import ch.wsl.fps.juwapfl.model.WildschutzErgebnis;
import ch.wsl.fps.juwapfl.model.WildschutzModel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class WildschutzMainWindow
extends AbstractMainWindow {
    private WildschutzPanel panelWildschutz;
    private SimplePersonalPanel panelPersonal;
    private FahrzeugkostenPanel panelFahrzeugkosten;
    private WildschutzKorrekturfaktorenPanel panelKorrekturfaktoren;
    private WildschutzErgebnisPanel panelErgebnisEinzelberechnung;
    private WildschutzChartPanel panelErgebnisKostenvergleich;
    private JPanel panelErgebnisAll;
    private JComboBox<WildschutzModel.Subtyp> cmbKostenvergleichZaunartSubtyp;
    private boolean isKostenvergleichActive = false;

    public static void main(String[] args) {
        AbstractMainWindow.main(args, () -> {
            WildschutzMainWindow wildschutzMainWindow = new WildschutzMainWindow();
        });
    }

    public WildschutzMainWindow() {
        this.setTitle(Messages.getString("Wildschutz.FensterTitel"));
        this.setSize(this.getWindowSize(720), this.getWindowSize(750));
        this.init();
    }

    @Override
    protected String[] getDokuPdfFileNames() {
        String[] stringArray = new String[2];
        stringArray[0] = "DokuWildschutz.pdf";
        return stringArray;
    }

    @Override
    protected JPanel createPanelInput() {
        JPanel pnlInput = new JPanel();
        WildschutzMainWindow.initTitledBorder(pnlInput, Messages.getString("Common.TitelEingaben"));
        pnlInput.setLayout(new BoxLayout(pnlInput, 3));
        pnlInput.add(Box.createVerticalStrut(5));
        this.panelWildschutz = new WildschutzPanel(this);
        pnlInput.add(this.panelWildschutz);
        pnlInput.add(Box.createVerticalStrut(10));
        this.panelPersonal = new SimplePersonalPanel(this, false);
        pnlInput.add(this.panelPersonal);
        pnlInput.add(Box.createVerticalStrut(10));
        this.panelFahrzeugkosten = new FahrzeugkostenPanel(this);
        pnlInput.add(this.panelFahrzeugkosten);
        pnlInput.add(Box.createVerticalStrut(10));
        this.panelKorrekturfaktoren = new WildschutzKorrekturfaktorenPanel(this);
        pnlInput.add(this.panelKorrekturfaktoren);
        pnlInput.add(Box.createVerticalGlue());
        pnlInput.add(Box.createRigidArea(new Dimension(1, 220)));
        return pnlInput;
    }

    private JPanel initPanelSwitchButton() {
        this.cmbKostenvergleichZaunartSubtyp = new JComboBox<WildschutzModel.Subtyp>(WildschutzModel.Subtyp.getValues(WildschutzModel.Schutztyp.FLAECHENSCHUTZ));
        this.cmbKostenvergleichZaunartSubtyp.addActionListener(super.getDefaultActionListener());
        JPanel pnlZaunart = new JPanel();
        pnlZaunart.add(new JLabel(Messages.getString("Wildschutz.UeberschriftZaunSubtyp")));
        pnlZaunart.add(this.cmbKostenvergleichZaunartSubtyp);
        pnlZaunart.setVisible(false);
        String txtSwitchToVergleich = Messages.getString("Wildschutz.KostenvergleichDurchfuehren");
        String txtSwitchToEinzelkalkulation = Messages.getString("Wildschutz.EinzelkalkulationDurchfuehren");
        JButton btnSwitchErgebnis = new JButton(txtSwitchToVergleich);
        btnSwitchErgebnis.addActionListener(e -> {
            boolean newStateIsKostenvergleich = btnSwitchErgebnis.getText().equals(txtSwitchToVergleich);
            btnSwitchErgebnis.setText(newStateIsKostenvergleich ? txtSwitchToEinzelkalkulation : txtSwitchToVergleich);
            CardLayout cardLayout = (CardLayout)this.panelErgebnisAll.getLayout();
            cardLayout.next(this.panelErgebnisAll);
            pnlZaunart.setVisible(newStateIsKostenvergleich);
            this.panelWildschutz.setModusKostenvergleich(newStateIsKostenvergleich);
            this.isKostenvergleichActive = newStateIsKostenvergleich;
            this.displayErgebnis();
            if (newStateIsKostenvergleich) {
                String message = Utilities.normalizeTooltipText(Messages.getString("Wildschutz.MessageKostenvergleich"));
                message = message.replace("<html>", "").replace("</html>", "").replace("<br>", "\n");
                JOptionPane.showMessageDialog(this, message);
            }
        });
        JPanel pnlButton = new JPanel();
        pnlButton.add(btnSwitchErgebnis);
        JPanel pnlSwitchButton = new JPanel();
        pnlSwitchButton.setLayout(new BorderLayout());
        pnlSwitchButton.add((Component)pnlButton, "West");
        pnlSwitchButton.add((Component)pnlZaunart, "Center");
        return pnlSwitchButton;
    }

    @Override
    protected JPanel createPanelOutput() {
        this.panelErgebnisAll = new JPanel(new CardLayout());
        this.panelErgebnisEinzelberechnung = new WildschutzErgebnisPanel(this);
        this.panelErgebnisKostenvergleich = new WildschutzChartPanel();
        this.panelErgebnisAll.add(this.panelErgebnisEinzelberechnung);
        this.panelErgebnisAll.add(this.panelErgebnisKostenvergleich);
        JPanel pnlOutput = new JPanel();
        pnlOutput.setLayout(new BoxLayout(pnlOutput, 3));
        pnlOutput.add(this.initPanelSwitchButton());
        pnlOutput.add(Box.createVerticalStrut(5));
        pnlOutput.add(this.panelErgebnisAll);
        return pnlOutput;
    }

    @Override
    protected String getModelAsXmlString() {
        String xmlModelName = "<modellname>" + Messages.getString("Wildschutz.Titel") + "</modellname>";
        String xmlInfo = this.getMetaInformationAsXmlString();
        String xmlPdfTitles = this.getPdfTitlesAsXmlString();
        String xmlEingaben = "<eingaben>";
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelWildschutz.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelPersonal.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelFahrzeugkosten.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelKorrekturfaktoren.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + "</eingaben>";
        String xmlErgebnis = WildschutzMainWindow.getErgebnisAsXmlString(this.panelErgebnisEinzelberechnung);
        String result = String.valueOf(xmlModelName) + xmlInfo + xmlPdfTitles + xmlEingaben + xmlErgebnis;
        return result;
    }

    @Override
    protected String getXsltFilePath() {
        return "data/kalkulation2fo-wildschutz.xsl";
    }

    @Override
    protected Map<String, String> getAdditionalPdfTitles() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("aufbau", Messages.getString("Wildschutz.Pdf.Aufbau"));
        result.put("unterhalt", Messages.getString("Wildschutz.Pdf.Unterhalt"));
        result.put("abbau", Messages.getString("Wildschutz.Pdf.Abbau"));
        result.put("gesamt", Messages.getString("Wildschutz.Pdf.Gesamt"));
        return result;
    }

    @Override
    protected void onInputChangedBeforeCalculation() {
        this.panelWildschutz.onInputChangedBeforeCalculation();
    }

    @Override
    protected void displayErgebnis() {
        WildschutzModel modelEinzelkalkulation = this.getNewModel();
        WildschutzErgebnis ergebnisEinzelkalkulation = modelEinzelkalkulation.getErgebnis();
        this.panelErgebnisEinzelberechnung.setErgebnis(ergebnisEinzelkalkulation);
        if (this.isKostenvergleichActive) {
            double kostenEinzelschutzGesamt = ergebnisEinzelkalkulation.getKostenGesamtGesamt();
            int anzahlPflanzenEinzelschutz = this.panelWildschutz.getAnzahlPflanzen();
            WildschutzModel modelZaun = this.getNewModel();
            modelZaun.setSchutztyp(WildschutzModel.Schutztyp.FLAECHENSCHUTZ);
            modelZaun.setSubtyp((WildschutzModel.Subtyp)((Object)this.cmbKostenvergleichZaunartSubtyp.getSelectedItem()));
            modelZaun.setZaunlaenge_m(500);
            WildschutzErgebnis ergebnisZaun = modelZaun.getErgebnis();
            double kostenZaunGesamt = ergebnisZaun.getKostenGesamtGesamt();
            double anzahl = (0.0 + (double)anzahlPflanzenEinzelschutz) * kostenZaunGesamt / kostenEinzelschutzGesamt;
            this.panelErgebnisKostenvergleich.setData(anzahl, anzahlPflanzenEinzelschutz, this.panelWildschutz.getZaunlaenge_m().intValue());
        }
    }

    private WildschutzModel getNewModel() {
        WildschutzModel model = new WildschutzModel();
        model.setSchutztyp(this.panelWildschutz.getSchutztyp());
        model.setSubtyp(this.panelWildschutz.getSubtyp());
        model.setWuchshuellentyp(this.panelWildschutz.getWuchshuellentyp());
        model.setAnzahlPflanzen(this.panelWildschutz.getAnzahlPflanzen());
        model.setZaunlaenge_m(this.panelWildschutz.getZaunlaenge_m());
        model.setKostenPersonalProPerson(this.panelPersonal.getKostenPersonalProPerson_proH());
        model.setFaktorWegzeitenUndPausen(this.panelPersonal.getFaktorWegzeitenUndPausen());
        model.setFahrzeugkostenAufbauPauschal(this.panelFahrzeugkosten.getFahrzeugkostenAufbauPauschal());
        model.setFahrzeugkostenUnterhaltPauschal(this.panelFahrzeugkosten.getFahrzeugkostenUnterhaltPauschal());
        model.setFahrzeugkostenAbbauPauschal(this.panelFahrzeugkosten.getFahrzeugkostenAbbauPauschal());
        model.setKorrekturfaktorZeitaufwand(this.panelKorrekturfaktoren.getKorrekturfaktorZeitaufwand());
        model.setKorrekturfaktorMaterialkosten(this.panelKorrekturfaktoren.getKorrekturfaktorMaterialkosten());
        return model;
    }
}

