/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.main;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.ergebnis.WertastungErgebnisPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.MaterialkostenPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.SimplePersonalPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.WertastungBestandPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.WertastungPanel;
import ch.wsl.fps.juwapfl.model.WertastungErgebnis;
import ch.wsl.fps.juwapfl.model.WertastungModel;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class WertastungMainWindow
extends AbstractMainWindow {
    private WertastungBestandPanel panelBestand;
    private WertastungPanel panelWertastung;
    private SimplePersonalPanel panelPersonal;
    private MaterialkostenPanel panelMaterialkosten;
    private WertastungErgebnisPanel panelErgebnis;

    public static void main(String[] args) {
        AbstractMainWindow.main(args, () -> {
            WertastungMainWindow wertastungMainWindow = new WertastungMainWindow();
        });
    }

    public WertastungMainWindow() {
        this.setTitle(Messages.getString("Wertastung.FensterTitel"));
        this.setSize(this.getWindowSize(550), this.getWindowSize(713));
        this.init();
    }

    @Override
    protected String[] getDokuPdfFileNames() {
        String[] stringArray = new String[2];
        stringArray[0] = "DokuWertastung.pdf";
        return stringArray;
    }

    @Override
    protected String getModelAsXmlString() {
        String xmlModelName = "<modellname>" + Messages.getString("Wertastung.Titel") + "</modellname>";
        String xmlInfo = this.getMetaInformationAsXmlString();
        String xmlPdfTitles = this.getPdfTitlesAsXmlString();
        String xmlEingaben = "<eingaben>";
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelBestand.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelWertastung.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelPersonal.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelMaterialkosten.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + "</eingaben>";
        String xmlErgebnis = WertastungMainWindow.getErgebnisAsXmlString(this.panelErgebnis);
        String result = String.valueOf(xmlModelName) + xmlInfo + xmlPdfTitles + xmlEingaben + xmlErgebnis;
        return result;
    }

    @Override
    protected String getXsltFilePath() {
        return "data/kalkulation2fo-wertastung.xsl";
    }

    @Override
    protected Map<String, String> getAdditionalPdfTitles() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("personalzeiten-wpph", Messages.getString("Common.PersonalzeitenWPPH"));
        result.put("pro-baum", Messages.getString("Wertastung.proBaum"));
        result.put("pro-hektare", Messages.getString("Wertastung.proHektare"));
        result.put("bestand", Messages.getString("Wertastung.Bestand"));
        return result;
    }

    @Override
    protected JPanel createPanelInput() {
        JPanel pnlInput = new JPanel();
        WertastungMainWindow.initTitledBorder(pnlInput, Messages.getString("Common.TitelEingaben"));
        pnlInput.setLayout(new BoxLayout(pnlInput, 3));
        pnlInput.add(Box.createVerticalStrut(5));
        this.panelBestand = new WertastungBestandPanel(this);
        pnlInput.add(this.panelBestand);
        pnlInput.add(Box.createVerticalStrut(10));
        this.panelWertastung = new WertastungPanel(this);
        pnlInput.add(this.panelWertastung);
        pnlInput.add(Box.createVerticalStrut(10));
        this.panelPersonal = new SimplePersonalPanel(this, false);
        pnlInput.add(this.panelPersonal);
        pnlInput.add(Box.createVerticalStrut(10));
        this.panelMaterialkosten = new MaterialkostenPanel(this);
        pnlInput.add(this.panelMaterialkosten);
        pnlInput.add(Box.createVerticalGlue());
        pnlInput.add(Box.createRigidArea(new Dimension(1, 220)));
        return pnlInput;
    }

    @Override
    protected void displayErgebnis() {
        WertastungModel model = new WertastungModel();
        model.setBaumart(this.panelBestand.getBaumart());
        model.setAnzahlAstungsbaeumeProHektar(this.panelBestand.getAnzahlBaeume());
        model.setFlaeche_ha(this.panelBestand.getAnzahlHektare());
        model.setHangneigung(this.panelBestand.getHangneigung());
        model.setEtappe(this.panelWertastung.getEtappe());
        model.setMethode(this.panelWertastung.getMethode());
        model.setHoehe1(this.panelWertastung.getHoeheUnten());
        model.setHoehe2(this.panelWertastung.getHoeheOben());
        model.setAstigkeit(this.panelWertastung.getAstigkeit());
        model.setKostenPersonalProPerson(this.panelPersonal.getKostenPersonalProPerson_proH());
        model.setFaktorWegzeitenUndPausen(this.panelPersonal.getFaktorWegzeitenUndPausen());
        model.setKorrekturfaktorMaterialkosten(this.panelMaterialkosten.getKorrekturfaktorMaterialkosten());
        WertastungErgebnis ergebnis = model.getErgebnis();
        this.panelErgebnis.setErgebnis(ergebnis);
    }

    @Override
    protected JPanel createPanelOutput() {
        this.panelErgebnis = new WertastungErgebnisPanel(this);
        return this.panelErgebnis;
    }
}

