/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.main;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.ergebnis.RueckegassenErgebnisPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.MaterialkostenAbsolutPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.RueckegassenObjektPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.RueckegassenPersonalPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.RueckegassenVerfahrenPanel;
import ch.wsl.fps.juwapfl.model.RueckegassenErgebnis;
import ch.wsl.fps.juwapfl.model.RueckegassenModel;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class RueckegassenMainWindow
extends AbstractMainWindow {
    private RueckegassenObjektPanel panelObjekt;
    private RueckegassenVerfahrenPanel panelVerfahren;
    private RueckegassenPersonalPanel panelPersonal;
    private MaterialkostenAbsolutPanel panelMaterialkosten;
    private RueckegassenErgebnisPanel panelErgebnis;

    public static void main(String[] args) {
        RueckegassenMainWindow.main(args, () -> {
            RueckegassenMainWindow rueckegassenMainWindow = new RueckegassenMainWindow();
        });
    }

    public RueckegassenMainWindow() {
        this.setTitle(Messages.getString("Rueckegassen.FensterTitel"));
        this.setSize(this.getWindowSize(520), this.getWindowSize(670));
        this.init();
    }

    @Override
    protected String[] getDokuPdfFileNames() {
        return new String[]{"DokuRueckegassenA.pdf", "DokuRueckegassenB.pdf"};
    }

    @Override
    protected JPanel createPanelInput() {
        JPanel pnlInput = new JPanel();
        RueckegassenMainWindow.initTitledBorder(pnlInput, Messages.getString("Common.TitelEingaben"));
        pnlInput.setLayout(new BoxLayout(pnlInput, 3));
        pnlInput.add(Box.createVerticalStrut(5));
        this.panelObjekt = new RueckegassenObjektPanel(this);
        pnlInput.add(this.panelObjekt);
        pnlInput.add(Box.createVerticalStrut(10));
        this.panelVerfahren = new RueckegassenVerfahrenPanel(this);
        pnlInput.add(this.panelVerfahren);
        pnlInput.add(Box.createVerticalStrut(10));
        this.panelPersonal = new RueckegassenPersonalPanel(this);
        pnlInput.add(this.panelPersonal);
        pnlInput.add(Box.createVerticalStrut(10));
        this.panelMaterialkosten = new MaterialkostenAbsolutPanel(this);
        pnlInput.add(this.panelMaterialkosten);
        pnlInput.add(Box.createVerticalGlue());
        pnlInput.add(Box.createRigidArea(new Dimension(1, 220)));
        return pnlInput;
    }

    @Override
    protected JPanel createPanelOutput() {
        this.panelErgebnis = new RueckegassenErgebnisPanel(this);
        return this.panelErgebnis;
    }

    @Override
    protected String getModelAsXmlString() {
        String xmlModelName = "<modellname>" + Messages.getString("Rueckegassen.Titel") + "</modellname>";
        String xmlInfo = this.getMetaInformationAsXmlString();
        String xmlPdfTitles = this.getPdfTitlesAsXmlString();
        String xmlEingaben = "<eingaben>";
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelObjekt.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelVerfahren.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelPersonal.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelMaterialkosten.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + "</eingaben>";
        String xmlErgebnis = RueckegassenMainWindow.getErgebnisAsXmlString(this.panelErgebnis);
        String result = String.valueOf(xmlModelName) + xmlInfo + xmlPdfTitles + xmlEingaben + xmlErgebnis;
        return result;
    }

    @Override
    protected String getXsltFilePath() {
        return "data/kalkulation2fo-rueckegassen.xsl";
    }

    @Override
    protected Map<String, String> getAdditionalPdfTitles() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("personalzeiten-wpph", Messages.getString("Common.PersonalzeitenWPPH"));
        result.put("pro-hektare", Messages.getString("Rueckegassen.proHektare"));
        result.put("gesamtflaeche", Messages.getString("Rueckegassen.proGesamtflaeche"));
        return result;
    }

    @Override
    protected void displayErgebnis() {
        RueckegassenModel model = new RueckegassenModel();
        model.setFlaeche_ha(this.panelObjekt.getAnzahlHektare());
        model.setVerhaeltnisse(this.panelObjekt.getVerhaeltnisse());
        model.setAbstandRueckegassen_m(this.panelObjekt.getAbstandRueckegassen_m());
        model.setHilfskraft(this.panelVerfahren.getHilfskraft());
        model.setOrtskenntnisse(this.panelVerfahren.getOrtskenntnisse());
        model.setUebungPlanungsverfahren(this.panelVerfahren.getUebungPlanungsverfahren());
        model.setKostenHauptperson_proH(this.panelPersonal.getKostenHauptperson().intValue());
        model.setKostenHilfskraft_proH(this.panelPersonal.getKostenHilfskraft().intValue());
        model.setKostenGeraete_proH(this.panelMaterialkosten.getMaterialkosten());
        model.setFaktorWegzeitenUndPausen(this.panelPersonal.getFaktorWegzeitenUndPausen());
        RueckegassenErgebnis ergebnis = model.getErgebnis();
        this.panelErgebnis.setErgebnis(ergebnis);
    }
}

