/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.main;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.ergebnis.PflanzungErgebnisPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.PflanzungPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.PflanzungPersonalPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.PflanzungWinkelpflanzungPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.PflanzungZeitenKostenPanel;
import ch.wsl.fps.juwapfl.model.PflanzungErgebnis;
import ch.wsl.fps.juwapfl.model.PflanzungModel;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class PflanzungMainWindow
extends AbstractMainWindow {
    private PflanzungPanel panelPflanzung;
    private PflanzungWinkelpflanzungPanel panelPflanzungWinkelpflanzung;
    private PflanzungZeitenKostenPanel panelPflanzungZeitenKosten;
    private PflanzungPersonalPanel panelPersonal;
    private PflanzungErgebnisPanel panelErgebnis;

    public static void main(String[] args) {
        AbstractMainWindow.main(args, () -> {
            PflanzungMainWindow pflanzungMainWindow = new PflanzungMainWindow();
        });
    }

    public PflanzungMainWindow() {
        this.setTitle(Messages.getString("Pflanzung.FensterTitel"));
        this.setSize(this.getWindowSize(780), this.getWindowSize(900));
        this.init();
    }

    @Override
    protected String[] getDokuPdfFileNames() {
        String[] stringArray = new String[2];
        stringArray[0] = "DokuPflanzung.pdf";
        return stringArray;
    }

    @Override
    protected JPanel createPanelInput() {
        JPanel pnlInput = new JPanel();
        PflanzungMainWindow.initTitledBorder(pnlInput, Messages.getString("Common.TitelEingaben"));
        pnlInput.setLayout(new BoxLayout(pnlInput, 3));
        pnlInput.add(Box.createVerticalStrut(5));
        this.panelPflanzung = new PflanzungPanel(this);
        pnlInput.add(this.panelPflanzung);
        pnlInput.add(Box.createVerticalStrut(10));
        this.panelPflanzungWinkelpflanzung = new PflanzungWinkelpflanzungPanel(this);
        pnlInput.add(this.panelPflanzungWinkelpflanzung);
        pnlInput.add(Box.createVerticalStrut(10));
        this.panelPflanzungZeitenKosten = new PflanzungZeitenKostenPanel(this);
        pnlInput.add(this.panelPflanzungZeitenKosten);
        pnlInput.add(Box.createVerticalStrut(10));
        this.panelPersonal = new PflanzungPersonalPanel(this);
        pnlInput.add(this.panelPersonal);
        pnlInput.add(Box.createVerticalGlue());
        pnlInput.add(Box.createRigidArea(new Dimension(1, 220)));
        return pnlInput;
    }

    @Override
    protected JPanel createPanelOutput() {
        this.panelErgebnis = new PflanzungErgebnisPanel(this);
        return this.panelErgebnis;
    }

    @Override
    protected String getModelAsXmlString() {
        String xmlModelName = "<modellname>" + Messages.getString("Pflanzung.Titel") + "</modellname>";
        String xmlInfo = this.getMetaInformationAsXmlString();
        String xmlPdfTitles = this.getPdfTitlesAsXmlString();
        String xmlEingaben = "<eingaben>";
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelPflanzung.getAsXmlString();
        if (this.panelPflanzung.isWiedeholzhaueWinkelpflanzung()) {
            xmlEingaben = String.valueOf(xmlEingaben) + this.panelPflanzungWinkelpflanzung.getAsXmlString();
        }
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelPflanzungZeitenKosten.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelPersonal.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + "</eingaben>";
        String xmlErgebnis = PflanzungMainWindow.getErgebnisAsXmlString(this.panelErgebnis);
        String result = String.valueOf(xmlModelName) + xmlInfo + xmlPdfTitles + xmlEingaben + xmlErgebnis;
        return result;
    }

    @Override
    protected String getXsltFilePath() {
        return "data/kalkulation2fo-pflanzung.xsl";
    }

    @Override
    protected Map<String, String> getAdditionalPdfTitles() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("beschaffung", Messages.getString("Pflanzung.Pdf.Beschaffung"));
        result.put("transport", Messages.getString("Pflanzung.Pdf.Transport"));
        result.put("pflanzung", Messages.getString("Pflanzung.Pdf.Pflanzung"));
        result.put("unterhalt", Messages.getString("Pflanzung.Pdf.Unterhalt"));
        result.put("gesamt", Messages.getString("Pflanzung.Pdf.Gesamt"));
        return result;
    }

    @Override
    protected void onInputChangedBeforeCalculation() {
        this.panelPflanzung.onInputChangedBeforeCalculation();
        this.panelPflanzungZeitenKosten.onInputChangedBeforeCalculation(this.panelPflanzung.getPflanzwerkzeug(), this.panelPflanzung.getPflanztechnik(), this.panelPflanzung.getBaumart(), this.panelPflanzung.getSchwierigkeitsgrad(), this.panelPflanzungWinkelpflanzung.getWinkelpflanzungModel());
        this.panelPflanzungWinkelpflanzung.setEnabled(this.panelPflanzung.isWiedeholzhaueWinkelpflanzung());
    }

    @Override
    protected void displayErgebnis() {
        PflanzungModel model = new PflanzungModel();
        model.setAnzahlPflanzen(this.panelPflanzung.getAnzahlPflanzen());
        model.setPflanzwerkzeug(this.panelPflanzung.getPflanzwerkzeug());
        model.setPflanztechnik(this.panelPflanzung.getPflanztechnik());
        model.setBaumart(this.panelPflanzung.getBaumart());
        model.setSchwierigkeitsgrad(this.panelPflanzung.getSchwierigkeitsgrad());
        model.setWinkelpflanzungModel(this.panelPflanzungWinkelpflanzung.getWinkelpflanzungModel());
        model.setZeitBeschaffung_h(this.panelPflanzungZeitenKosten.getZeitBeschaffung_h());
        model.setKostenProPflanze(this.panelPflanzungZeitenKosten.getKostenProPflanze());
        model.setZeitTransport_h(this.panelPflanzungZeitenKosten.getZeitTransport_h());
        model.setKostenTransportmittel(this.panelPflanzungZeitenKosten.getKostenTransportmittel());
        model.setZeitPflanzung_PflProH(this.panelPflanzungZeitenKosten.getZeitPflanzung_PflProH());
        model.setAnteilMaschinenlaufzeit_Prz(this.panelPflanzungZeitenKosten.getAnteilMaschinenlaufzeit_Prz());
        model.setKostensatzGeraet_proH(this.panelPflanzungZeitenKosten.getKostensatzGeraet_proH());
        model.setZeitUnterhalt_Prozent(this.panelPflanzungZeitenKosten.getZeitUnterhalt_Prozent());
        model.setKostenPersonalProPerson_proH(this.panelPersonal.getKostenPersonalProPerson_proH());
        model.setFaktorWegzeitenUndPausen(this.panelPersonal.getFaktorWegzeitenUndPausen());
        PflanzungErgebnis ergebnis = model.getErgebnis();
        this.panelErgebnis.setErgebnis(ergebnis);
    }
}

