/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.main;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.CurrencySensitive;
import ch.wsl.fps.juwapfl.gui.DocumentionHelper;
import ch.wsl.fps.juwapfl.gui.JuWaPflExceptionHandler;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.controls.TitledBorderWithInfoButton;
import ch.wsl.fps.juwapfl.gui.main.JuWaPflMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.ergebnis.AbstractErgebnisPanel;
import ch.wsl.fps.juwapfl.util.DatenblattCreator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatter;

public abstract class AbstractMainWindow
extends JFrame {
    private static boolean LOG_TO_FILE = false;
    protected static float SIZE = 1.0f;
    protected static float WIDTH_FACTOR = 1.0f;
    private final JTextField txtArbeitsort = new JTextField();
    private boolean reactOnInputChange = true;
    private final ActionListener defaultActionListener = e -> this.inputChanged();
    private final ChangeListener defaultChangeListener = e -> this.inputChanged();
    private final ItemListener defaultItemListener = e -> {
        if (e.getStateChange() == 1) {
            this.inputChanged();
        }
    };
    private final String defaultDir = AbstractMainWindow.isStartedFromJar() ? "." : "./data";
    private String currency;
    private final List<CurrencySensitive> currencyObservers = new ArrayList<CurrencySensitive>();
    public volatile boolean isInitializing = true;

    private static boolean isStartedFromJar() {
        return AbstractMainWindow.class.getResource("AbstractMainWindow.class").toString().startsWith("rsrc");
    }

    protected static void main(String[] args, Runnable windowToStart) {
        String arg;
        int i = 0;
        while (i < args.length) {
            arg = args[i];
            System.out.println("arg" + i + ": " + arg);
            if (arg.equalsIgnoreCase("-logtofile") || arg.equalsIgnoreCase("logtofile")) {
                LOG_TO_FILE = true;
            } else if (arg.equalsIgnoreCase("-logdialog") || arg.equalsIgnoreCase("logdialog")) {
                JuWaPflExceptionHandler.setLogDialog(true);
            } else if (arg.equalsIgnoreCase("-stacktrace") || arg.equalsIgnoreCase("stacktrace")) {
                JuWaPflExceptionHandler.setLogStackTrace(true);
            }
            ++i;
        }
        if (LOG_TO_FILE) {
            try {
                FileOutputStream os = new FileOutputStream("juwapfl.log", true);
                PrintStream ps = new PrintStream(os);
                System.setOut(ps);
                System.setErr(ps);
            }
            catch (FileNotFoundException e2) {
                JuWaPflExceptionHandler.handle(e2);
            }
        }
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> JuWaPflExceptionHandler.handle(e, "Uncaught Exception in Thread " + t + "\n"));
        System.out.println("Default Locale: " + Locale.getDefault());
        if (Locale.getDefault().getLanguage().equals(Locale.FRENCH.getLanguage())) {
            JuWaPflMainWindow.setJuWaPflLocale(new Locale("fr"));
        }
        if (Locale.getDefault().getLanguage().equals(Locale.ITALIAN.getLanguage())) {
            JuWaPflMainWindow.setJuWaPflLocale(new Locale("it"));
        }
        i = 0;
        while (i < args.length) {
            arg = args[i];
            System.out.println("arg" + i + ": " + arg);
            if (arg.equalsIgnoreCase("-fr") || arg.equalsIgnoreCase("fr")) {
                JuWaPflMainWindow.setJuWaPflLocale(new Locale("fr"));
            } else if (arg.equalsIgnoreCase("-de") || arg.equalsIgnoreCase("de")) {
                JuWaPflMainWindow.setJuWaPflLocale(new Locale("de"));
            } else if (arg.equalsIgnoreCase("-en") || arg.equalsIgnoreCase("en")) {
                JuWaPflMainWindow.setJuWaPflLocale(new Locale("en"));
            } else if (arg.equalsIgnoreCase("-it") || arg.equalsIgnoreCase("it")) {
                JuWaPflMainWindow.setJuWaPflLocale(new Locale("it"));
            }
            ++i;
        }
        SwingUtilities.invokeLater(() -> {
            AbstractMainWindow.loadLookAndFeel();
            Font defaultFont = new JLabel().getFont();
            SIZE = (float)defaultFont.getSize() / 11.0f;
            SIZE = Math.max(1.0f, SIZE);
            if (System.getProperty("os.name") != null && System.getProperty("os.name").indexOf("Mac") >= 0) {
                WIDTH_FACTOR = 1.15f;
            }
            ToolTipManager.sharedInstance().setInitialDelay(0);
            ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
            windowToStart.run();
        });
    }

    private static void loadLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            JuWaPflExceptionHandler.handle(e);
        }
    }

    protected AbstractMainWindow() {
        this.setLocationByPlatform(true);
    }

    protected void init() {
        this.setDefaultCloseOperation(2);
        this.initContent();
        this.setCurrency("CHF");
        this.onInputChangedBeforeCalculation();
        this.displayErgebnis();
        this.setIconImage(Utilities.getWslLogo().getImage());
        this.setVisible(true);
        this.isInitializing = false;
    }

    private void initContent() {
        this.createMenu();
        this.setLayout(new BorderLayout());
        this.add((Component)this.createPanelArbeitsort(), "First");
        this.add((Component)this.createPanelInput(), "Center");
        this.add((Component)this.createPanelOutput(), "Last");
    }

    private void createMenu() {
        final String[] dokuPdfFiles = this.getDokuPdfFileNames();
        this.setJMenuBar(new JMenuBar());
        JMenu menuFile = new JMenu(Messages.getString("Common.MenuDatei"));
        this.getJMenuBar().add(menuFile);
        if (dokuPdfFiles[1] == null) {
            menuFile.add(new AbstractAction(Messages.getString("Common.MenuModellDokuOeffnen")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread(() -> DocumentionHelper.openDocumentationPdfFile(dokuPdfFiles[0])).start();
                }
            });
        } else {
            JMenu menuDocumentation = new JMenu(Messages.getString("Common.MenuModellDokuOeffnen"));
            menuFile.add(menuDocumentation);
            menuDocumentation.add(new AbstractAction(Messages.getString("Common.MenuModellDokuTeilA")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread(() -> DocumentionHelper.openDocumentationPdfFile(dokuPdfFiles[0])).start();
                }
            });
            menuDocumentation.add(new AbstractAction(Messages.getString("Common.MenuModellDokuTeilB")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread(() -> DocumentionHelper.openDocumentationPdfFile(dokuPdfFiles[1])).start();
                }
            });
        }
        menuFile.add(new AbstractAction(Messages.getString("Common.MenuDatenblattErstellen")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatenblattCreator.preInitializeInSeparateThread();
                File pdfFile = AbstractMainWindow.this.getDatenblattFile();
                if (pdfFile == null) {
                    return;
                }
                new Thread(() -> AbstractMainWindow.this.createAndOpenDatenblattPdf(pdfFile)).start();
            }
        });
        menuFile.addSeparator();
        menuFile.add(new AbstractAction(Messages.getString("Common.MenuBeenden")){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        JLabel lblPlaceholder = new JLabel("   ");
        lblPlaceholder.setPreferredSize(new Dimension(5, 1));
        this.getJMenuBar().add(lblPlaceholder);
        JMenu menuCurrency = new JMenu(Messages.getString("Common.MenuWaehrungseinheit"));
        this.getJMenuBar().add(menuCurrency);
        JRadioButtonMenuItem menuCHF = new JRadioButtonMenuItem("CHF", true);
        menuCHF.addActionListener(e -> this.setCurrency("CHF"));
        menuCurrency.add(menuCHF);
        JRadioButtonMenuItem menuEUR = new JRadioButtonMenuItem("EUR", false);
        menuEUR.addActionListener(e -> this.setCurrency("EUR"));
        menuCurrency.add(menuEUR);
        ButtonGroup group = new ButtonGroup();
        group.add(menuCHF);
        group.add(menuEUR);
    }

    private JPanel createPanelArbeitsort() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 2));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 10, 8, 10));
        panel.add(new JLabel(Messages.getString("Common.Arbeitsort")));
        String textInfoButton = Messages.getString("Common.InfoButtonArbeitsort");
        panel.add(Utilities.getPanelWithInfoButton(this.txtArbeitsort, textInfoButton));
        return panel;
    }

    protected abstract String[] getDokuPdfFileNames();

    protected abstract JPanel createPanelInput();

    protected abstract JPanel createPanelOutput();

    private File getDatenblattFile() {
        String defaultfileName = Messages.getString("Common.DatenblattDefaultFilename");
        JFileChooser fileChooser = new JFileChooser(this.defaultDir){

            @Override
            public void approveSelection() {
                File file = this.getSelectedFile();
                if (!file.getName().toLowerCase().endsWith(".pdf")) {
                    file = new File(String.valueOf(file.getPath()) + ".pdf");
                    this.setSelectedFile(file);
                }
                if (file.exists() && this.getDialogType() == 1) {
                    int result = JOptionPane.showConfirmDialog(this, Messages.getString("Common.DateiExistiertBereitsUeberschreiben"), Messages.getString("Common.ButtonSpeichern"), 1);
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case -1: 
                        case 1: {
                            return;
                        }
                        case 2: {
                            this.cancelSelection();
                            return;
                        }
                    }
                }
                super.approveSelection();
            }
        };
        fileChooser.setSelectedFile(new File(defaultfileName));
        if (fileChooser.showSaveDialog(this) != 0) {
            return null;
        }
        return fileChooser.getSelectedFile();
    }

    private void createAndOpenDatenblattPdf(File pdfFile) {
        DatenblattCreator pdfCreator = new DatenblattCreator();
        pdfCreator.create(this.getModelAsXmlString(), pdfFile, this.getXsltFilePath());
        try {
            Desktop.getDesktop().open(pdfFile);
        }
        catch (IOException e) {
            JuWaPflExceptionHandler.handle(e);
        }
    }

    protected abstract String getModelAsXmlString();

    protected static String getErgebnisAsXmlString(AbstractErgebnisPanel<?, ?> panelErgebnis) {
        StringBuilder sb = new StringBuilder();
        sb.append("<ergebnis>\n");
        String[][] lines = panelErgebnis.getErgebnisAsStringArray();
        AbstractMainWindow.doErgebnisXmlStringSanityCheck(lines);
        String[][] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] line = stringArray[n2];
            if (line.length == 0) {
                sb.append("\t<leerzeile/>\n");
            } else {
                sb.append("\t<ergebniszeile>\n");
                int i = 0;
                while (i < line.length) {
                    sb.append("\t\t<spalte" + i + ">");
                    sb.append(line[i]);
                    sb.append("</spalte" + i + ">\n");
                    ++i;
                }
                sb.append("\t</ergebniszeile>\n");
            }
            ++n2;
        }
        sb.append("</ergebnis>\n");
        return sb.toString();
    }

    private static void doErgebnisXmlStringSanityCheck(String[][] lines) {
        int lineLength = -1;
        int i = 0;
        while (i < lines.length) {
            if (lines[i] != null && lines[i].length > 0) {
                if (lineLength < 0) {
                    lineLength = lines[i].length;
                } else if (lineLength != lines[i].length) {
                    throw new IllegalStateException("ergebnisXmlString has wrong format.");
                }
            }
            ++i;
        }
    }

    protected abstract String getXsltFilePath();

    protected String getMetaInformationAsXmlString() {
        StringBuilder sb = new StringBuilder();
        String arbeitsort = this.txtArbeitsort.getText();
        sb.append("<info>\n");
        if (arbeitsort.length() > 0) {
            sb.append("\t<arbeitsort>");
            sb.append(arbeitsort);
            sb.append("\t</arbeitsort>\n");
        }
        sb.append("\t<creationdate>");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");
        sb.append(formatter.format(LocalDateTime.now()));
        sb.append("\t</creationdate>\n");
        sb.append("\t<currency>");
        sb.append(this.getCurrency());
        sb.append("</currency>\n");
        sb.append("</info>\n");
        return sb.toString();
    }

    protected final String getPdfTitlesAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<pdftitles>\n");
        sb.append("\t<haupttitel>");
        sb.append(Messages.getString("Pdf.Haupttitel"));
        sb.append("</haupttitel>\n");
        sb.append("\t<arbeitsort>");
        sb.append(Messages.getString("Common.Arbeitsort"));
        sb.append("</arbeitsort>\n");
        sb.append("\t<ergebnis>");
        sb.append(Messages.getString("Common.TitelErgebnis"));
        sb.append("</ergebnis>\n");
        sb.append("\t<zeiten>");
        sb.append(Messages.getString("Common.TitelZeiten"));
        sb.append("</zeiten>\n");
        sb.append("\t<kosten>");
        sb.append(Messages.getString("Common.ErgebnisKosten"));
        sb.append("</kosten>\n");
        Map<String, String> additionalPdfTitles = this.getAdditionalPdfTitles();
        for (String key : additionalPdfTitles.keySet()) {
            sb.append("\t<" + key + ">");
            sb.append(additionalPdfTitles.get(key));
            sb.append("</" + key + ">\n");
        }
        sb.append("</pdftitles>\n");
        return sb.toString();
    }

    protected Map<String, String> getAdditionalPdfTitles() {
        return Collections.emptyMap();
    }

    private void inputChanged() {
        if (this.reactOnInputChange) {
            this.reactOnInputChange = false;
            this.onInputChangedBeforeCalculation();
            this.reactOnInputChange = true;
            this.displayErgebnis();
        }
    }

    protected void onInputChangedBeforeCalculation() {
    }

    protected abstract void displayErgebnis();

    public static void initTitledBorder(JPanel panel, String title) {
        TitledBorderWithInfoButton border = new TitledBorderWithInfoButton(title);
        panel.setBorder(border);
    }

    public ActionListener getDefaultActionListener() {
        return this.defaultActionListener;
    }

    public ChangeListener getDefaultChangeListener() {
        return this.defaultChangeListener;
    }

    public ItemListener getDefaultItemListener() {
        return this.defaultItemListener;
    }

    public static final void adjustJSpinnerFormatter(JSpinner spinner, boolean isPercentageField) {
        JFormattedTextField textField = ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField();
        DefaultFormatter formatter = (DefaultFormatter)textField.getFormatter();
        formatter.setCommitsOnValidEdit(true);
        textField.addPropertyChangeListener(e -> {
            if ("editValid".equals(e.getPropertyName())) {
                if (Boolean.FALSE.equals(e.getNewValue())) {
                    DecimalFormat df = isPercentageField ? new DecimalFormat("#.##%") : new DecimalFormat("#.##");
                    SpinnerNumberModel model = (SpinnerNumberModel)spinner.getModel();
                    textField.setBackground(Color.YELLOW);
                    textField.setToolTipText(String.valueOf(Messages.getString("Common.WertMussZwischenMinUndMaxLiegenA")) + " " + df.format(model.getMinimum()) + " " + Messages.getString("Common.WertMussZwischenMinUndMaxLiegenB") + " " + df.format(model.getMaximum()) + " " + Messages.getString("Common.WertMussZwischenMinUndMaxLiegenC"));
                } else {
                    textField.setBackground(Color.WHITE);
                    textField.setToolTipText(null);
                }
            }
        });
    }

    public void registerForCurrencyUpdates(CurrencySensitive observer) {
        this.currencyObservers.add(observer);
    }

    protected void setCurrency(String currency) {
        this.currency = currency;
        this.currencyObservers.forEach(obs -> obs.updateCurrency());
    }

    public String getCurrency() {
        return this.currency;
    }

    protected int getWindowSize(int originalSize) {
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            return (int)(1.15 * (double)originalSize);
        }
        return originalSize;
    }
}

