/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.controls;

import java.awt.Color;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;

public class JFlashingSpinner
extends JSpinner {
    private static final Color NORMAL_COLOR = new Color(255, 255, 255);
    private static final Color HIGHLIGHT_COLOR = new Color(128, 192, 128);
    private static final int PAUSE_LENGTH_INIITAL = 4000;
    private static final int PAUSE_LENGTH = 80;
    private static final int ROUNDS = 22;
    private volatile boolean isFlashing = false;
    private volatile boolean reset = false;
    private final Lock lock = new ReentrantLock();

    public JFlashingSpinner(SpinnerNumberModel spinnerNumberModel) {
        super(spinnerNumberModel);
    }

    public void flash() {
        this.lock.lock();
        try {
            if (this.isFlashing) {
                this.reset = true;
                return;
            }
            this.isFlashing = true;
        }
        finally {
            this.lock.unlock();
        }
        Thread t = new Thread(() -> {
            SwingUtilities.invokeLater(() -> this.getTf().setBackground(HIGHLIGHT_COLOR));
            this.safeSleepInitial();
            this.lock.lock();
            int i = 1;
            while (i <= 22 || this.reset) {
                this.lock.unlock();
                this.safeSleep();
                if (this.reset) {
                    this.reset = false;
                    i = 0;
                    SwingUtilities.invokeLater(() -> this.getTf().setBackground(HIGHLIGHT_COLOR));
                    this.safeSleepInitial();
                }
                int highlightR = HIGHLIGHT_COLOR.getRed();
                int targetR = NORMAL_COLOR.getRed();
                int newR = highlightR + (targetR - highlightR) * i / 22;
                int highlightG = HIGHLIGHT_COLOR.getGreen();
                int targetG = NORMAL_COLOR.getGreen();
                int newG = highlightG + (targetG - highlightG) * i / 22;
                int highlightB = HIGHLIGHT_COLOR.getBlue();
                int targetB = NORMAL_COLOR.getBlue();
                int newB = highlightB + (targetB - highlightB) * i / 22;
                Color newColor = new Color(newR, newG, newB);
                SwingUtilities.invokeLater(() -> this.getTf().setBackground(newColor));
                this.lock.lock();
                ++i;
            }
            this.isFlashing = false;
            this.lock.unlock();
        });
        t.start();
    }

    private JTextField getTf() {
        return ((JSpinner.NumberEditor)this.getEditor()).getTextField();
    }

    private void safeSleepInitial() {
        try {
            int STEPS = 10;
            int i = 0;
            while (i < 10) {
                if (this.reset) {
                    return;
                }
                Thread.sleep(400L);
                ++i;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void safeSleep() {
        try {
            int STEPS = 5;
            int i = 0;
            while (i < 5) {
                if (this.reset) {
                    return;
                }
                Thread.sleep(16L);
                ++i;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

