/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.model;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.model.AbstractModel;
import ch.wsl.fps.juwapfl.model.ZBaumDurchforstungErgebnis;

public class ZBaumDurchforstungModel
extends AbstractModel {
    public static final double DEFAULT_KOSTEN_KRONENSCHNITT_PRO_BAUM_UNTEN = 0.1;
    public static final double DEFAULT_KOSTEN_KRONENSCHNITT_PRO_BAUM_OBEN = 0.25;
    private double flaeche_ha;
    private Entwicklungsstufe entwicklungsstufe;
    private int anzahlZBaeumeProHa;
    private double anzahlKonkurrentenProZBaum;
    private Hangneigung hangneigung;
    private Belaubung belaubung;
    private Verunkrautung verunkrautung;
    private RueckegassenVorhanden rueckegassenVorhanden;
    private Temperatur temperatur;
    private int anzahlZBaeumeMitKronenschnittProHektare;
    private Baendeln baendeln;
    private Zersaegen zersaegen;
    private AusfuehrungshoeheKronenschnitt ausfuehrungshoeheKronenschnitt;
    private double kostenPersonal_proH;
    private double kostenMotorsaege_proLiter;
    private double kostenKronenschnittUnten_proBaum;
    private double kostenKronenschnittOben_proBaum;
    private double faktorWegzeitenUndPausen;

    public void setFlaeche_ha(double flaeche_ha) {
        this.flaeche_ha = flaeche_ha;
    }

    public void setEntwicklungsstufe(Entwicklungsstufe entwicklungsstufe) {
        this.entwicklungsstufe = entwicklungsstufe;
    }

    public void setAnzahlZBaeumeProHa(int anzahlZBaeumeProHa) {
        this.anzahlZBaeumeProHa = anzahlZBaeumeProHa;
    }

    public void setAnzahlKonkurrentenProZBaum(double anzahlKonkurrentenProZBaum) {
        this.anzahlKonkurrentenProZBaum = anzahlKonkurrentenProZBaum;
    }

    public void setHangneigung(Hangneigung hangneigung) {
        this.hangneigung = hangneigung;
    }

    public void setBelaubung(Belaubung belaubung) {
        this.belaubung = belaubung;
    }

    public void setVerunkrautung(Verunkrautung verunkrautung) {
        this.verunkrautung = verunkrautung;
    }

    public void setRueckegassenVorhanden(RueckegassenVorhanden rueckegassenVorhanden) {
        this.rueckegassenVorhanden = rueckegassenVorhanden;
    }

    public void setTemperatur(Temperatur temperatur) {
        this.temperatur = temperatur;
    }

    public void setAnzahlZBaeumeMitKronenschnittProHektare(int anzahlZBaeumeMitKronenschnittProHektare) {
        this.anzahlZBaeumeMitKronenschnittProHektare = anzahlZBaeumeMitKronenschnittProHektare;
    }

    public void setBaendeln(Baendeln baendeln) {
        this.baendeln = baendeln;
    }

    public void setZersaegen(Zersaegen zersaegen) {
        this.zersaegen = zersaegen;
    }

    public void setAusfuehrungshoeheKronenschnitt(AusfuehrungshoeheKronenschnitt ausfuehrungshoeheKronenschnitt) {
        this.ausfuehrungshoeheKronenschnitt = ausfuehrungshoeheKronenschnitt;
    }

    public void setKostenPersonal_proH(double kostenPersonal_proH) {
        this.kostenPersonal_proH = kostenPersonal_proH;
    }

    public void setKostenMotorsaege_proLiter(double kostenMotorsaege_proLiter) {
        this.kostenMotorsaege_proLiter = kostenMotorsaege_proLiter;
    }

    public void setKostenKronenschnittUnten_proBaum(double kostenKronenschnittUnten_proBaum) {
        this.kostenKronenschnittUnten_proBaum = kostenKronenschnittUnten_proBaum;
    }

    public void setKostenKronenschnittOben_proBaum(double kostenKronenschnittOben_proBaum) {
        this.kostenKronenschnittOben_proBaum = kostenKronenschnittOben_proBaum;
    }

    public void setFaktorWegzeitenUndPausen(double faktorWegzeitenUndPausen) {
        this.faktorWegzeitenUndPausen = faktorWegzeitenUndPausen;
    }

    @Override
    public ZBaumDurchforstungErgebnis getErgebnis() {
        ZBaumDurchforstungErgebnis ergebnis = new ZBaumDurchforstungErgebnis();
        double psh15_basic = this.entwicklungsstufe.getPsh15(this.anzahlZBaeumeProHa);
        double kf1 = 0.9 + this.anzahlKonkurrentenProZBaum / 20.0;
        double kf2 = this.baendeln.getKorrekturfaktor(this.anzahlZBaeumeProHa);
        double kf3 = this.hangneigung.getKorrekturfaktor();
        double kf4 = this.belaubung.getKorrekturfaktor(this.entwicklungsstufe);
        double kf5 = this.verunkrautung.getKorrekturfaktor(this.entwicklungsstufe);
        double kf6 = this.rueckegassenVorhanden.getKorrekturfaktor();
        double kf7 = this.zersaegen.getKorrekturfaktor();
        double kf8 = this.temperatur.getKorrekturfaktor();
        double kf9 = this.ausfuehrungshoeheKronenschnitt.getKorrekturfaktor(this.entwicklungsstufe, this.anzahlZBaeumeMitKronenschnittProHektare);
        double pph15_proHa = (psh15_basic * kf1 * kf7 * kf8 + kf2 + kf9) * kf3 * kf4 * kf5 * kf6;
        double wpsh_proHa = pph15_proHa * 1.1 * this.faktorWegzeitenUndPausen;
        double anzahlKonkurrentenProHa = (double)this.anzahlZBaeumeProHa * this.anzahlKonkurrentenProZBaum;
        double treibstoffverbrauchProHa = this.entwicklungsstufe.getTreibstoffverbrauchProHa(anzahlKonkurrentenProHa, this.zersaegen);
        double geraetekostenKronenschnittProHa = this.ausfuehrungshoeheKronenschnitt.getGeraetekostenProHa(this);
        double kostenPersonalProHa = wpsh_proHa * this.kostenPersonal_proH;
        double kostenMotorsaegeProHa = treibstoffverbrauchProHa * this.kostenMotorsaege_proLiter;
        ergebnis.setAnzahlZBaeumeProHektar(this.anzahlZBaeumeProHa);
        ergebnis.setFlaecheBestand_ha(this.flaeche_ha);
        ergebnis.setZeitPersonal_WPSHProHa(wpsh_proHa);
        ergebnis.setKostenPersonal_proHa(kostenPersonalProHa);
        ergebnis.setKostenMotorsaege_proHa(kostenMotorsaegeProHa);
        ergebnis.setKostenMaterial_proHa(geraetekostenKronenschnittProHa);
        ergebnis.setKostenGesamt_proHa(kostenPersonalProHa + kostenMotorsaegeProHa + geraetekostenKronenschnittProHa);
        return ergebnis;
    }

    public static enum AusfuehrungshoeheKronenschnitt {
        NICHT_VERFUEGBAR,
        BIS_2_EINHALB_METER,
        AB_2_EINHALB_METER_BIS_6_METER;


        public String toString() {
            switch (this) {
                case NICHT_VERFUEGBAR: {
                    return "-";
                }
                case BIS_2_EINHALB_METER: {
                    return Messages.getString("ZBaumDurchforstung.AusfuehrungshoeheKronenschnittTief");
                }
                case AB_2_EINHALB_METER_BIS_6_METER: {
                    return Messages.getString("ZBaumDurchforstung.AusfuehrungshoeheKronenschnittHoch");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static AusfuehrungshoeheKronenschnitt getDefault() {
            return BIS_2_EINHALB_METER;
        }

        public double getKorrekturfaktor(Entwicklungsstufe entwicklungsstufe, int anzahlZBaeumeMitKronenschnitt) {
            if (entwicklungsstufe != Entwicklungsstufe.DICKUNG) {
                return 0.0;
            }
            switch (this) {
                case BIS_2_EINHALB_METER: {
                    return (0.0 + (double)anzahlZBaeumeMitKronenschnitt) / 180.0;
                }
                case AB_2_EINHALB_METER_BIS_6_METER: {
                    return (0.0 + (double)anzahlZBaeumeMitKronenschnitt) / 15.0;
                }
            }
            throw new IllegalStateException(this.name());
        }

        public double getGeraetekostenProHa(ZBaumDurchforstungModel model) {
            if (model.entwicklungsstufe != Entwicklungsstufe.DICKUNG) {
                return 0.0;
            }
            switch (this) {
                case NICHT_VERFUEGBAR: {
                    return 0.0;
                }
                case BIS_2_EINHALB_METER: {
                    return (double)model.anzahlZBaeumeMitKronenschnittProHektare * model.kostenKronenschnittUnten_proBaum;
                }
                case AB_2_EINHALB_METER_BIS_6_METER: {
                    return (double)model.anzahlZBaeumeMitKronenschnittProHektare * model.kostenKronenschnittOben_proBaum;
                }
            }
            throw new IllegalStateException(this.name());
        }

        public static AusfuehrungshoeheKronenschnitt[] values() {
            AusfuehrungshoeheKronenschnitt[] ausfuehrungshoeheKronenschnittArray = ENUM$VALUES;
            int n = ausfuehrungshoeheKronenschnittArray.length;
            AusfuehrungshoeheKronenschnitt[] ausfuehrungshoeheKronenschnittArray2 = new AusfuehrungshoeheKronenschnitt[n];
            System.arraycopy(ENUM$VALUES, 0, ausfuehrungshoeheKronenschnittArray2, 0, n);
            return ausfuehrungshoeheKronenschnittArray2;
        }
    }

    public static enum Baendeln {
        NEIN,
        JA;


        public String toString() {
            switch (this) {
                case NEIN: {
                    return Messages.getString("ZBaumDurchforstung.Baendeln.nein");
                }
                case JA: {
                    return Messages.getString("ZBaumDurchforstung.Baendeln.ja");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Baendeln getDefault() {
            return NEIN;
        }

        public double getKorrekturfaktor(int anzahlZBaeume_proHa) {
            switch (this) {
                case NEIN: {
                    return 0.0;
                }
                case JA: {
                    return (0.5 * (double)anzahlZBaeume_proHa + 30.0) / 60.0;
                }
            }
            throw new IllegalStateException(this.name());
        }
    }

    public static enum Belaubung {
        UNBELAUBT,
        BELAUBT;


        public String toString() {
            switch (this) {
                case UNBELAUBT: {
                    return Messages.getString("ZBaumDurchforstung.Belaubung.unbelaubt");
                }
                case BELAUBT: {
                    return Messages.getString("ZBaumDurchforstung.Belaubung.belaubt");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Belaubung getDefault() {
            return UNBELAUBT;
        }

        public double getKorrekturfaktor(Entwicklungsstufe entwicklungsstufe) {
            switch (this) {
                case UNBELAUBT: {
                    return 1.0;
                }
                case BELAUBT: {
                    if (entwicklungsstufe == Entwicklungsstufe.DICKUNG) {
                        return 1.3;
                    }
                    if (entwicklungsstufe == Entwicklungsstufe.STANGENHOLZ_1) {
                        return 1.2;
                    }
                    throw new IllegalStateException(entwicklungsstufe.name());
                }
            }
            throw new IllegalStateException(this.name());
        }
    }

    public static enum Entwicklungsstufe {
        DICKUNG,
        STANGENHOLZ_1;


        public String toString() {
            switch (this) {
                case DICKUNG: {
                    return Messages.getString("ZBaumDurchforstung.Dickung");
                }
                case STANGENHOLZ_1: {
                    return Messages.getString("ZBaumDurchforstung.Stangenholz1");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Entwicklungsstufe getDefault() {
            return STANGENHOLZ_1;
        }

        public double getPsh15(int anzahlZBaeume_proHa) {
            switch (this) {
                case DICKUNG: {
                    return 0.0224 * (double)anzahlZBaeume_proHa + 1.6226;
                }
                case STANGENHOLZ_1: {
                    return 0.023 * (double)anzahlZBaeume_proHa + 2.4317;
                }
            }
            throw new IllegalStateException(this.name());
        }

        public double getTreibstoffverbrauchProHa(double anzahlKonkurrenten_proHa, Zersaegen zersaegen) {
            switch (this) {
                case DICKUNG: {
                    return (0.005 * anzahlKonkurrenten_proHa - 0.099) * zersaegen.getKorrekturfaktor();
                }
                case STANGENHOLZ_1: {
                    return (0.0076 * anzahlKonkurrenten_proHa + 0.8371) * zersaegen.getKorrekturfaktor();
                }
            }
            throw new IllegalStateException(this.name());
        }
    }

    public static enum Hangneigung {
        HN_0_BIS_24_PROZENT,
        HN_25_BIS_44_PROZENT,
        HN_45_BIS_64_PROZENT,
        HN_65_BIS_84_PROZENT,
        HN_85_BIS_200_PROZENT;


        public String toString() {
            switch (this) {
                case HN_0_BIS_24_PROZENT: {
                    return "0 - 24%";
                }
                case HN_25_BIS_44_PROZENT: {
                    return "25 - 44%";
                }
                case HN_45_BIS_64_PROZENT: {
                    return "45 - 64%";
                }
                case HN_65_BIS_84_PROZENT: {
                    return "65 - 84%";
                }
                case HN_85_BIS_200_PROZENT: {
                    return ">= 85%";
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Hangneigung getDefault() {
            return HN_0_BIS_24_PROZENT;
        }

        public double getKorrekturfaktor() {
            switch (this) {
                case HN_0_BIS_24_PROZENT: {
                    return 1.0;
                }
                case HN_25_BIS_44_PROZENT: {
                    return 1.1;
                }
                case HN_45_BIS_64_PROZENT: {
                    return 1.25;
                }
                case HN_65_BIS_84_PROZENT: {
                    return 1.5;
                }
                case HN_85_BIS_200_PROZENT: {
                    return 2.0;
                }
            }
            throw new IllegalStateException(this.name());
        }
    }

    public static enum RueckegassenVorhanden {
        JA,
        NEIN;


        public String toString() {
            switch (this) {
                case JA: {
                    return Messages.getString("ZBaumDurchforstung.RueckegassenVorhanden.ja");
                }
                case NEIN: {
                    return Messages.getString("ZBaumDurchforstung.RueckegassenVorhanden.nein");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static RueckegassenVorhanden getDefault() {
            return JA;
        }

        public double getKorrekturfaktor() {
            switch (this) {
                case JA: {
                    return 1.0;
                }
                case NEIN: {
                    return 1.3;
                }
            }
            throw new IllegalStateException(this.name());
        }
    }

    public static enum Temperatur {
        ANGENEHM,
        WARM,
        HEISS;


        public String toString() {
            switch (this) {
                case ANGENEHM: {
                    return Messages.getString("ZBaumDurchforstung.Temperatur.angenehm");
                }
                case WARM: {
                    return Messages.getString("ZBaumDurchforstung.Temperatur.warm");
                }
                case HEISS: {
                    return Messages.getString("ZBaumDurchforstung.Temperatur.heiss");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Temperatur getDefault() {
            return ANGENEHM;
        }

        public double getKorrekturfaktor() {
            switch (this) {
                case ANGENEHM: {
                    return 1.0;
                }
                case WARM: {
                    return 1.1;
                }
                case HEISS: {
                    return 1.3;
                }
            }
            throw new IllegalStateException(this.name());
        }
    }

    public static enum Verunkrautung {
        KEINE,
        MITTEL,
        STARK,
        EXTREM_STARK;


        public String toString() {
            switch (this) {
                case KEINE: {
                    return Messages.getString("ZBaumDurchforstung.Verunkrautung.keine");
                }
                case MITTEL: {
                    return Messages.getString("ZBaumDurchforstung.Verunkrautung.mittel");
                }
                case STARK: {
                    return Messages.getString("ZBaumDurchforstung.Verunkrautung.stark");
                }
                case EXTREM_STARK: {
                    return Messages.getString("ZBaumDurchforstung.Verunkrautung.extremStark");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Verunkrautung getDefault() {
            return KEINE;
        }

        public double getKorrekturfaktor(Entwicklungsstufe entwicklungsstufe) {
            switch (this) {
                case KEINE: {
                    return 1.0;
                }
                case MITTEL: {
                    return 1.1;
                }
                case STARK: {
                    return 1.2;
                }
                case EXTREM_STARK: {
                    if (entwicklungsstufe == Entwicklungsstufe.DICKUNG) {
                        return 1.4;
                    }
                    if (entwicklungsstufe == Entwicklungsstufe.STANGENHOLZ_1) {
                        throw new IllegalStateException("Unzul\u00e4ssige Kombination");
                    }
                    throw new IllegalStateException(entwicklungsstufe.name());
                }
            }
            throw new IllegalStateException(this.name());
        }
    }

    public static enum Zersaegen {
        MINIMAL,
        MITTEL,
        HOCH,
        EXTREM;


        public String toString() {
            switch (this) {
                case MINIMAL: {
                    return Messages.getString("ZBaumDurchforstung.Zersaegen.minimal");
                }
                case MITTEL: {
                    return Messages.getString("ZBaumDurchforstung.Zersaegen.mittel");
                }
                case HOCH: {
                    return Messages.getString("ZBaumDurchforstung.Zersaegen.hoch");
                }
                case EXTREM: {
                    return Messages.getString("ZBaumDurchforstung.Zersaegen.extrem");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Zersaegen getDefault() {
            return MINIMAL;
        }

        public double getKorrekturfaktor() {
            switch (this) {
                case MINIMAL: {
                    return 1.0;
                }
                case MITTEL: {
                    return 1.2;
                }
                case HOCH: {
                    return 1.5;
                }
                case EXTREM: {
                    return 2.0;
                }
            }
            throw new IllegalStateException(this.name());
        }
    }
}

