/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.model;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.model.AbstractModel;
import ch.wsl.fps.juwapfl.model.WertastungErgebnis;

public class WertastungModel
extends AbstractModel {
    private static final double KF_ETAPPE_1 = 0.9;
    private static final double KF_ETAPPE_2 = 1.1;
    private Baumart baumart;
    private int anzahlAstungsbaeumeProHektar;
    private double flaeche_ha;
    private Hangneigung hangneigung;
    private Etappe etappe;
    private Methode methode;
    private int hoehe1;
    private int hoehe2;
    private Astigkeit astigkeit;
    private int kostenPersonalProPerson;
    private double faktorWegzeitenUndPausen;
    private double korrekturfaktorMaterialkosten;

    public void setBaumart(Baumart baumart) {
        this.baumart = baumart;
    }

    public void setAnzahlAstungsbaeumeProHektar(int anzahlAstungsbaeumeProHektar) {
        this.anzahlAstungsbaeumeProHektar = anzahlAstungsbaeumeProHektar;
    }

    public void setFlaeche_ha(double flaeche_ha) {
        this.flaeche_ha = flaeche_ha;
    }

    public void setHangneigung(Hangneigung hangneigung) {
        this.hangneigung = hangneigung;
    }

    public void setEtappe(Etappe etappe) {
        this.etappe = etappe;
    }

    public void setMethode(Methode methode) {
        this.methode = methode;
    }

    public void setHoehe1(int hoehe1) {
        this.hoehe1 = hoehe1;
    }

    public void setHoehe2(int hoehe2) {
        this.hoehe2 = hoehe2;
    }

    public void setAstigkeit(Astigkeit astigkeit) {
        this.astigkeit = astigkeit;
    }

    public void setKostenPersonalProPerson(int kostenPersonalProPerson) {
        this.kostenPersonalProPerson = kostenPersonalProPerson;
    }

    public void setFaktorWegzeitenUndPausen(double faktorWegzeitenUndPausen) {
        this.faktorWegzeitenUndPausen = faktorWegzeitenUndPausen;
    }

    public void setKorrekturfaktorMaterialkosten(double korrekturfaktorMaterialkosten) {
        this.korrekturfaktorMaterialkosten = korrekturfaktorMaterialkosten;
    }

    @Override
    public WertastungErgebnis getErgebnis() {
        WertastungErgebnis ergebnis = new WertastungErgebnis();
        double astungsstrecke = this.hoehe2 - this.hoehe1;
        double astungszeit_minProBaum = 0.0;
        if (this.etappe == Etappe.Etappe1) {
            double astungszeitEtappe1_minProBaum = 2.0 * astungsstrecke * (this.baumart.getKorrekturFaktor() * this.astigkeit.getKorrekturFaktor() * 0.9);
            astungszeit_minProBaum += astungszeitEtappe1_minProBaum;
        }
        if (this.etappe == Etappe.Etappe2) {
            double astungszeitEtappe2_minProBaum = 2.0 * astungsstrecke * (this.baumart.getKorrekturFaktor() * this.astigkeit.getKorrekturFaktor() * 1.1 + ((MethodeEtappe2)this.methode).getKorrekturWertAstung());
            astungszeit_minProBaum += astungszeitEtappe2_minProBaum;
        }
        double gehzeit_sekundenProBaum = (2.8016 * Math.sqrt(10500.0 / (double)this.anzahlAstungsbaeumeProHektar) + 29.743) * this.hangneigung.getKorrekturFaktor();
        if (this.etappe == Etappe.Etappe2) {
            gehzeit_sekundenProBaum *= ((MethodeEtappe2)this.methode).getKorrekturFaktorGehzeit();
        }
        double zeitaufwand_minProBaum = (astungszeit_minProBaum + gehzeit_sekundenProBaum / 60.0) * 1.1 * this.faktorWegzeitenUndPausen;
        double materialkostenProBaum = 0.0;
        if (this.etappe == Etappe.Etappe1) {
            materialkostenProBaum += this.methode.getMaterialkostenProBaum();
        }
        if (this.etappe == Etappe.Etappe2) {
            materialkostenProBaum += this.methode.getMaterialkostenProBaum();
        }
        materialkostenProBaum *= this.korrekturfaktorMaterialkosten;
        ergebnis.setAnzahlAstungsbaeumeProHektar(this.anzahlAstungsbaeumeProHektar);
        ergebnis.setFlaecheBestand_ha(this.flaeche_ha);
        ergebnis.setAstungszeit_minProBaum(astungszeit_minProBaum * 1.1 * this.faktorWegzeitenUndPausen);
        ergebnis.setGehzeit_minProBaum(gehzeit_sekundenProBaum / 60.0 * 1.1 * this.faktorWegzeitenUndPausen);
        ergebnis.setZeitaufwandGesamt_minProBaum(zeitaufwand_minProBaum);
        ergebnis.setKostenAstungszeit_proBaum(ergebnis.getAstungszeit_minProBaum() / 60.0 * (double)this.kostenPersonalProPerson);
        ergebnis.setKostenGehzeit_proBaum(ergebnis.getGehzeit_minProBaum() / 60.0 * (double)this.kostenPersonalProPerson);
        ergebnis.setKostenMaterial_proBaum(materialkostenProBaum);
        ergebnis.setKostenGesamt_proBaum(ergebnis.getZeitaufwandGesamt_minProBaum() / 60.0 * (double)this.kostenPersonalProPerson + ergebnis.getKostenMaterial_proBaum());
        return ergebnis;
    }

    public static enum Astigkeit {
        FEIN,
        MITTEL,
        GROB;


        public String toString() {
            switch (this) {
                case FEIN: {
                    return Messages.getString("Wertastung.fein");
                }
                case MITTEL: {
                    return Messages.getString("Wertastung.mittel");
                }
                case GROB: {
                    return Messages.getString("Wertastung.grob");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Astigkeit getDefault() {
            return MITTEL;
        }

        public double getKorrekturFaktor() {
            switch (this) {
                case FEIN: {
                    return 0.7;
                }
                case MITTEL: {
                    return 1.0;
                }
                case GROB: {
                    return 1.35;
                }
            }
            throw new IllegalStateException(this.name());
        }

        public static Astigkeit[] values() {
            Astigkeit[] astigkeitArray = ENUM$VALUES;
            int n = astigkeitArray.length;
            Astigkeit[] astigkeitArray2 = new Astigkeit[n];
            System.arraycopy(ENUM$VALUES, 0, astigkeitArray2, 0, n);
            return astigkeitArray2;
        }
    }

    public static enum Baumart {
        FICHTE,
        DOUGLASIE,
        LAECHE_FOEHRE_LAUBHOLZ;


        public String toString() {
            switch (this) {
                case FICHTE: {
                    return Messages.getString("Wertastung.Fichte");
                }
                case DOUGLASIE: {
                    return Messages.getString("Wertastung.Douglasie");
                }
                case LAECHE_FOEHRE_LAUBHOLZ: {
                    return Messages.getString("Wertastung.LaercheFoehreLaubholz");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Baumart getDefault() {
            return DOUGLASIE;
        }

        public double getKorrekturFaktor() {
            switch (this) {
                case FICHTE: {
                    return 1.0;
                }
                case DOUGLASIE: {
                    return 1.15;
                }
                case LAECHE_FOEHRE_LAUBHOLZ: {
                    return 0.85;
                }
            }
            throw new IllegalStateException(this.name());
        }
    }

    public static enum Etappe {
        Etappe1,
        Etappe2;


        public String toString() {
            switch (this) {
                case Etappe1: {
                    return Messages.getString("Wertastung.Etappe1");
                }
                case Etappe2: {
                    return Messages.getString("Wertastung.Etappe2");
                }
            }
            throw new RuntimeException(this.name());
        }
    }

    public static enum Hangneigung {
        HN_0_BIS_24_PROZENT("0 - 24%"),
        HN_25_BIS_44_PROZENT("25 - 44%"),
        HN_45_BIS_64_PROZENT("45 - 64%"),
        HN_65_BIS_84_PROZENT("65 - 84%"),
        HN_85_BIS_200_PROZENT(">84%");

        private final String text;

        private Hangneigung(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public static Hangneigung getDefault() {
            return HN_0_BIS_24_PROZENT;
        }

        public double getKorrekturFaktor() {
            switch (this) {
                case HN_0_BIS_24_PROZENT: {
                    return 1.0;
                }
                case HN_25_BIS_44_PROZENT: {
                    return 1.1;
                }
                case HN_45_BIS_64_PROZENT: {
                    return 1.25;
                }
                case HN_65_BIS_84_PROZENT: {
                    return 1.5;
                }
                case HN_85_BIS_200_PROZENT: {
                    return 2.0;
                }
            }
            throw new IllegalStateException(this.name());
        }
    }

    public static interface Methode {
        public double getMaterialkostenProBaum();
    }

    public static enum MethodeEtappe1 implements Methode
    {
        ANSTELLLEITER(1.65),
        STANGENSAEGE(0.9),
        DISTELLEITER(2.1);

        private final double materialkostenProBaum;

        private MethodeEtappe1(double materialkostenProBaum) {
            this.materialkostenProBaum = materialkostenProBaum;
        }

        @Override
        public double getMaterialkostenProBaum() {
            return this.materialkostenProBaum;
        }

        public String toString() {
            switch (this) {
                case ANSTELLLEITER: {
                    return Messages.getString("Wertastung.Anstellleiter");
                }
                case STANGENSAEGE: {
                    return Messages.getString("Wertastung.Stangensaege");
                }
                case DISTELLEITER: {
                    return Messages.getString("Wertastung.Distelleiter");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static MethodeEtappe1 getDefault() {
            return ANSTELLLEITER;
        }
    }

    public static enum MethodeEtappe2 implements Methode
    {
        DISTELLEITER(2.7),
        ASTSTUMMELMETHODE(1.8);

        private final double materialkostenProBaum;

        private MethodeEtappe2(double materialkostenProBaum) {
            this.materialkostenProBaum = materialkostenProBaum;
        }

        @Override
        public double getMaterialkostenProBaum() {
            return this.materialkostenProBaum;
        }

        public String toString() {
            switch (this) {
                case DISTELLEITER: {
                    return Messages.getString("Wertastung.Distelleiter");
                }
                case ASTSTUMMELMETHODE: {
                    return Messages.getString("Wertastung.AststummelMethode");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static MethodeEtappe2 getDefault() {
            return DISTELLEITER;
        }

        public double getKorrekturWertAstung() {
            switch (this) {
                case DISTELLEITER: {
                    return 0.1;
                }
                case ASTSTUMMELMETHODE: {
                    return 0.0;
                }
            }
            throw new IllegalStateException(this.name());
        }

        public double getKorrekturFaktorGehzeit() {
            switch (this) {
                case DISTELLEITER: {
                    return 2.0;
                }
                case ASTSTUMMELMETHODE: {
                    return 1.0;
                }
            }
            throw new IllegalStateException(this.name());
        }
    }
}

