/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.model;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.model.AbstractModel;
import ch.wsl.fps.juwapfl.model.SchneegleitenErgebnis;

public class SchneegleitenModel
extends AbstractModel {
    private Massnahme massnahme;
    private int anzahlBauten;
    private Gelaendeverhaeltnisse gelaendeverhaeltnisse;
    private double erstellenPersonalzeit_minProEinheit;
    private double erstellenMaterialkosten_ChfProEinheit;
    private double erstellenMaschinenkosten_ChfProEinheit;
    private double erstellenTransportkosten_ChfProEinheit;
    private double unterhaltPersonalzeit_minProEinheit;
    private double unterhaltFahrzeugkosten_ChfProEinheit;
    private double unterhaltMaterialkosten_ChfProEinheit;
    private double abbauPersonalzeit_minProEinheit;
    private double abbauFahrzeugkosten_ChfProEinheit;
    private double abbauEntsorgungsgebuehren_ChfProEinheit;
    private int kostenPersonalProPerson;
    private double faktorWegzeitenUndPausen;

    public void setMassnahme(Massnahme massnahme) {
        this.massnahme = massnahme;
    }

    public void setAnzahlBauten(int anzahlBauten) {
        this.anzahlBauten = anzahlBauten;
    }

    public void setGelaendeverhaeltnisse(Gelaendeverhaeltnisse gelaendeverhaeltnisse) {
        this.gelaendeverhaeltnisse = gelaendeverhaeltnisse;
    }

    public void setErstellenPersonalzeit_minProEinheit(double personalzeit_minProEinheit) {
        this.erstellenPersonalzeit_minProEinheit = personalzeit_minProEinheit;
    }

    public void setErstellenMaterialkosten_ChfProEinheit(double materialkosten_ChfProEinheit) {
        this.erstellenMaterialkosten_ChfProEinheit = materialkosten_ChfProEinheit;
    }

    public void setErstellenMaschinenkosten_ChfProEinheit(double maschinenkosten_ChfProEinheit) {
        this.erstellenMaschinenkosten_ChfProEinheit = maschinenkosten_ChfProEinheit;
    }

    public void setErstellenTransportkosten_ChfProEinheit(double transportkosten_ChfProEinheit) {
        this.erstellenTransportkosten_ChfProEinheit = transportkosten_ChfProEinheit;
    }

    public void setUnterhaltPersonalzeit_minProEinheit(double unterhaltPersonalzeit_minProEinheit) {
        this.unterhaltPersonalzeit_minProEinheit = unterhaltPersonalzeit_minProEinheit;
    }

    public void setUnterhaltFahrzeugkosten_ChfProEinheit(double unterhaltFahrzeugkosten_ChfProEinheit) {
        this.unterhaltFahrzeugkosten_ChfProEinheit = unterhaltFahrzeugkosten_ChfProEinheit;
    }

    public void setUnterhaltMaterialkosten_ChfProEinheit(double unterhaltMaterialkosten_ChfProEinheit) {
        this.unterhaltMaterialkosten_ChfProEinheit = unterhaltMaterialkosten_ChfProEinheit;
    }

    public void setAbbauPersonalzeit_minProEinheit(double abbauPersonalzeit_minProEinheit) {
        this.abbauPersonalzeit_minProEinheit = abbauPersonalzeit_minProEinheit;
    }

    public void setAbbauFahrzeugkosten_ChfProEinheit(double abbauFahrzeugkosten_ChfProEinheit) {
        this.abbauFahrzeugkosten_ChfProEinheit = abbauFahrzeugkosten_ChfProEinheit;
    }

    public void setAbbauEntsorgungsgebuehren_ChfProEinheit(double abbauEntsorgungsgebuehren_ChfProEinheit) {
        this.abbauEntsorgungsgebuehren_ChfProEinheit = abbauEntsorgungsgebuehren_ChfProEinheit;
    }

    public void setKostenPersonalProPerson(int kostenPersonalProPerson) {
        this.kostenPersonalProPerson = kostenPersonalProPerson;
    }

    public void setFaktorWegzeitenUndPausen(double faktorWegzeitenUndPausen) {
        this.faktorWegzeitenUndPausen = faktorWegzeitenUndPausen;
    }

    @Override
    public SchneegleitenErgebnis getErgebnis() {
        double zeitaufwandAufbau_min = this.erstellenPersonalzeit_minProEinheit * (double)this.anzahlBauten * 1.1 * this.faktorWegzeitenUndPausen;
        double zeitaufwandUnterhalt_min = this.unterhaltPersonalzeit_minProEinheit * (double)this.anzahlBauten * 1.1 * this.faktorWegzeitenUndPausen;
        double zeitaufwandAbbau_min = this.abbauPersonalzeit_minProEinheit * (double)this.anzahlBauten * 1.1 * this.faktorWegzeitenUndPausen;
        SchneegleitenErgebnis ergebnis = new SchneegleitenErgebnis();
        ergebnis.setZeitPersonalAufbau_min(zeitaufwandAufbau_min *= this.gelaendeverhaeltnisse.getFaktor(this.massnahme));
        ergebnis.setZeitPersonalUnterhalt_min(zeitaufwandUnterhalt_min *= this.gelaendeverhaeltnisse.getFaktor(this.massnahme));
        ergebnis.setZeitPersonalAbbau_min(zeitaufwandAbbau_min *= this.gelaendeverhaeltnisse.getFaktor(this.massnahme));
        ergebnis.setKostenPersonalAufbau(zeitaufwandAufbau_min * (double)this.kostenPersonalProPerson / 60.0);
        ergebnis.setKostenPersonalUnterhalt(zeitaufwandUnterhalt_min * (double)this.kostenPersonalProPerson / 60.0);
        ergebnis.setKostenPersonalAbbau(zeitaufwandAbbau_min * (double)this.kostenPersonalProPerson / 60.0);
        ergebnis.setKostenFahrtenAufbau(this.erstellenTransportkosten_ChfProEinheit * (double)this.anzahlBauten);
        ergebnis.setKostenFahrtenUnterhalt(this.unterhaltFahrzeugkosten_ChfProEinheit * (double)this.anzahlBauten);
        ergebnis.setKostenFahrtenAbbau(this.abbauFahrzeugkosten_ChfProEinheit * (double)this.anzahlBauten);
        ergebnis.setKostenMaterialAufbau((this.erstellenMaterialkosten_ChfProEinheit + this.erstellenMaschinenkosten_ChfProEinheit) * (double)this.anzahlBauten);
        ergebnis.setKostenMaterialUnterhalt(this.unterhaltMaterialkosten_ChfProEinheit * (double)this.anzahlBauten);
        ergebnis.setKostenMaterialAbbau(this.abbauEntsorgungsgebuehren_ChfProEinheit * (double)this.anzahlBauten);
        return ergebnis;
    }

    public static double getDefaultErstellenPersonalzeit_minProEinheit(Massnahme massnahme) {
        switch (massnahme) {
            case PFAEHLE: {
                return 15.600000000000001;
            }
            case BERMEN: {
                return 2.4;
            }
            case SCHWELLEN: {
                return 138.0;
            }
            case DREIBEINBOECKE: {
                return 132.0;
            }
        }
        throw new IllegalStateException("Unbekannte Massnahme: " + (Object)((Object)massnahme));
    }

    public static double getDefaultErstellenMaterialkosten_ChfProEinheit(Massnahme massnahme) {
        switch (massnahme) {
            case PFAEHLE: {
                return 5.0;
            }
            case BERMEN: {
                return 0.0;
            }
            case SCHWELLEN: {
                return 35.0;
            }
            case DREIBEINBOECKE: {
                return 75.8;
            }
        }
        throw new IllegalStateException("Unbekannte Massnahme: " + (Object)((Object)massnahme));
    }

    public static double getDefaultErstellenMaschinenkosten_ChfProEinheit(Massnahme massnahme) {
        switch (massnahme) {
            case PFAEHLE: {
                return 0.5;
            }
            case BERMEN: {
                return 0.0;
            }
            case SCHWELLEN: {
                return 5.0;
            }
            case DREIBEINBOECKE: {
                return 7.0;
            }
        }
        throw new IllegalStateException("Unbekannte Massnahme: " + (Object)((Object)massnahme));
    }

    public static double getDefaultUnterhaltPersonalzeit_minProEinheit(Massnahme massnahme) {
        switch (massnahme) {
            case PFAEHLE: {
                return 1.2;
            }
            case BERMEN: {
                return 0.6;
            }
            case SCHWELLEN: {
                return 1.2;
            }
            case DREIBEINBOECKE: {
                return 2.4;
            }
        }
        throw new IllegalStateException("Unbekannte Massnahme: " + (Object)((Object)massnahme));
    }

    public static enum Gelaendeverhaeltnisse {
        NORMAL(1.0, 1.0),
        SCHWIERIG(1.2, 1.2),
        SEHR_SCHWIERIG(1.5, 1.4);

        private final double faktorStandard;
        private final double faktorDreibeinboecke;

        private Gelaendeverhaeltnisse(double faktorStandard, double faktorDreibeinboecke) {
            this.faktorStandard = faktorStandard;
            this.faktorDreibeinboecke = faktorDreibeinboecke;
        }

        public String toString() {
            switch (this) {
                case NORMAL: {
                    return Messages.getString("Schneegleiten.normal");
                }
                case SCHWIERIG: {
                    return Messages.getString("Schneegleiten.schwierig");
                }
                case SEHR_SCHWIERIG: {
                    return Messages.getString("Schneegleiten.sehrSchwierig");
                }
            }
            throw new RuntimeException(this.name());
        }

        public double getFaktor(Massnahme massnahme) {
            switch (massnahme) {
                case PFAEHLE: 
                case BERMEN: 
                case SCHWELLEN: {
                    return this.faktorStandard;
                }
                case DREIBEINBOECKE: {
                    return this.faktorDreibeinboecke;
                }
            }
            throw new IllegalStateException("Unbekannte Massnahme: " + (Object)((Object)massnahme));
        }

        public static Gelaendeverhaeltnisse getDefault() {
            return NORMAL;
        }
    }

    public static enum Massnahme {
        PFAEHLE,
        BERMEN,
        SCHWELLEN,
        DREIBEINBOECKE;


        public String toString() {
            switch (this) {
                case PFAEHLE: {
                    return Messages.getString("Schneegleiten.Pfaehle");
                }
                case BERMEN: {
                    return Messages.getString("Schneegleiten.BremenHandarbeit");
                }
                case SCHWELLEN: {
                    return Messages.getString("Schneegleiten.Schwellen");
                }
                case DREIBEINBOECKE: {
                    return Messages.getString("Schneegleiten.Dreibeinboecke");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Massnahme getDefault() {
            return DREIBEINBOECKE;
        }
    }
}

