/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.model;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.model.PflanzungModel;

public class PflanzungWinkelpflanzungModel {
    private Bodenvegetation bodenvegetation;
    private Schlagabraum schlagabraum;
    private Hangneigung hangneigung;
    private Pflanzenhoehe pflanzenhoehe;
    private Transportdistanz transportdistanz;

    public Bodenvegetation getBodenvegetation() {
        return this.bodenvegetation;
    }

    public void setBodenvegetation(Bodenvegetation bodenvegetation) {
        this.bodenvegetation = bodenvegetation;
    }

    public Schlagabraum getSchlagabraum() {
        return this.schlagabraum;
    }

    public void setSchlagabraum(Schlagabraum schlagabraum) {
        this.schlagabraum = schlagabraum;
    }

    public Hangneigung getHangneigung() {
        return this.hangneigung;
    }

    public void setHangneigung(Hangneigung hangneigung) {
        this.hangneigung = hangneigung;
    }

    public Pflanzenhoehe getPflanzenhoehe() {
        return this.pflanzenhoehe;
    }

    public void setPflanzenhoehe(Pflanzenhoehe pflanzenhoehe) {
        this.pflanzenhoehe = pflanzenhoehe;
    }

    public Transportdistanz getTransportdistanz() {
        return this.transportdistanz;
    }

    public void setTransportdistanz(Transportdistanz transportdistanz) {
        this.transportdistanz = transportdistanz;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bodenvegetation == null ? 0 : this.bodenvegetation.hashCode());
        result = 31 * result + (this.hangneigung == null ? 0 : this.hangneigung.hashCode());
        result = 31 * result + (this.pflanzenhoehe == null ? 0 : this.pflanzenhoehe.hashCode());
        result = 31 * result + (this.schlagabraum == null ? 0 : this.schlagabraum.hashCode());
        result = 31 * result + (this.transportdistanz == null ? 0 : this.transportdistanz.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PflanzungWinkelpflanzungModel other = (PflanzungWinkelpflanzungModel)obj;
        if (this.bodenvegetation != other.bodenvegetation) {
            return false;
        }
        if (this.hangneigung != other.hangneigung) {
            return false;
        }
        if (this.pflanzenhoehe != other.pflanzenhoehe) {
            return false;
        }
        if (this.schlagabraum != other.schlagabraum) {
            return false;
        }
        return this.transportdistanz == other.transportdistanz;
    }

    public static enum Bodenvegetation implements NadelLaubZuschlag
    {
        KEINE(0.0, 0.0),
        WENIG(0.25, 0.14),
        MITTEL(0.33, 0.19),
        VIEL(0.42, 0.25);

        private final double defaultZuschlagNadel;
        private final double defaultZuschlagLaub;

        private Bodenvegetation(double defaultZuschlagNadel, double defaultZuschlagLaub) {
            this.defaultZuschlagNadel = defaultZuschlagNadel;
            this.defaultZuschlagLaub = defaultZuschlagLaub;
        }

        public String toString() {
            switch (this) {
                case KEINE: {
                    return Messages.getString("Pflanzung.Winkelpflanzung.Bodenvegetation.keine");
                }
                case WENIG: {
                    return Messages.getString("Pflanzung.Winkelpflanzung.Bodenvegetation.wenig");
                }
                case MITTEL: {
                    return Messages.getString("Pflanzung.Winkelpflanzung.Bodenvegetation.mittel");
                }
                case VIEL: {
                    return Messages.getString("Pflanzung.Winkelpflanzung.Bodenvegetation.viel");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Bodenvegetation getDefault() {
            return KEINE;
        }

        @Override
        public double getDefaultZuschlag_hPro100Pflanzen(PflanzungModel.Baumart baumart) {
            if (baumart == PflanzungModel.Baumart.NADELHOLZ) {
                return this.defaultZuschlagNadel;
            }
            if (baumart == PflanzungModel.Baumart.LAUBHOLZ) {
                return this.defaultZuschlagLaub;
            }
            throw new RuntimeException("Baumart: " + (Object)((Object)baumart));
        }
    }

    public static enum Hangneigung implements NadelLaubZuschlag
    {
        WENIGER_ALS_10_PROZENT(0.0, 0.0),
        BIS_45_PROZENT(0.12, 0.05),
        UEBER_45_PROZENT(0.25, 0.1);

        private final double defaultZuschlagNadel;
        private final double defaultZuschlagLaub;

        private Hangneigung(double defaultZuschlagNadel, double defaultZuschlagLaub) {
            this.defaultZuschlagNadel = defaultZuschlagNadel;
            this.defaultZuschlagLaub = defaultZuschlagLaub;
        }

        public String toString() {
            switch (this) {
                case WENIGER_ALS_10_PROZENT: {
                    return "< 10%";
                }
                case BIS_45_PROZENT: {
                    return "10 - 45%";
                }
                case UEBER_45_PROZENT: {
                    return "> 45%";
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Hangneigung getDefault() {
            return WENIGER_ALS_10_PROZENT;
        }

        @Override
        public double getDefaultZuschlag_hPro100Pflanzen(PflanzungModel.Baumart baumart) {
            if (baumart == PflanzungModel.Baumart.NADELHOLZ) {
                return this.defaultZuschlagNadel;
            }
            if (baumart == PflanzungModel.Baumart.LAUBHOLZ) {
                return this.defaultZuschlagLaub;
            }
            throw new RuntimeException("Baumart: " + (Object)((Object)baumart));
        }
    }

    public static interface NadelLaubZuschlag {
        public double getDefaultZuschlag_hPro100Pflanzen(PflanzungModel.Baumart var1);
    }

    public static enum Pflanzenhoehe implements NadelLaubZuschlag
    {
        WENIGER_ALS_40_CM(0.0, 0.0),
        VON_40_BIS_60_CM(0.07, 0.07),
        VON_60_BIS_100CM(0.23, 0.17),
        UEBER_100_CM(0.3, 0.58);

        private final double defaultZuschlagNadel;
        private final double defaultZuschlagLaub;

        private Pflanzenhoehe(double defaultZuschlagNadel, double defaultZuschlagLaub) {
            this.defaultZuschlagNadel = defaultZuschlagNadel;
            this.defaultZuschlagLaub = defaultZuschlagLaub;
        }

        public String toString() {
            switch (this) {
                case WENIGER_ALS_40_CM: {
                    return "< 40 cm";
                }
                case VON_40_BIS_60_CM: {
                    return "40 - 60 cm";
                }
                case VON_60_BIS_100CM: {
                    return "> 60 - 100 cm";
                }
                case UEBER_100_CM: {
                    return "> 100 cm";
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Pflanzenhoehe getDefault() {
            return WENIGER_ALS_40_CM;
        }

        @Override
        public double getDefaultZuschlag_hPro100Pflanzen(PflanzungModel.Baumart baumart) {
            if (baumart == PflanzungModel.Baumart.NADELHOLZ) {
                return this.defaultZuschlagNadel;
            }
            if (baumart == PflanzungModel.Baumart.LAUBHOLZ) {
                return this.defaultZuschlagLaub;
            }
            throw new RuntimeException("Baumart: " + (Object)((Object)baumart));
        }
    }

    public static enum Schlagabraum implements NadelLaubZuschlag
    {
        KEINE(0.0, 0.0),
        WENIG(0.17, 0.17),
        VIEL(0.33, 0.33),
        SEHR_VIEL(0.5, 0.5);

        private final double defaultZuschlagNadel;
        private final double defaultZuschlagLaub;

        private Schlagabraum(double defaultZuschlagNadel, double defaultZuschlagLaub) {
            this.defaultZuschlagNadel = defaultZuschlagNadel;
            this.defaultZuschlagLaub = defaultZuschlagLaub;
        }

        public String toString() {
            switch (this) {
                case KEINE: {
                    return Messages.getString("Pflanzung.Winkelpflanzung.Schlagabraum.keine");
                }
                case WENIG: {
                    return Messages.getString("Pflanzung.Winkelpflanzung.Schlagabraum.wenig");
                }
                case VIEL: {
                    return Messages.getString("Pflanzung.Winkelpflanzung.Schlagabraum.viel");
                }
                case SEHR_VIEL: {
                    return Messages.getString("Pflanzung.Winkelpflanzung.Schlagabraum.sehrViel");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Schlagabraum getDefault() {
            return KEINE;
        }

        @Override
        public double getDefaultZuschlag_hPro100Pflanzen(PflanzungModel.Baumart baumart) {
            if (baumart == PflanzungModel.Baumart.NADELHOLZ) {
                return this.defaultZuschlagNadel;
            }
            if (baumart == PflanzungModel.Baumart.LAUBHOLZ) {
                return this.defaultZuschlagLaub;
            }
            throw new RuntimeException("Baumart: " + (Object)((Object)baumart));
        }
    }

    public static enum Transportdistanz implements NadelLaubZuschlag
    {
        WENIGER_ALS_100_METER(0.0, 0.0),
        NORMALPFLANZEN(0.2, 0.08),
        GROSSPFLANZEN(0.3, 0.25);

        private final double defaultZuschlagNadel;
        private final double defaultZuschlagLaub;

        private Transportdistanz(double defaultZuschlagNadel, double defaultZuschlagLaub) {
            this.defaultZuschlagNadel = defaultZuschlagNadel;
            this.defaultZuschlagLaub = defaultZuschlagLaub;
        }

        public String toString() {
            switch (this) {
                case WENIGER_ALS_100_METER: {
                    return "< 100 m";
                }
                case NORMALPFLANZEN: {
                    return Messages.getString("Pflanzung.Winkelpflanzung.Transportdistanz.Normalpflanzen");
                }
                case GROSSPFLANZEN: {
                    return Messages.getString("Pflanzung.Winkelpflanzung.Transportdistanz.Grosspflanzen");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Transportdistanz getDefault() {
            return WENIGER_ALS_100_METER;
        }

        @Override
        public double getDefaultZuschlag_hPro100Pflanzen(PflanzungModel.Baumart baumart) {
            if (baumart == PflanzungModel.Baumart.NADELHOLZ) {
                return this.defaultZuschlagNadel;
            }
            if (baumart == PflanzungModel.Baumart.LAUBHOLZ) {
                return this.defaultZuschlagLaub;
            }
            throw new RuntimeException("Baumart: " + (Object)((Object)baumart));
        }
    }
}

