/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.model;

import ch.wsl.fps.juwapfl.model.AbstractJuwapflModelTest;
import ch.wsl.fps.juwapfl.model.BegehungswegeErgebnis;
import ch.wsl.fps.juwapfl.model.BegehungswegeMockErgebnis;
import ch.wsl.fps.juwapfl.model.BegehungswegeModel;
import org.testng.annotations.Test;

public class BegehungswegeModelTest
extends AbstractJuwapflModelTest {
    @Override
    protected String getCsvPath() {
        return "testcases/Begehungswege.csv";
    }

    @Override
    protected BegehungswegeModel parseInputData(String[] testcase) {
        BegehungswegeModel result = new BegehungswegeModel();
        result.setBegehungsweg(BegehungswegeModel.Begehungsweg.valueOf(testcase[0]));
        result.setAusfuehrung(BegehungswegeModel.Ausfuehrung.valueOf(testcase[1]));
        result.setAnzahlLaufmeter(Integer.valueOf(testcase[2]));
        result.setGelaendeSchwierigkeit(BegehungswegeModel.GelaendeSchwierigkeit.valueOf(testcase[3]));
        result.setZeitaufwand_minProM(Double.valueOf(testcase[4]));
        result.setKostenPersonal(Integer.valueOf(testcase[5]));
        result.setKostenMaschine(Integer.valueOf(testcase[6]));
        result.setFaktorWegzeitenUndPausen(Double.valueOf(testcase[7]));
        return result;
    }

    @Override
    protected BegehungswegeMockErgebnis parseExpectedValues(String[] testcase) {
        double[] values = this.getDoubleValues(testcase, 8);
        BegehungswegeMockErgebnis result = new BegehungswegeMockErgebnis();
        int i = 0;
        result.setZeitPersonal_min(values[i++]);
        result.setZeitMaschine_min(values[i++]);
        result.setKostenPersonal(values[i++]);
        result.setKostenMaschine(values[i++]);
        result.setKostenGesamt(values[i++]);
        return result;
    }

    @Test(dataProvider="csvData")
    public void testZeitPersonal_min(String testcaseName, BegehungswegeErgebnis actualOutput, BegehungswegeMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDeltaMinutes(actualOutput.getZeitPersonal_min(), expectedOutput.getZeitPersonal_min());
    }

    @Test(dataProvider="csvData")
    public void testZeitMaschine_min(String testcaseName, BegehungswegeErgebnis actualOutput, BegehungswegeMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDeltaMinutes(actualOutput.getZeitMaschine_min(), expectedOutput.getZeitMaschine_min());
    }

    @Test(dataProvider="csvData")
    public void testKostenPersonal(String testcaseName, BegehungswegeErgebnis actualOutput, BegehungswegeMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenPersonal(), expectedOutput.getKostenPersonal());
    }

    @Test(dataProvider="csvData")
    public void testKostenMaschine(String testcaseName, BegehungswegeErgebnis actualOutput, BegehungswegeMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenMaschine(), expectedOutput.getKostenMaschine());
    }

    @Test(dataProvider="csvData")
    public void testKostenGesamt(String testcaseName, BegehungswegeErgebnis actualOutput, BegehungswegeMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenGesamt(), expectedOutput.getKostenGesamt());
    }
}

