/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.model;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.model.AbstractModel;
import ch.wsl.fps.juwapfl.model.BegehungswegeErgebnis;

public class BegehungswegeModel
extends AbstractModel {
    private static final double zeitaufwandErstellenManuellEinfach_minProM = 13.0;
    private static final double zeitaufwandErstellenManuellSchwierig_minProM = 19.5;
    private static final double zeitaufwandErstellenMaschinellEinfach_minProM = 2.5;
    private static final double zeitaufwandErstellenMaschinellSchwierig_minProM = 4.0;
    private static final double zeitaufwandInstandStellenManuellEinfach_minProM = 6.5;
    private static final double zeitaufwandInstandStellenManuellSchwierig_minProM = 9.5;
    private static final double zeitaufwandInstandStellenMaschinellEinfach_minProM = 1.0;
    private static final double zeitaufwandInstandStellenMaschinellSchwierig_minProM = 2.0;
    private Begehungsweg begehungsweg;
    private Ausfuehrung ausfuehrung;
    private GelaendeSchwierigkeit gelaendeSchwierigkeit;
    private int anzahlLaufmeter;
    private double zeitaufwand_minProM;
    private int kostenPersonal;
    private int kostenMaschine;
    private double faktorWegzeitenUndPausen;

    public void setBegehungsweg(Begehungsweg begehungsweg) {
        this.begehungsweg = begehungsweg;
    }

    public void setAusfuehrung(Ausfuehrung ausfuehrung) {
        this.ausfuehrung = ausfuehrung;
    }

    public void setGelaendeSchwierigkeit(GelaendeSchwierigkeit gelaendeSchwierigkeit) {
        this.gelaendeSchwierigkeit = gelaendeSchwierigkeit;
    }

    public void setAnzahlLaufmeter(int anzahlLaufmeter) {
        this.anzahlLaufmeter = anzahlLaufmeter;
    }

    public void setZeitaufwand_minProM(Double zeitaufwand_minProM) {
        this.zeitaufwand_minProM = zeitaufwand_minProM;
    }

    public void setKostenPersonal(int kostenPersonal) {
        this.kostenPersonal = kostenPersonal;
    }

    public void setKostenMaschine(int kostenMaschine) {
        this.kostenMaschine = kostenMaschine;
    }

    public void setFaktorWegzeitenUndPausen(double faktorWegzeitenUndPausen) {
        this.faktorWegzeitenUndPausen = faktorWegzeitenUndPausen;
    }

    @Override
    public BegehungswegeErgebnis getErgebnis() {
        BegehungswegeErgebnis ergebnis = new BegehungswegeErgebnis();
        double zeitPersonal_min = this.zeitaufwand_minProM * (double)this.anzahlLaufmeter * 1.1 * this.faktorWegzeitenUndPausen;
        boolean isMaschinell = this.ausfuehrung == Ausfuehrung.MASCHINELL;
        double zeitMaschineErstellen_min = isMaschinell ? this.zeitaufwand_minProM * (double)this.anzahlLaufmeter : 0.0;
        ergebnis.setZeitPersonal_min(zeitPersonal_min);
        ergebnis.setZeitMaschine_min(zeitMaschineErstellen_min);
        ergebnis.setKostenPersonal(zeitPersonal_min * (double)this.kostenPersonal / 60.0);
        ergebnis.setKostenMaschine(zeitMaschineErstellen_min * (double)this.kostenMaschine / 60.0);
        return ergebnis;
    }

    public static double getDefaultZeitaufwand_minProM(Begehungsweg begehungsweg, Ausfuehrung ausfuehrung, GelaendeSchwierigkeit schwierigkeit) {
        if (begehungsweg == Begehungsweg.NEU_ERSTELLEN) {
            return BegehungswegeModel.getDefaultZeitaufwandErstellen_minProM(ausfuehrung, schwierigkeit);
        }
        if (begehungsweg == Begehungsweg.INSTAND_STELLEN) {
            return BegehungswegeModel.getDefaultZeitaufwandInstandStellen_minProM(ausfuehrung, schwierigkeit);
        }
        throw new RuntimeException("begehungsweg is null");
    }

    private static double getDefaultZeitaufwandErstellen_minProM(Ausfuehrung ausfuehrung, GelaendeSchwierigkeit schwierigkeit) {
        if (ausfuehrung == Ausfuehrung.MANUELL) {
            if (schwierigkeit == GelaendeSchwierigkeit.EINFACH) {
                return 13.0;
            }
            return 19.5;
        }
        if (schwierigkeit == GelaendeSchwierigkeit.EINFACH) {
            return 2.5;
        }
        return 4.0;
    }

    private static double getDefaultZeitaufwandInstandStellen_minProM(Ausfuehrung ausfuehrung, GelaendeSchwierigkeit schwierigkeit) {
        if (ausfuehrung == Ausfuehrung.MANUELL) {
            if (schwierigkeit == GelaendeSchwierigkeit.EINFACH) {
                return 6.5;
            }
            return 9.5;
        }
        if (schwierigkeit == GelaendeSchwierigkeit.EINFACH) {
            return 1.0;
        }
        return 2.0;
    }

    public static enum Ausfuehrung {
        MANUELL,
        MASCHINELL;


        public String toString() {
            switch (this) {
                case MANUELL: {
                    return Messages.getString("Begehungswege.vonHand");
                }
                case MASCHINELL: {
                    return Messages.getString("Begehungswege.maschinell");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Ausfuehrung getDefault() {
            return MANUELL;
        }
    }

    public static enum Begehungsweg {
        NEU_ERSTELLEN,
        INSTAND_STELLEN;


        public String toString() {
            switch (this) {
                case NEU_ERSTELLEN: {
                    return Messages.getString("Begehungswege.neuErstellen");
                }
                case INSTAND_STELLEN: {
                    return Messages.getString("Begehungswege.instandStellen");
                }
            }
            throw new RuntimeException(this.name());
        }
    }

    public static enum GelaendeSchwierigkeit {
        EINFACH,
        SCHWIERIG;


        public String toString() {
            switch (this) {
                case EINFACH: {
                    return Messages.getString("Begehungswege.einfach");
                }
                case SCHWIERIG: {
                    return Messages.getString("Begehungswege.schwierig");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static GelaendeSchwierigkeit getDefault() {
            return EINFACH;
        }
    }
}

