/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.CurrencySensitive;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.main.ZBaumDurchforstungMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.ZBaumDurchforstungBestandPanel;
import ch.wsl.fps.juwapfl.model.ZBaumDurchforstungModel;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class ZBaumDurchforstungPersonalMaschinenPanel
extends AbstractInputPanel
implements CurrencySensitive {
    private final ZBaumDurchforstungMainWindow mainWindow;
    private final ZBaumDurchforstungBestandPanel panelBestand;
    private final JLabel lblKostenPersonalProPerson = new JLabel();
    private final JSpinner txtKostenPersonalProPerson = new JSpinner(new SpinnerNumberModel(70, 0, 500, 1));
    private final JLabel lblKostenMotorsaege = new JLabel();
    private final JSpinner txtKostenMotorsaege = new JSpinner(new SpinnerNumberModel(14.0, 0.0, 500.0, 1.0));
    private final JLabel lblKostenKronenschnittUnten = new JLabel();
    private final JSpinner txtKostenKronenschnittUnten = new JSpinner(new SpinnerNumberModel(0.1, 0.0, 10.0, 0.05));
    private final JLabel lblKostenKronenschnittOben = new JLabel();
    private final JSpinner txtKostenKronenschnittOben = new JSpinner(new SpinnerNumberModel(0.25, 0.0, 10.0, 0.05));
    private final JSpinner txtArbeitszeit = new JSpinner(new SpinnerNumberModel(510, 60, 1000, 10));
    private final JSpinner txtPausen = new JSpinner(new SpinnerNumberModel(60, 0, 1000, 10));

    public ZBaumDurchforstungPersonalMaschinenPanel(ZBaumDurchforstungMainWindow mainWindow, ZBaumDurchforstungBestandPanel panelBestand) {
        super(Messages.getString("ZBaumDurchforstung.PersonalUndMaschinen"));
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtKostenPersonalProPerson, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtKostenMotorsaege, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtKostenKronenschnittUnten, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtKostenKronenschnittOben, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtArbeitszeit, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtPausen, false);
        this.txtKostenKronenschnittUnten.setEditor(new JSpinner.NumberEditor(this.txtKostenKronenschnittUnten, "0.00"));
        this.txtKostenKronenschnittOben.setEditor(new JSpinner.NumberEditor(this.txtKostenKronenschnittOben, "0.00"));
        this.mainWindow = mainWindow;
        this.panelBestand = panelBestand;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(this.lblKostenPersonalProPerson);
        this.add(Utilities.getPanelWithoutInfoButton(this.txtKostenPersonalProPerson));
        this.add(this.lblKostenMotorsaege);
        this.add(Utilities.getPanelWithoutInfoButton(this.txtKostenMotorsaege));
        this.add(this.lblKostenKronenschnittUnten);
        String infoButtonText1 = Messages.getString("ZBaumDurchforstung.InfoButtonKostenKronenschnitt");
        this.add(Utilities.getPanelWithInfoButton(this.txtKostenKronenschnittUnten, infoButtonText1));
        this.add(this.lblKostenKronenschnittOben);
        String infoButtonText2 = Messages.getString("ZBaumDurchforstung.InfoButtonKostenKronenschnitt");
        this.add(Utilities.getPanelWithInfoButton(this.txtKostenKronenschnittOben, infoButtonText2));
        this.add(new JLabel(Messages.getString("Common.TaeglicheArbeitszeit")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtArbeitszeit));
        this.add(new JLabel("   " + Messages.getString("Common.DavonBezahlteWegzeitenUndPausen")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtPausen));
        this.updatePausenMaximum();
        this.initListeners();
        mainWindow.registerForCurrencyUpdates(this);
    }

    private void initListeners() {
        this.txtKostenPersonalProPerson.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtKostenMotorsaege.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtKostenKronenschnittUnten.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtKostenKronenschnittOben.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtArbeitszeit.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtArbeitszeit.addChangeListener(e -> this.updatePausenMaximum());
        this.txtPausen.addChangeListener(this.mainWindow.getDefaultChangeListener());
    }

    public void onInputChangedBeforeCalculation() {
        ZBaumDurchforstungModel.Entwicklungsstufe entwicklungsstufe = this.panelBestand.getEntwicklungsstufe();
        boolean isEntwicklungsstufeDickung = entwicklungsstufe == ZBaumDurchforstungModel.Entwicklungsstufe.DICKUNG;
        this.txtKostenKronenschnittUnten.setEnabled(isEntwicklungsstufeDickung);
        this.txtKostenKronenschnittOben.setEnabled(isEntwicklungsstufeDickung);
    }

    private void updatePausenMaximum() {
        int arbeitszeit = (Integer)this.txtArbeitszeit.getValue();
        int maximum = arbeitszeit - 10;
        ((SpinnerNumberModel)this.txtPausen.getModel()).setMaximum(Integer.valueOf(maximum));
        if ((Integer)this.txtPausen.getValue() > maximum) {
            this.txtPausen.setValue(maximum);
        }
    }

    public Integer getKostenPersonalProPerson() {
        return (Integer)this.txtKostenPersonalProPerson.getValue();
    }

    public Double getKostenMotorsaege() {
        return (Double)this.txtKostenMotorsaege.getValue();
    }

    public Double getKostenKronenschnittUnten() {
        return (Double)this.txtKostenKronenschnittUnten.getValue();
    }

    public Double getKostenKronenschnittOben() {
        return (Double)this.txtKostenKronenschnittOben.getValue();
    }

    public double getFaktorWegzeitenUndPausen() {
        int arbeitszeit = (Integer)this.txtArbeitszeit.getValue();
        int pausen = (Integer)this.txtPausen.getValue();
        double faktor = (0.0 + (double)arbeitszeit) / (double)(arbeitszeit - pausen);
        return faktor;
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Common.Personal") + "\"> ");
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Common.Personalkostensatz")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Common.ProStunde") + "]", this.getKostenPersonalProPerson()));
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Common.KostenMotorsaege")) + " [" + this.mainWindow.getCurrency() + Messages.getString("ZBaumDurchforstung.proLiterTreibstoff") + "]", this.getKostenMotorsaege()));
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("ZBaumDurchforstung.GeraetekostenKronenschnitteUnten")) + " [" + this.mainWindow.getCurrency() + Messages.getString("ZBaumDurchforstung.proBaum") + "]", this.getKostenKronenschnittUnten()));
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("ZBaumDurchforstung.GeraetekostenKronenschnitteOben")) + " [" + this.mainWindow.getCurrency() + Messages.getString("ZBaumDurchforstung.proBaum") + "]", this.getKostenKronenschnittOben()));
        sb.append(this.getXmlEntry(Messages.getString("Common.TaeglicheArbeitszeit"), this.txtArbeitszeit.getValue()));
        sb.append(this.getXmlEntry("&#160;&#160;" + Messages.getString("Common.DavonBezahlteWegzeitenUndPausen"), this.txtPausen.getValue()));
        sb.append("</section> ");
        return sb.toString();
    }

    @Override
    public void updateCurrency() {
        this.lblKostenPersonalProPerson.setText(String.valueOf(Messages.getString("Common.Personalkostensatz")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Common.ProStunde") + "]");
        this.lblKostenMotorsaege.setText(String.valueOf(Messages.getString("Common.KostenMotorsaege")) + " [" + this.mainWindow.getCurrency() + Messages.getString("ZBaumDurchforstung.proLiterTreibstoff") + "]");
        this.lblKostenKronenschnittUnten.setText(String.valueOf(Messages.getString("ZBaumDurchforstung.GeraetekostenKronenschnitteUnten")) + " [" + this.mainWindow.getCurrency() + Messages.getString("ZBaumDurchforstung.proBaum") + "]");
        this.lblKostenKronenschnittOben.setText(String.valueOf(Messages.getString("ZBaumDurchforstung.GeraetekostenKronenschnitteOben")) + " [" + this.mainWindow.getCurrency() + Messages.getString("ZBaumDurchforstung.proBaum") + "]");
    }
}

