/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.WertastungMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import ch.wsl.fps.juwapfl.model.WertastungModel;
import java.awt.GridLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class WertastungPanel
extends AbstractInputPanel {
    private final WertastungMainWindow mainWindow;
    private final JRadioButton radEtappe1 = new JRadioButton(Messages.getString("Wertastung.Etappe1mitMeterangaben"));
    private final JRadioButton radEtappe2 = new JRadioButton(Messages.getString("Wertastung.Etappe2mitMeterangaben"));
    private final JComboBox<WertastungModel.MethodeEtappe1> cmbMethode1 = new JComboBox<WertastungModel.MethodeEtappe1>(WertastungModel.MethodeEtappe1.values());
    private final JComboBox<WertastungModel.MethodeEtappe2> cmbMethode2 = new JComboBox<WertastungModel.MethodeEtappe2>(WertastungModel.MethodeEtappe2.values());
    private final JComboBox<Integer> cmbEtappe1HoeheUnten = new JComboBox<Integer>(new Integer[]{0, 1, 2, 3});
    private final JComboBox<Integer> cmbEtappe2HoeheUnten = new JComboBox<Integer>(new Integer[]{5, 6});
    private final JComboBox<Integer> cmbEtappe1HoeheOben = new JComboBox<Integer>(new Integer[]{5, 6});
    private final JComboBox<Integer> cmbEtappe2HoeheOben = new JComboBox<Integer>(new Integer[]{10, 11, 12});
    private final JComboBox<WertastungModel.Astigkeit> cmbAstigkeit1 = new JComboBox<WertastungModel.Astigkeit>(WertastungModel.Astigkeit.values(WertastungModel.Etappe.Etappe1));
    private final JComboBox<WertastungModel.Astigkeit> cmbAstigkeit2 = new JComboBox<WertastungModel.Astigkeit>(WertastungModel.Astigkeit.values(WertastungModel.Etappe.Etappe2));

    public WertastungPanel(WertastungMainWindow mainWindow) {
        super(Messages.getString("Wertastung.Titel"));
        this.mainWindow = mainWindow;
        this.setLayout(new GridLayout(0, 3, 5, 0));
        this.add(new JLabel(""));
        this.initRadioButtons();
        this.add(Utilities.getPanelWithoutInfoButton(this.radEtappe1));
        this.add(Utilities.getPanelWithoutInfoButton(this.radEtappe2));
        this.add(new JLabel(Messages.getString("Wertastung.Methode")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbMethode1));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbMethode2));
        this.add(new JLabel(Messages.getString("Wertastung.HoeheUnten")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbEtappe1HoeheUnten));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbEtappe2HoeheUnten));
        this.add(new JLabel(Messages.getString("Wertastung.HoeheOben")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbEtappe1HoeheOben));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbEtappe2HoeheOben));
        this.add(new JLabel(Messages.getString("Wertastung.Astigkeit")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbAstigkeit1));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbAstigkeit2));
        this.cmbMethode1.setSelectedItem(WertastungModel.MethodeEtappe1.getDefault());
        this.cmbMethode2.setSelectedItem(WertastungModel.MethodeEtappe2.getDefault());
        this.cmbEtappe1HoeheUnten.setSelectedItem(0);
        this.cmbEtappe2HoeheUnten.setSelectedItem(6);
        this.cmbEtappe1HoeheOben.setSelectedItem(6);
        this.cmbEtappe2HoeheOben.setSelectedItem(12);
        this.cmbAstigkeit1.setSelectedItem((Object)WertastungModel.Astigkeit.getDefault());
        this.cmbAstigkeit2.setSelectedItem((Object)WertastungModel.Astigkeit.getDefault());
        this.initListeners();
    }

    private void initRadioButtons() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.radEtappe1);
        group.add(this.radEtappe2);
        this.radEtappe1.setHorizontalAlignment(0);
        this.radEtappe2.setHorizontalAlignment(0);
        this.radEtappe1.addItemListener(e -> this.updateRadioButtonDependecies());
        this.radEtappe2.addItemListener(e -> this.updateRadioButtonDependecies());
        this.radEtappe1.setSelected(true);
    }

    private void updateRadioButtonDependecies() {
        boolean isEtappe1 = this.radEtappe1.isSelected();
        this.cmbMethode1.setEnabled(isEtappe1);
        this.cmbEtappe1HoeheUnten.setEnabled(isEtappe1);
        this.cmbEtappe1HoeheOben.setEnabled(isEtappe1);
        this.cmbAstigkeit1.setEnabled(isEtappe1);
        boolean isEtappe2 = this.radEtappe2.isSelected();
        this.cmbMethode2.setEnabled(isEtappe2);
        this.cmbEtappe2HoeheUnten.setEnabled(isEtappe2);
        this.cmbEtappe2HoeheOben.setEnabled(isEtappe2);
        this.cmbAstigkeit2.setEnabled(isEtappe2);
    }

    private void initListeners() {
        this.radEtappe1.addItemListener(this.mainWindow.getDefaultItemListener());
        this.radEtappe2.addItemListener(this.mainWindow.getDefaultItemListener());
        this.cmbMethode1.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbMethode2.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbEtappe1HoeheUnten.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbEtappe2HoeheUnten.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbEtappe1HoeheOben.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbEtappe2HoeheOben.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbAstigkeit1.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbAstigkeit2.addActionListener(this.mainWindow.getDefaultActionListener());
    }

    public WertastungModel.Etappe getEtappe() {
        if (this.radEtappe1.isSelected()) {
            return WertastungModel.Etappe.Etappe1;
        }
        if (this.radEtappe2.isSelected()) {
            return WertastungModel.Etappe.Etappe2;
        }
        return null;
    }

    public WertastungModel.Methode getMethode() {
        if (this.getEtappe() == WertastungModel.Etappe.Etappe1) {
            return this.cmbMethode1.getItemAt(this.cmbMethode1.getSelectedIndex());
        }
        if (this.getEtappe() == WertastungModel.Etappe.Etappe2) {
            return this.cmbMethode2.getItemAt(this.cmbMethode2.getSelectedIndex());
        }
        throw new IllegalStateException();
    }

    public Integer getHoeheUnten() {
        if (this.getEtappe() == WertastungModel.Etappe.Etappe1) {
            return this.cmbEtappe1HoeheUnten.getItemAt(this.cmbEtappe1HoeheUnten.getSelectedIndex());
        }
        if (this.getEtappe() == WertastungModel.Etappe.Etappe2) {
            return this.cmbEtappe2HoeheUnten.getItemAt(this.cmbEtappe2HoeheUnten.getSelectedIndex());
        }
        throw new IllegalStateException();
    }

    public Integer getHoeheOben() {
        if (this.getEtappe() == WertastungModel.Etappe.Etappe1) {
            return this.cmbEtappe1HoeheOben.getItemAt(this.cmbEtappe1HoeheOben.getSelectedIndex());
        }
        if (this.getEtappe() == WertastungModel.Etappe.Etappe2) {
            return this.cmbEtappe2HoeheOben.getItemAt(this.cmbEtappe2HoeheOben.getSelectedIndex());
        }
        throw new IllegalStateException();
    }

    public WertastungModel.Astigkeit getAstigkeit() {
        if (this.getEtappe() == WertastungModel.Etappe.Etappe1) {
            return this.cmbAstigkeit1.getItemAt(this.cmbAstigkeit1.getSelectedIndex());
        }
        if (this.getEtappe() == WertastungModel.Etappe.Etappe2) {
            return this.cmbAstigkeit2.getItemAt(this.cmbAstigkeit2.getSelectedIndex());
        }
        throw new IllegalStateException();
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Wertastung.Titel") + "\"> ");
        sb.append(this.getXmlEntry(Messages.getString("Wertastung.Etappe"), (Object)this.getEtappe()));
        sb.append(this.getXmlEntry(Messages.getString("Wertastung.Methode"), this.getMethode()));
        sb.append(this.getXmlEntry(Messages.getString("Wertastung.HoeheUnten"), this.getHoeheUnten()));
        sb.append(this.getXmlEntry(Messages.getString("Wertastung.HoeheOben"), this.getHoeheOben()));
        sb.append(this.getXmlEntry(Messages.getString("Wertastung.Astigkeit"), (Object)this.getAstigkeit()));
        sb.append("</section> ");
        return sb.toString();
    }
}

