/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.main.WertastungMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import ch.wsl.fps.juwapfl.model.WertastungModel;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class WertastungBestandPanel
extends AbstractInputPanel {
    private final WertastungMainWindow mainWindow;
    private final JComboBox<WertastungModel.Baumart> cmbBaumart = new JComboBox<WertastungModel.Baumart>(WertastungModel.Baumart.values());
    private final JSpinner txtAnzahlBaeume = new JSpinner(new SpinnerNumberModel(30, 1, 200, 1));
    private final JSpinner txtAnzahlHektare = new JSpinner(new SpinnerNumberModel(1.5, 0.1, 1000.0, 0.5));
    private final JComboBox<WertastungModel.Hangneigung> cmbHangneigung = new JComboBox<WertastungModel.Hangneigung>(WertastungModel.Hangneigung.values());

    public WertastungBestandPanel(WertastungMainWindow mainWindow) {
        super(Messages.getString("Wertastung.Bestand"));
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtAnzahlBaeume, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtAnzahlHektare, false);
        this.mainWindow = mainWindow;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(new JLabel(Messages.getString("Wertastung.Baumart")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbBaumart));
        this.add(new JLabel(Messages.getString("Wertastung.AnzahlAstungsbaeumeProHa")));
        String infoButtonText = Messages.getString("Wertastung.InfoButtonAnzahlAstungsbaeume");
        this.add(Utilities.getPanelWithInfoButton(this.txtAnzahlBaeume, infoButtonText));
        this.add(new JLabel(Messages.getString("Wertastung.FlaecheBestand")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtAnzahlHektare));
        this.add(new JLabel(Messages.getString("Wertastung.Hangneigung")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbHangneigung));
        this.cmbBaumart.setSelectedItem((Object)WertastungModel.Baumart.getDefault());
        this.cmbHangneigung.setSelectedItem((Object)WertastungModel.Hangneigung.getDefault());
        this.initListeners();
    }

    private void initListeners() {
        this.cmbBaumart.addActionListener(this.mainWindow.getDefaultActionListener());
        this.txtAnzahlBaeume.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtAnzahlHektare.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.cmbHangneigung.addActionListener(this.mainWindow.getDefaultActionListener());
    }

    public WertastungModel.Baumart getBaumart() {
        return this.cmbBaumart.getItemAt(this.cmbBaumart.getSelectedIndex());
    }

    public Integer getAnzahlBaeume() {
        return (Integer)this.txtAnzahlBaeume.getValue();
    }

    public Double getAnzahlHektare() {
        return (Double)this.txtAnzahlHektare.getValue();
    }

    public WertastungModel.Hangneigung getHangneigung() {
        return this.cmbHangneigung.getItemAt(this.cmbHangneigung.getSelectedIndex());
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Wertastung.Bestand") + "\"> ");
        sb.append(this.getXmlEntry(Messages.getString("Wertastung.Baumart"), (Object)this.getBaumart()));
        sb.append(this.getXmlEntry(Messages.getString("Wertastung.AnzahlAstungsbaeumeProHa"), this.getAnzahlBaeume()));
        sb.append(this.getXmlEntry(Messages.getString("Wertastung.FlaecheBestand"), this.getAnzahlHektare()));
        sb.append(this.getXmlEntry(Messages.getString("Wertastung.Hangneigung"), (Object)this.getHangneigung()));
        sb.append("</section> ");
        return sb.toString();
    }
}

