/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.CurrencySensitive;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class SimplePersonalPanel
extends AbstractInputPanel
implements CurrencySensitive {
    private final AbstractMainWindow mainWindow;
    private final JLabel lblKostenPersonalProPerson = new JLabel();
    protected final JSpinner txtKostenPersonalProPerson = new JSpinner(new SpinnerNumberModel(70, 0, 500, 1));
    private final JSpinner txtArbeitszeit = new JSpinner(new SpinnerNumberModel(510, 60, 1000, 10));
    private final JSpinner txtPausen = new JSpinner(new SpinnerNumberModel(60, 0, 1000, 10));

    public SimplePersonalPanel(AbstractMainWindow mainWindow, boolean addInfoButtonMultiplePersons) {
        super(Messages.getString("Common.TitelPersonal"));
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtKostenPersonalProPerson, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtArbeitszeit, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtPausen, false);
        this.mainWindow = mainWindow;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(this.lblKostenPersonalProPerson);
        if (addInfoButtonMultiplePersons) {
            String infoButtonText = Messages.getString("Common.InfoButtonPersonalkostensatz");
            this.add(Utilities.getPanelWithInfoButton(this.txtKostenPersonalProPerson, infoButtonText));
        } else {
            this.add(Utilities.getPanelWithoutInfoButton(this.txtKostenPersonalProPerson));
        }
        this.add(new JLabel(Messages.getString("Common.TaeglicheArbeitszeit")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtArbeitszeit));
        this.add(new JLabel("   " + Messages.getString("Common.DavonBezahlteWegzeitenUndPausen")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtPausen));
        this.updatePausenMaximum();
        this.initListeners();
        mainWindow.registerForCurrencyUpdates(this);
    }

    private void initListeners() {
        this.txtKostenPersonalProPerson.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtArbeitszeit.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtArbeitszeit.addChangeListener(e -> this.updatePausenMaximum());
        this.txtPausen.addChangeListener(this.mainWindow.getDefaultChangeListener());
    }

    private void updatePausenMaximum() {
        int arbeitszeit = (Integer)this.txtArbeitszeit.getValue();
        int maximum = arbeitszeit - 10;
        ((SpinnerNumberModel)this.txtPausen.getModel()).setMaximum(Integer.valueOf(maximum));
        if ((Integer)this.txtPausen.getValue() > maximum) {
            this.txtPausen.setValue(maximum);
        }
    }

    public Integer getKostenPersonalProPerson_proH() {
        return (Integer)this.txtKostenPersonalProPerson.getValue();
    }

    public double getFaktorWegzeitenUndPausen() {
        int arbeitszeit = (Integer)this.txtArbeitszeit.getValue();
        int pausen = (Integer)this.txtPausen.getValue();
        double faktor = (0.0 + (double)arbeitszeit) / (double)(arbeitszeit - pausen);
        return faktor;
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Common.TitelPersonal") + "\"> ");
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Common.Personalkostensatz")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Common.ProStunde") + "]", this.getKostenPersonalProPerson_proH()));
        sb.append(this.getXmlEntry(Messages.getString("Common.TaeglicheArbeitszeit"), this.txtArbeitszeit.getValue()));
        sb.append(this.getXmlEntry("&#160;&#160;" + Messages.getString("Common.DavonBezahlteWegzeitenUndPausen"), this.txtPausen.getValue()));
        sb.append("</section> ");
        return sb.toString();
    }

    @Override
    public void updateCurrency() {
        this.lblKostenPersonalProPerson.setText(String.valueOf(Messages.getString("Common.Personalkostensatz")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Common.ProStunde") + "]");
    }
}

