/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.CurrencySensitive;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import java.awt.GridLayout;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class SchneegleitenAbbauPanel
extends AbstractInputPanel
implements CurrencySensitive {
    private final AbstractMainWindow mainWindow;
    private final JLabel lblFahrzeugkosten_ChfProEinheit = new JLabel();
    private final JLabel lblEntsorgunggebuehren_ChfProEinheit = new JLabel();
    private final JSpinner txtPersonalzeit_minProEinheit = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0));
    private final JSpinner txtFahrzeugkosten_ChfProEinheit = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0));
    private final JSpinner txtEntsorgungsgebuehren_ChfProEinheit = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0));

    public SchneegleitenAbbauPanel(AbstractMainWindow mainWindow) {
        super(Messages.getString("Schneegleiten.TitelZeitenKostenAbbauEntsorgung"));
        this.mainWindow = mainWindow;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(new JLabel(Messages.getString("Schneegleiten.ReineArbeitszeit")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtPersonalzeit_minProEinheit));
        this.add(this.lblFahrzeugkosten_ChfProEinheit);
        this.add(Utilities.getPanelWithoutInfoButton(this.txtFahrzeugkosten_ChfProEinheit));
        this.add(this.lblEntsorgunggebuehren_ChfProEinheit);
        this.add(Utilities.getPanelWithoutInfoButton(this.txtEntsorgungsgebuehren_ChfProEinheit));
        this.initFields();
        this.initListeners();
        mainWindow.registerForCurrencyUpdates(this);
    }

    private void initFields() {
        this.txtPersonalzeit_minProEinheit.setEditor(new JSpinner.NumberEditor(this.txtPersonalzeit_minProEinheit, "0.00"));
        this.txtFahrzeugkosten_ChfProEinheit.setEditor(new JSpinner.NumberEditor(this.txtFahrzeugkosten_ChfProEinheit, "0.00"));
        this.txtEntsorgungsgebuehren_ChfProEinheit.setEditor(new JSpinner.NumberEditor(this.txtEntsorgungsgebuehren_ChfProEinheit, "0.00"));
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtPersonalzeit_minProEinheit, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtFahrzeugkosten_ChfProEinheit, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtEntsorgungsgebuehren_ChfProEinheit, false);
    }

    private void initListeners() {
        this.txtPersonalzeit_minProEinheit.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtFahrzeugkosten_ChfProEinheit.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtEntsorgungsgebuehren_ChfProEinheit.addChangeListener(this.mainWindow.getDefaultChangeListener());
    }

    public Double getPersonalzeit_minProEinheit() {
        return (Double)this.txtPersonalzeit_minProEinheit.getValue();
    }

    public Double getFahrzeugkosten_ChfProEinheit() {
        return (Double)this.txtFahrzeugkosten_ChfProEinheit.getValue();
    }

    public Double getEntsorgungsgebuehren_ChfProEinheit() {
        return (Double)this.txtEntsorgungsgebuehren_ChfProEinheit.getValue();
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Schneegleiten.TitelZeitenKostenAbbauEntsorgung") + "\"> ");
        sb.append(this.getXmlEntry(Messages.getString("Schneegleiten.ReineArbeitszeit"), this.getPersonalzeit_minProEinheit()));
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Schneegleiten.Fahrzeugkosten")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Schneegleiten.ProEinheit") + "]", this.getFahrzeugkosten_ChfProEinheit()));
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Schneegleiten.Entsorgungsgebuehren")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Schneegleiten.ProEinheit") + "]", this.getFahrzeugkosten_ChfProEinheit()));
        sb.append("</section> ");
        return sb.toString();
    }

    @Override
    public void updateCurrency() {
        this.lblFahrzeugkosten_ChfProEinheit.setText(String.valueOf(Messages.getString("Schneegleiten.Fahrzeugkosten")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Schneegleiten.ProEinheit") + "]");
        this.lblEntsorgunggebuehren_ChfProEinheit.setText(String.valueOf(Messages.getString("Schneegleiten.Entsorgungsgebuehren")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Schneegleiten.ProEinheit") + "]");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Arrays.asList(this.getComponents()).forEach(c -> c.setEnabled(enabled));
    }

    public void setAllFieldsToZero() {
        this.txtPersonalzeit_minProEinheit.setValue(0.0);
        this.txtFahrzeugkosten_ChfProEinheit.setValue(0.0);
        this.txtEntsorgungsgebuehren_ChfProEinheit.setValue(0.0);
    }
}

