/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.CurrencySensitive;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class RueckegassenPersonalPanel
extends AbstractInputPanel
implements CurrencySensitive {
    private final AbstractMainWindow mainWindow;
    private final JLabel lblKostenHauptperson = new JLabel();
    private final JSpinner txtKostenHauptperson = new JSpinner(new SpinnerNumberModel(80, 0, 1000, 1));
    private final JLabel lblKostenHilfskraft = new JLabel();
    private final JSpinner txtKostenHilfskraft = new JSpinner(new SpinnerNumberModel(50, 0, 1000, 1));
    private final JSpinner txtArbeitszeit = new JSpinner(new SpinnerNumberModel(510, 60, 1000, 10));
    private final JSpinner txtPausen = new JSpinner(new SpinnerNumberModel(60, 0, 1000, 10));

    public RueckegassenPersonalPanel(AbstractMainWindow mainWindow) {
        super(Messages.getString("Common.TitelPersonal"));
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtKostenHauptperson, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtKostenHilfskraft, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtArbeitszeit, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtPausen, false);
        this.mainWindow = mainWindow;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(this.lblKostenHauptperson);
        this.add(Utilities.getPanelWithoutInfoButton(this.txtKostenHauptperson));
        this.add(this.lblKostenHilfskraft);
        this.add(Utilities.getPanelWithoutInfoButton(this.txtKostenHilfskraft));
        this.add(new JLabel(Messages.getString("Common.TaeglicheArbeitszeit")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtArbeitszeit));
        this.add(new JLabel("   " + Messages.getString("Common.DavonBezahlteWegzeitenUndPausen")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtPausen));
        this.updatePausenMaximum();
        this.initListeners();
        mainWindow.registerForCurrencyUpdates(this);
    }

    private void initListeners() {
        this.txtKostenHauptperson.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtKostenHilfskraft.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtArbeitszeit.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtArbeitszeit.addChangeListener(e -> this.updatePausenMaximum());
        this.txtPausen.addChangeListener(this.mainWindow.getDefaultChangeListener());
    }

    private void updatePausenMaximum() {
        int arbeitszeit = (Integer)this.txtArbeitszeit.getValue();
        int maximum = arbeitszeit - 10;
        ((SpinnerNumberModel)this.txtPausen.getModel()).setMaximum(Integer.valueOf(maximum));
        if ((Integer)this.txtPausen.getValue() > maximum) {
            this.txtPausen.setValue(maximum);
        }
    }

    public Integer getKostenHauptperson() {
        return (Integer)this.txtKostenHauptperson.getValue();
    }

    public Integer getKostenHilfskraft() {
        return (Integer)this.txtKostenHilfskraft.getValue();
    }

    public double getFaktorWegzeitenUndPausen() {
        int arbeitszeit = (Integer)this.txtArbeitszeit.getValue();
        int pausen = (Integer)this.txtPausen.getValue();
        double faktor = (0.0 + (double)arbeitszeit) / (double)(arbeitszeit - pausen);
        return faktor;
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Common.TitelPersonal") + "\"> ");
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Rueckegassen.Hauptperson")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Common.ProStunde") + "]", this.getKostenHauptperson()));
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Rueckegassen.Hilfskraft")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Common.ProStunde") + "]", this.getKostenHilfskraft()));
        sb.append(this.getXmlEntry(Messages.getString("Common.TaeglicheArbeitszeit"), this.txtArbeitszeit.getValue()));
        sb.append(this.getXmlEntry("&#160;&#160;" + Messages.getString("Common.DavonBezahlteWegzeitenUndPausen"), this.txtPausen.getValue()));
        sb.append("</section> ");
        return sb.toString();
    }

    @Override
    public void updateCurrency() {
        this.lblKostenHauptperson.setText(String.valueOf(Messages.getString("Rueckegassen.Hauptperson")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Common.ProStunde") + "]");
        this.lblKostenHilfskraft.setText(String.valueOf(Messages.getString("Rueckegassen.Hilfskraft")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Common.ProStunde") + "]");
    }
}

