/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import ch.wsl.fps.juwapfl.model.RueckegassenModel;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class RueckegassenObjektPanel
extends AbstractInputPanel {
    private final AbstractMainWindow mainWindow;
    private final JSpinner txtAnzahlHektare = new JSpinner(new SpinnerNumberModel(50.0, 1.0, 1000.0, 0.5));
    private final JComboBox<RueckegassenModel.Verhaeltnisse> cmbVerhaeltnisse = new JComboBox<RueckegassenModel.Verhaeltnisse>(RueckegassenModel.Verhaeltnisse.values());
    private final JSpinner txtAbstandRueckegassen = new JSpinner(new SpinnerNumberModel(30, 20, 60, 1));

    public RueckegassenObjektPanel(AbstractMainWindow mainWindow) {
        super(Messages.getString("Rueckegassen.TitelObjekt"));
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtAnzahlHektare, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtAbstandRueckegassen, false);
        this.mainWindow = mainWindow;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(new JLabel(Messages.getString("Rueckegassen.FlaecheHa")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtAnzahlHektare));
        this.add(new JLabel(Messages.getString("Rueckegassen.Verhaeltnisse")));
        this.add(Utilities.getPanelWithInfoButton(this.cmbVerhaeltnisse, Messages.getString("Rueckegassen.VerhaeltnisseInfoButton")));
        this.add(new JLabel(Messages.getString("Rueckegassen.AbstandRueckegassen")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtAbstandRueckegassen));
        this.cmbVerhaeltnisse.setSelectedItem((Object)RueckegassenModel.Verhaeltnisse.getDefault());
        this.initListeners();
    }

    private void initListeners() {
        this.txtAnzahlHektare.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.cmbVerhaeltnisse.addActionListener(this.mainWindow.getDefaultActionListener());
        this.txtAbstandRueckegassen.addChangeListener(this.mainWindow.getDefaultChangeListener());
    }

    public Double getAnzahlHektare() {
        return (Double)this.txtAnzahlHektare.getValue();
    }

    public RueckegassenModel.Verhaeltnisse getVerhaeltnisse() {
        return this.cmbVerhaeltnisse.getItemAt(this.cmbVerhaeltnisse.getSelectedIndex());
    }

    public Integer getAbstandRueckegassen_m() {
        return (Integer)this.txtAbstandRueckegassen.getValue();
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Rueckegassen.TitelObjekt") + "\"> ");
        sb.append(this.getXmlEntry(Messages.getString("Rueckegassen.FlaecheHa"), this.getAnzahlHektare()));
        sb.append(this.getXmlEntry(Messages.getString("Rueckegassen.Verhaeltnisse"), (Object)this.getVerhaeltnisse()));
        sb.append(this.getXmlEntry(Messages.getString("Rueckegassen.AbstandRueckegassen"), this.getAbstandRueckegassen_m()));
        sb.append("</section> ");
        return sb.toString();
    }
}

