/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.CurrencySensitive;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.controls.JFlashingSpinner;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.main.PflanzungMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import ch.wsl.fps.juwapfl.model.PflanzungModel;
import ch.wsl.fps.juwapfl.model.PflanzungWinkelpflanzungModel;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class PflanzungZeitenKostenPanel
extends AbstractInputPanel
implements CurrencySensitive {
    private static final double DEFAULT_ZEIT_BESCHAFFUNG_H = 1.0;
    private final PflanzungMainWindow mainWindow;
    private final JSpinner txtZeitBeschaffung_h = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 10000.0, 1.0));
    private final JLabel lblKostenProPflanze = new JLabel();
    private final JFlashingSpinner txtKostenProPflanze = new JFlashingSpinner(new SpinnerNumberModel(4.5, 0.0, 100000.0, 1.0));
    private final JSpinner txtZeitTransport_h = new JSpinner(new SpinnerNumberModel(3.0, 0.0, 10000.0, 1.0));
    private final JLabel lblKostenTransportmittel = new JLabel();
    private final JSpinner txtKostenTransportmittel = new JSpinner(new SpinnerNumberModel(120.0, 0.0, 1000000.0, 1.0));
    private final JFlashingSpinner txtZeitPflanzung_PflProH = new JFlashingSpinner(new SpinnerNumberModel(1.0, 0.01, 10000.0, 1.0));
    private final JFlashingSpinner txtAnteilMaschinenlaufzeit_Prz = new JFlashingSpinner(new SpinnerNumberModel(100, 0, 100, 1));
    private final JLabel lblKostensatzGeraet_proH = new JLabel();
    private final JFlashingSpinner txtKostensatzGeraet_proH = new JFlashingSpinner(new SpinnerNumberModel(1.0, 0.0, 100000.0, 1.0));
    private final JSpinner txtZeitUnterhalt_Prozent = new JSpinner(new SpinnerNumberModel(10, 0, 2000, 10));
    private PflanzungModel.Pflanzwerkzeug pflanzwerkzeug;
    private PflanzungModel.Pflanztechnik pflanztechnik;
    private PflanzungModel.Baumart baumart;
    private PflanzungModel.Schwierigkeitsgrad schwierigkeit;
    private PflanzungWinkelpflanzungModel winkelpflanzungModel;

    public PflanzungZeitenKostenPanel(PflanzungMainWindow mainWindow) {
        super(Messages.getString("Pflanzung.TitelZeitaufwaendeKosten"), Messages.getString("Pflanzung.InfoButtonZeitenKosten"));
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtZeitBeschaffung_h, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtKostenProPflanze, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtZeitTransport_h, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtKostenTransportmittel, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtZeitPflanzung_PflProH, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtAnteilMaschinenlaufzeit_Prz, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtKostensatzGeraet_proH, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtZeitUnterhalt_Prozent, false);
        this.mainWindow = mainWindow;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        int strutSize = 2;
        this.add(new JLabel(Messages.getString("Pflanzung.ZeitaufwandBeschaffung")));
        String infoButtonTextZeitBeschaffung = Messages.getString("Pflanzung.InfoButtonZeitaufwandBeschaffung");
        this.add(Utilities.getPanelWithInfoButton(this.txtZeitBeschaffung_h, infoButtonTextZeitBeschaffung));
        this.add(this.lblKostenProPflanze);
        this.add(Utilities.getPanelWithoutInfoButton(this.txtKostenProPflanze));
        this.add(Box.createVerticalStrut(2));
        this.add(Box.createVerticalStrut(2));
        this.add(new JLabel(Messages.getString("Pflanzung.ZeitaufwandTransport")));
        String infoButtonTextZeitTransport = Messages.getString("Pflanzung.InfoButtonZeitaufwandTransport");
        this.add(Utilities.getPanelWithInfoButton(this.txtZeitTransport_h, infoButtonTextZeitTransport));
        this.add(this.lblKostenTransportmittel);
        String infoButtonTextKostenTransportmittel = Messages.getString("Pflanzung.InfoButtonKostenTransport");
        this.add(Utilities.getPanelWithInfoButton(this.txtKostenTransportmittel, infoButtonTextKostenTransportmittel));
        this.add(Box.createVerticalStrut(2));
        this.add(Box.createVerticalStrut(2));
        this.add(new JLabel(Messages.getString("Pflanzung.Pflanzleistung")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtZeitPflanzung_PflProH));
        this.add(new JLabel(Messages.getString("Pflanzung.Maschinenlaufzeit")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtAnteilMaschinenlaufzeit_Prz));
        this.add(this.lblKostensatzGeraet_proH);
        this.add(Utilities.getPanelWithoutInfoButton(this.txtKostensatzGeraet_proH));
        this.add(Box.createVerticalStrut(2));
        this.add(Box.createVerticalStrut(2));
        this.add(new JLabel(Messages.getString("Pflanzung.ZeitaufwandUnterhalt")));
        String infoButtonTextZeitUnterhalt = Messages.getString("Pflanzung.InfoButtonZeitaufwandUnterhalt");
        this.add(Utilities.getPanelWithInfoButton(this.txtZeitUnterhalt_Prozent, infoButtonTextZeitUnterhalt));
        this.initListeners();
        mainWindow.registerForCurrencyUpdates(this);
    }

    private void initListeners() {
        this.txtZeitBeschaffung_h.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtKostenProPflanze.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtZeitTransport_h.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtKostenTransportmittel.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtZeitPflanzung_PflProH.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtAnteilMaschinenlaufzeit_Prz.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtKostensatzGeraet_proH.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtZeitUnterhalt_Prozent.addChangeListener(this.mainWindow.getDefaultChangeListener());
    }

    public void onInputChangedBeforeCalculation(PflanzungModel.Pflanzwerkzeug pflanzwerkzeug, PflanzungModel.Pflanztechnik pflanztechnik, PflanzungModel.Baumart baumart, PflanzungModel.Schwierigkeitsgrad schwierigkeit, PflanzungWinkelpflanzungModel winkelpflanzungModel) {
        if (this.pflanzwerkzeug != pflanzwerkzeug || this.pflanztechnik != pflanztechnik || this.baumart != baumart || this.schwierigkeit != schwierigkeit) {
            this.txtKostenProPflanze.setValue(PflanzungModel.getDefaultKostenProPflanze(pflanzwerkzeug, pflanztechnik));
            this.txtZeitPflanzung_PflProH.setValue(PflanzungModel.getDefaultZeitaufwandPflanzung_PflProH(pflanzwerkzeug, pflanztechnik, baumart, schwierigkeit, winkelpflanzungModel));
            this.txtAnteilMaschinenlaufzeit_Prz.setValue(PflanzungModel.getDefaultAnteilMaschinenlaufzeit_Prz(pflanzwerkzeug, pflanztechnik, schwierigkeit));
            this.txtKostensatzGeraet_proH.setValue(PflanzungModel.getDefaultKostensatzGeraet_proH(pflanzwerkzeug, pflanztechnik));
            if (!this.mainWindow.isInitializing) {
                this.txtKostenProPflanze.flash();
                this.txtZeitPflanzung_PflProH.flash();
                this.txtAnteilMaschinenlaufzeit_Prz.flash();
                this.txtKostensatzGeraet_proH.flash();
            }
        } else if (!this.winkelpflanzungModel.equals(winkelpflanzungModel)) {
            this.txtZeitPflanzung_PflProH.setValue(PflanzungModel.getDefaultZeitaufwandPflanzung_PflProH(pflanzwerkzeug, pflanztechnik, baumart, schwierigkeit, winkelpflanzungModel));
            if (!this.mainWindow.isInitializing) {
                this.txtZeitPflanzung_PflProH.flash();
            }
        }
        this.pflanzwerkzeug = pflanzwerkzeug;
        this.pflanztechnik = pflanztechnik;
        this.baumart = baumart;
        this.schwierigkeit = schwierigkeit;
        this.winkelpflanzungModel = winkelpflanzungModel;
        this.txtAnteilMaschinenlaufzeit_Prz.setEnabled(pflanztechnik == PflanzungModel.Pflanztechnik.MASCHINELL);
        this.txtKostensatzGeraet_proH.setEnabled(pflanztechnik == PflanzungModel.Pflanztechnik.MASCHINELL);
    }

    public double getZeitBeschaffung_h() {
        return (Double)this.txtZeitBeschaffung_h.getValue();
    }

    public double getKostenProPflanze() {
        return (Double)this.txtKostenProPflanze.getValue();
    }

    public double getZeitTransport_h() {
        return (Double)this.txtZeitTransport_h.getValue();
    }

    public double getKostenTransportmittel() {
        return (Double)this.txtKostenTransportmittel.getValue();
    }

    public double getZeitPflanzung_PflProH() {
        return (Double)this.txtZeitPflanzung_PflProH.getValue();
    }

    public int getAnteilMaschinenlaufzeit_Prz() {
        return (Integer)this.txtAnteilMaschinenlaufzeit_Prz.getValue();
    }

    public double getKostensatzGeraet_proH() {
        return (Double)this.txtKostensatzGeraet_proH.getValue();
    }

    public int getZeitUnterhalt_Prozent() {
        return (Integer)this.txtZeitUnterhalt_Prozent.getValue();
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Pflanzung.TitelZeitaufwaendeKosten") + "\"> ");
        sb.append(this.getXmlEntry(Messages.getString("Pflanzung.ZeitaufwandBeschaffung"), this.getZeitBeschaffung_h()));
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Pflanzung.KostenProPflanze")) + " [" + this.mainWindow.getCurrency() + "]", this.getKostenProPflanze()));
        sb.append(this.getXmlEntry(Messages.getString("Pflanzung.ZeitaufwandTransport"), this.getZeitTransport_h()));
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Pflanzung.KostenTransportmittel")) + " [" + this.mainWindow.getCurrency() + "]", this.getKostenTransportmittel()));
        sb.append(this.getXmlEntry(Messages.getString("Pflanzung.Pflanzleistung"), this.getZeitPflanzung_PflProH()));
        if (this.pflanztechnik == PflanzungModel.Pflanztechnik.MASCHINELL) {
            sb.append(this.getXmlEntry(Messages.getString("Pflanzung.Maschinenlaufzeit"), this.getAnteilMaschinenlaufzeit_Prz()));
            sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Pflanzung.KostensatzBohrgeraet")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Common.ProStunde") + "]", this.getKostensatzGeraet_proH()));
        }
        sb.append(this.getXmlEntry(Messages.getString("Pflanzung.ZeitaufwandUnterhalt"), this.getZeitUnterhalt_Prozent()));
        sb.append("</section> ");
        return sb.toString();
    }

    @Override
    public void updateCurrency() {
        this.lblKostenProPflanze.setText(String.valueOf(Messages.getString("Pflanzung.KostenProPflanze")) + " [" + this.mainWindow.getCurrency() + "]");
        this.lblKostenTransportmittel.setText(String.valueOf(Messages.getString("Pflanzung.KostenTransportmittel")) + " [" + this.mainWindow.getCurrency() + "]");
        this.lblKostensatzGeraet_proH.setText(String.valueOf(Messages.getString("Pflanzung.KostensatzBohrgeraet")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Common.ProStunde") + "]");
    }
}

