/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.CurrencySensitive;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class MaterialkostenAbsolutPanel
extends AbstractInputPanel
implements CurrencySensitive {
    private final AbstractMainWindow mainWindow;
    private final JLabel lblMaterialkosten = new JLabel();
    private final JSpinner txtMaterialkosten = new JSpinner(new SpinnerNumberModel(3.85, 0.0, 10000.0, 0.1));

    public MaterialkostenAbsolutPanel(AbstractMainWindow mainWindow) {
        super(Messages.getString("Common.TitelMaterial"));
        this.txtMaterialkosten.setEditor(new JSpinner.NumberEditor(this.txtMaterialkosten, "0.00"));
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtMaterialkosten, false);
        this.mainWindow = mainWindow;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(this.lblMaterialkosten);
        this.add(Utilities.getPanelWithoutInfoButton(this.txtMaterialkosten));
        this.initListeners();
        mainWindow.registerForCurrencyUpdates(this);
    }

    private void initListeners() {
        this.txtMaterialkosten.addChangeListener(this.mainWindow.getDefaultChangeListener());
    }

    public Double getMaterialkosten() {
        return (Double)this.txtMaterialkosten.getValue();
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Common.TitelMaterialkosten") + "\"> ");
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Rueckegassen.Geraetekosten")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Common.proHektareKurz") + "]", this.getMaterialkosten()));
        sb.append("</section> ");
        return sb.toString();
    }

    @Override
    public void updateCurrency() {
        this.lblMaterialkosten.setText(String.valueOf(Messages.getString("Rueckegassen.Geraetekosten")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Common.proHektareKurz") + "]");
    }
}

