/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.controls.JFlashingSpinner;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import ch.wsl.fps.juwapfl.model.BegehungswegeModel;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.SpinnerNumberModel;

public class BegehungswegeZeitenPanel
extends AbstractInputPanel {
    private final AbstractMainWindow mainWindow;
    private final JFlashingSpinner txtZeitaufwand_minProM = new JFlashingSpinner(new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0));
    private BegehungswegeModel.Begehungsweg begehungsweg;
    private BegehungswegeModel.Ausfuehrung ausfuehrung;
    private BegehungswegeModel.GelaendeSchwierigkeit schwierigkeit;

    public BegehungswegeZeitenPanel(AbstractMainWindow mainWindow) {
        super(Messages.getString("Begehungswege.Zeitaufwaende"));
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtZeitaufwand_minProM, false);
        this.mainWindow = mainWindow;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(new JLabel(Messages.getString("Begehungswege.ReineArbeitszeit")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtZeitaufwand_minProM));
        this.initListeners();
    }

    private void initListeners() {
        this.txtZeitaufwand_minProM.addChangeListener(this.mainWindow.getDefaultChangeListener());
    }

    public void onInputChangedBeforeCalculation(BegehungswegeModel.Begehungsweg begehungsweg, BegehungswegeModel.Ausfuehrung ausfuehrung, BegehungswegeModel.GelaendeSchwierigkeit schwierigkeit) {
        if (this.begehungsweg != begehungsweg || this.ausfuehrung != ausfuehrung || this.schwierigkeit != schwierigkeit) {
            this.begehungsweg = begehungsweg;
            this.ausfuehrung = ausfuehrung;
            this.schwierigkeit = schwierigkeit;
            this.txtZeitaufwand_minProM.setValue(BegehungswegeModel.getDefaultZeitaufwand_minProM(begehungsweg, ausfuehrung, schwierigkeit));
            if (!this.mainWindow.isInitializing) {
                this.txtZeitaufwand_minProM.flash();
            }
        }
    }

    public Double getZeitaufwand_minProM() {
        return (Double)this.txtZeitaufwand_minProM.getValue();
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Begehungswege.Zeitaufwaende") + "\"> ");
        sb.append(this.getXmlEntry(Messages.getString("Begehungswege.ReineArbeitszeit"), this.getZeitaufwand_minProM()));
        sb.append("</section> ");
        return sb.toString();
    }
}

