/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.CurrencySensitive;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class BegehungswegePersonalPanel
extends AbstractInputPanel
implements CurrencySensitive {
    private static final int DEFAULT_KOSTENSATZ_MASCHINE = 65;
    private final AbstractMainWindow mainWindow;
    private final JLabel lblKostenPersonal = new JLabel();
    private final JSpinner txtKostenPersonal = new JSpinner(new SpinnerNumberModel(70, 0, 1000, 1));
    private final JLabel lblKostenMaschine = new JLabel();
    private final JSpinner txtKostenMaschine = new JSpinner(new SpinnerNumberModel(65, 0, 1000, 1));
    private final JSpinner txtArbeitszeit = new JSpinner(new SpinnerNumberModel(510, 60, 1000, 10));
    private final JSpinner txtPausen = new JSpinner(new SpinnerNumberModel(60, 0, 1000, 10));

    public BegehungswegePersonalPanel(AbstractMainWindow mainWindow) {
        super(Messages.getString("Begehungswege.TitelPersonalUndMaschinen"));
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtKostenPersonal, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtKostenMaschine, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtArbeitszeit, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtPausen, false);
        this.mainWindow = mainWindow;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(this.lblKostenPersonal);
        this.add(Utilities.getPanelWithoutInfoButton(this.txtKostenPersonal));
        this.add(this.lblKostenMaschine);
        this.add(Utilities.getPanelWithoutInfoButton(this.txtKostenMaschine));
        this.add(new JLabel(Messages.getString("Common.TaeglicheArbeitszeit")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtArbeitszeit));
        this.add(new JLabel("   " + Messages.getString("Common.DavonBezahlteWegzeitenUndPausen")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtPausen));
        this.updatePausenMaximum();
        this.initListeners();
        mainWindow.registerForCurrencyUpdates(this);
    }

    private void initListeners() {
        this.txtKostenPersonal.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtKostenMaschine.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtArbeitszeit.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtArbeitszeit.addChangeListener(e -> this.updatePausenMaximum());
        this.txtPausen.addChangeListener(this.mainWindow.getDefaultChangeListener());
    }

    private void updatePausenMaximum() {
        int arbeitszeit = (Integer)this.txtArbeitszeit.getValue();
        int maximum = arbeitszeit - 10;
        ((SpinnerNumberModel)this.txtPausen.getModel()).setMaximum(Integer.valueOf(maximum));
        if ((Integer)this.txtPausen.getValue() > maximum) {
            this.txtPausen.setValue(maximum);
        }
    }

    public Integer getKostenPersonal() {
        return (Integer)this.txtKostenPersonal.getValue();
    }

    public Integer getKostenMaschine() {
        return (Integer)this.txtKostenMaschine.getValue();
    }

    public double getFaktorWegzeitenUndPausen() {
        int arbeitszeit = (Integer)this.txtArbeitszeit.getValue();
        int pausen = (Integer)this.txtPausen.getValue();
        double faktor = (0.0 + (double)arbeitszeit) / (double)(arbeitszeit - pausen);
        return faktor;
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Begehungswege.TitelPersonalUndMaschinen") + "\"> ");
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Common.Personalkostensatz")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Common.ProStunde") + "]", this.getKostenPersonal()));
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Common.KostensatzMaschine")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Common.ProStunde") + "]", this.getKostenMaschine()));
        sb.append(this.getXmlEntry(Messages.getString("Common.TaeglicheArbeitszeit"), this.txtArbeitszeit.getValue()));
        sb.append(this.getXmlEntry("&#160;&#160;" + Messages.getString("Common.DavonBezahlteWegzeitenUndPausen"), this.txtPausen.getValue()));
        sb.append("</section> ");
        return sb.toString();
    }

    @Override
    public void updateCurrency() {
        this.lblKostenPersonal.setText(String.valueOf(Messages.getString("Common.Personalkostensatz")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Common.ProStunde") + "]");
        this.lblKostenMaschine.setText(String.valueOf(Messages.getString("Common.KostensatzMaschine")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Common.ProStunde") + "]");
    }
}

