/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.main.BegehungswegeMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import ch.wsl.fps.juwapfl.model.BegehungswegeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class BegehungswegePanel
extends AbstractInputPanel {
    private final BegehungswegeMainWindow mainWindow;
    private final JRadioButton radBegehungswegNeuErstellen = new JRadioButton(BegehungswegeModel.Begehungsweg.NEU_ERSTELLEN.toString());
    private final JRadioButton radBegehungswegInstandStellen = new JRadioButton(BegehungswegeModel.Begehungsweg.INSTAND_STELLEN.toString());
    private final JComboBox<BegehungswegeModel.Ausfuehrung> cmbAusfuehrung = new JComboBox<BegehungswegeModel.Ausfuehrung>(BegehungswegeModel.Ausfuehrung.values());
    private final JSpinner txtAnzahlLaufmeter = new JSpinner(new SpinnerNumberModel(50, 1, 10000, 1));
    private final JComboBox<BegehungswegeModel.GelaendeSchwierigkeit> cmbGelaendeschwierigkeit = new JComboBox<BegehungswegeModel.GelaendeSchwierigkeit>(BegehungswegeModel.GelaendeSchwierigkeit.values());

    public BegehungswegePanel(BegehungswegeMainWindow mainWindow) {
        super(Messages.getString("Begehungswege.Titel"));
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtAnzahlLaufmeter, false);
        this.mainWindow = mainWindow;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(new JLabel(Messages.getString("Begehungswege.Begehungsweg")));
        this.initRadioButtons();
        JPanel pnlRadioButtons = new JPanel(new BorderLayout());
        pnlRadioButtons.add((Component)this.radBegehungswegNeuErstellen, "West");
        pnlRadioButtons.add((Component)this.radBegehungswegInstandStellen, "East");
        String msg = Messages.getString("Begehungswege.InfoButtonBegehungswege");
        this.add(Utilities.getPanelWithInfoButton(pnlRadioButtons, msg));
        this.add(new JLabel(Messages.getString("Begehungswege.Ausfuehrung")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbAusfuehrung));
        this.add(new JLabel(Messages.getString("Begehungswege.AnzahlLaufmeter")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtAnzahlLaufmeter));
        this.add(new JLabel(Messages.getString("Begehungswege.Gelaendeschwierigkeit")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbGelaendeschwierigkeit));
        this.cmbAusfuehrung.setSelectedItem((Object)BegehungswegeModel.Ausfuehrung.getDefault());
        this.cmbGelaendeschwierigkeit.setSelectedItem((Object)BegehungswegeModel.GelaendeSchwierigkeit.getDefault());
        this.initListeners();
    }

    private void initRadioButtons() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.radBegehungswegNeuErstellen);
        group.add(this.radBegehungswegInstandStellen);
        this.radBegehungswegNeuErstellen.setHorizontalAlignment(0);
        this.radBegehungswegInstandStellen.setHorizontalAlignment(0);
        this.radBegehungswegNeuErstellen.setSelected(true);
    }

    private void initListeners() {
        this.radBegehungswegNeuErstellen.addItemListener(this.mainWindow.getDefaultItemListener());
        this.radBegehungswegInstandStellen.addItemListener(this.mainWindow.getDefaultItemListener());
        this.cmbAusfuehrung.addActionListener(this.mainWindow.getDefaultActionListener());
        this.txtAnzahlLaufmeter.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.cmbGelaendeschwierigkeit.addActionListener(this.mainWindow.getDefaultActionListener());
    }

    public BegehungswegeModel.Begehungsweg getBegehungsweg() {
        if (this.radBegehungswegNeuErstellen.isSelected()) {
            return BegehungswegeModel.Begehungsweg.NEU_ERSTELLEN;
        }
        return BegehungswegeModel.Begehungsweg.INSTAND_STELLEN;
    }

    public BegehungswegeModel.Ausfuehrung getAusfuehrung() {
        return this.cmbAusfuehrung.getItemAt(this.cmbAusfuehrung.getSelectedIndex());
    }

    public Integer getAnzahlLaufmeter() {
        return (Integer)this.txtAnzahlLaufmeter.getValue();
    }

    public BegehungswegeModel.GelaendeSchwierigkeit getGelaendeschwierigkeit() {
        return this.cmbGelaendeschwierigkeit.getItemAt(this.cmbGelaendeschwierigkeit.getSelectedIndex());
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Begehungswege.Titel") + "\"> ");
        sb.append(this.getXmlEntry(Messages.getString("Begehungswege.Begehungsweg"), (Object)this.getBegehungsweg()));
        sb.append(this.getXmlEntry(Messages.getString("Begehungswege.Ausfuehrung"), (Object)this.getAusfuehrung()));
        sb.append(this.getXmlEntry(Messages.getString("Begehungswege.AnzahlLaufmeter"), this.getAnzahlLaufmeter()));
        sb.append(this.getXmlEntry(Messages.getString("Begehungswege.Gelaendeschwierigkeit"), (Object)this.getGelaendeschwierigkeit()));
        sb.append("</section> ");
        return sb.toString();
    }
}

