/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.CurrencySensitive;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.main.AustrichternMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.AustrichternBestandPanel;
import ch.wsl.fps.juwapfl.model.AustrichternModel;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class AustrichternPersonalMaschinenPanel
extends AbstractInputPanel
implements CurrencySensitive {
    private final AustrichternMainWindow mainWindow;
    private final AustrichternBestandPanel panelBestand;
    private final JLabel lblKostenPersonalProPerson = new JLabel();
    private final JSpinner txtKostenPersonalProPerson = new JSpinner(new SpinnerNumberModel(70, 0, 500, 1));
    private final JLabel lblKostenMaschine = new JLabel();
    private final JSpinner txtKostenMaschine = new JSpinner(new SpinnerNumberModel(14.0, 0.0, 500.0, 1.0));
    private final JLabel lblKostenSichel = new JLabel();
    private final JSpinner txtKostenSichel = new JSpinner(new SpinnerNumberModel(0.6, 0.0, 10.0, 0.05));
    private final JSpinner txtArbeitszeit = new JSpinner(new SpinnerNumberModel(510, 60, 1000, 10));
    private final JSpinner txtPausen = new JSpinner(new SpinnerNumberModel(60, 0, 1000, 10));

    public AustrichternPersonalMaschinenPanel(AustrichternMainWindow mainWindow, AustrichternBestandPanel panelBestand) {
        super(Messages.getString("Austrichtern.PersonalUndMaschinen"));
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtKostenPersonalProPerson, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtKostenMaschine, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtKostenSichel, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtArbeitszeit, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtPausen, false);
        this.txtKostenSichel.setEditor(new JSpinner.NumberEditor(this.txtKostenSichel, "0.00"));
        this.mainWindow = mainWindow;
        this.panelBestand = panelBestand;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(this.lblKostenPersonalProPerson);
        this.add(Utilities.getPanelWithoutInfoButton(this.txtKostenPersonalProPerson));
        this.add(this.lblKostenMaschine);
        this.add(Utilities.getPanelWithoutInfoButton(this.txtKostenMaschine));
        this.add(this.lblKostenSichel);
        String infoButtonText1 = Messages.getString("Austrichtern.InfoButtonSichel");
        this.add(Utilities.getPanelWithInfoButton(this.txtKostenSichel, infoButtonText1));
        this.add(new JLabel(Messages.getString("Common.TaeglicheArbeitszeit")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtArbeitszeit));
        this.add(new JLabel("   " + Messages.getString("Common.DavonBezahlteWegzeitenUndPausen")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtPausen));
        this.updatePausenMaximum();
        this.initListeners();
        mainWindow.registerForCurrencyUpdates(this);
    }

    private void initListeners() {
        this.txtKostenPersonalProPerson.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtKostenMaschine.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtKostenSichel.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtArbeitszeit.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtArbeitszeit.addChangeListener(e -> this.updatePausenMaximum());
        this.txtPausen.addChangeListener(this.mainWindow.getDefaultChangeListener());
    }

    private void updatePausenMaximum() {
        int arbeitszeit = (Integer)this.txtArbeitszeit.getValue();
        int maximum = arbeitszeit - 10;
        ((SpinnerNumberModel)this.txtPausen.getModel()).setMaximum(Integer.valueOf(maximum));
        if ((Integer)this.txtPausen.getValue() > maximum) {
            this.txtPausen.setValue(maximum);
        }
    }

    public void onInputChangedBeforeCalculation() {
        AustrichternModel.MaschinenGeraete maschinenGeraete = this.panelBestand.getMaschinenGeraete();
        if (maschinenGeraete == AustrichternModel.MaschinenGeraete.FREISCHNEIDER_MOTORSAEGE) {
            this.txtKostenMaschine.setEnabled(true);
            this.txtKostenSichel.setEnabled(false);
        } else {
            this.txtKostenMaschine.setEnabled(false);
            this.txtKostenSichel.setEnabled(true);
        }
    }

    public Integer getKostenPersonalProPerson() {
        return (Integer)this.txtKostenPersonalProPerson.getValue();
    }

    public Double getKostenMaschine() {
        return (Double)this.txtKostenMaschine.getValue();
    }

    public Double getKostenSichel() {
        return (Double)this.txtKostenSichel.getValue();
    }

    public double getFaktorWegzeitenUndPausen() {
        int arbeitszeit = (Integer)this.txtArbeitszeit.getValue();
        int pausen = (Integer)this.txtPausen.getValue();
        double faktor = (0.0 + (double)arbeitszeit) / (double)(arbeitszeit - pausen);
        return faktor;
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Common.Personal") + "\"> ");
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Common.Personalkostensatz")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Common.ProStunde") + "]", this.getKostenPersonalProPerson()));
        if (this.panelBestand.getMaschinenGeraete() == AustrichternModel.MaschinenGeraete.FREISCHNEIDER_MOTORSAEGE) {
            sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Common.KostenMaschine")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Austrichtern.proLiterTreibstoff") + "]", this.getKostenMaschine()));
        } else {
            sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Austrichtern.GeraetekostenSichel")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Common.proHektare") + "]", this.getKostenSichel()));
        }
        sb.append(this.getXmlEntry(Messages.getString("Common.TaeglicheArbeitszeit"), this.txtArbeitszeit.getValue()));
        sb.append(this.getXmlEntry("&#160;&#160;" + Messages.getString("Common.DavonBezahlteWegzeitenUndPausen"), this.txtPausen.getValue()));
        sb.append("</section> ");
        return sb.toString();
    }

    @Override
    public void updateCurrency() {
        this.lblKostenPersonalProPerson.setText(String.valueOf(Messages.getString("Common.Personalkostensatz")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Common.ProStunde") + "]");
        this.lblKostenMaschine.setText(String.valueOf(Messages.getString("Common.KostenMaschine")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Austrichtern.proLiterTreibstoff") + "]");
        this.lblKostenSichel.setText(String.valueOf(Messages.getString("Austrichtern.GeraetekostenSichel")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Common.proHektare") + "]");
    }
}

