/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.main.AustrichternMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import ch.wsl.fps.juwapfl.model.AustrichternModel;
import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class AustrichternBestandPanel
extends AbstractInputPanel {
    private final AustrichternMainWindow mainWindow;
    private final JSpinner txtFlaeche_ha = new JSpinner(new SpinnerNumberModel(0.8, 0.1, 10.0, 0.1));
    private final JComboBox<AustrichternModel.MaschinenGeraete> cmbMaschinenGeraete = new JComboBox<AustrichternModel.MaschinenGeraete>(AustrichternModel.MaschinenGeraete.values());
    private final JSpinner txtPflanzabstandInReihen_m = new JSpinner(new SpinnerNumberModel(5, 2, 20, 1));
    private final JSpinner txtPflanzabstandZwischenReihen_m = new JSpinner(new SpinnerNumberModel(5, 2, 20, 1));
    private final JSpinner txtAnzahlPflanzenProHektar = new JSpinner(new SpinnerNumberModel(400, 1, 2500, 1));
    private final JCheckBox chkDirekteingabe = new JCheckBox(Messages.getString("Austrichtern.Direkteingabe"));
    private final JComboBox<AustrichternModel.Verunkrautung> cmbVerunkrautung = new JComboBox<AustrichternModel.Verunkrautung>(AustrichternModel.Verunkrautung.values());
    private final JComboBox<AustrichternModel.Hangneigung> cmbHangneigung = new JComboBox<AustrichternModel.Hangneigung>(AustrichternModel.Hangneigung.values());
    private final JComboBox<AustrichternModel.RueckegassenVorhanden> cmbRueckegassenVorhanden = new JComboBox<AustrichternModel.RueckegassenVorhanden>(AustrichternModel.RueckegassenVorhanden.values());
    private final JComboBox<AustrichternModel.Schutzsystem> cmbSchutzsystem = new JComboBox<AustrichternModel.Schutzsystem>(AustrichternModel.Schutzsystem.values());
    private final JComboBox<AustrichternModel.Temperatur> cmbTemperatur = new JComboBox<AustrichternModel.Temperatur>(AustrichternModel.Temperatur.values());

    public AustrichternBestandPanel(AustrichternMainWindow mainWindow) {
        super(Messages.getString("Austrichtern.Bestand"));
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtFlaeche_ha, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtPflanzabstandInReihen_m, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtPflanzabstandZwischenReihen_m, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtAnzahlPflanzenProHektar, false);
        this.mainWindow = mainWindow;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(new JLabel(Messages.getString("Austrichtern.Flaeche")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtFlaeche_ha));
        this.add(new JLabel(Messages.getString("Austrichtern.MaschinenOderGeraete")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbMaschinenGeraete));
        this.add(new JLabel(Messages.getString("Austrichtern.PflanzabstandInReihen")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtPflanzabstandInReihen_m));
        this.add(new JLabel(Messages.getString("Austrichtern.PflanzabstandZwischenReihen")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtPflanzabstandZwischenReihen_m));
        this.add(new JLabel(Messages.getString("Austrichtern.AnzahlPflanzenProHa")));
        JPanel pnlAnzahlPflanzen = new JPanel(new GridLayout(0, 2, 5, 0));
        pnlAnzahlPflanzen.add(Utilities.getPanelWithoutInfoButton(this.txtAnzahlPflanzenProHektar));
        pnlAnzahlPflanzen.add(this.chkDirekteingabe);
        this.add(pnlAnzahlPflanzen);
        this.add(new JLabel(Messages.getString("Austrichtern.Verunkrautung")));
        String msg = "<html><li><b>" + Messages.getString("Austrichtern.Verunkrautung.schwach") + ":</b> " + Messages.getString("Austrichtern.Verunkrautung.Hinweis.schwach") + "</li>" + "<li><b>" + Messages.getString("Austrichtern.Verunkrautung.mittel") + ":</b> " + Messages.getString("Austrichtern.Verunkrautung.Hinweis.mittel") + "</li>" + "<li><b>" + Messages.getString("Austrichtern.Verunkrautung.stark") + ":</b> " + Messages.getString("Austrichtern.Verunkrautung.Hinweis.stark") + "</li>" + "<li><b>" + Messages.getString("Austrichtern.Verunkrautung.extremStark") + ":</b> " + Messages.getString("Austrichtern.Verunkrautung.Hinweis.extremStark") + "</li>" + "</html>";
        this.add(Utilities.getPanelWithInfoButton(this.cmbVerunkrautung, msg));
        this.add(new JLabel(Messages.getString("Austrichtern.Hangneigung")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbHangneigung));
        this.add(new JLabel(Messages.getString("Austrichtern.RueckegassenVorhanden")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbRueckegassenVorhanden));
        this.add(new JLabel(Messages.getString("Austrichtern.Schutzsystem")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbSchutzsystem));
        this.add(new JLabel(Messages.getString("Austrichtern.Lufttemperatur")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbTemperatur));
        this.cmbMaschinenGeraete.setSelectedItem((Object)AustrichternModel.MaschinenGeraete.getDefault());
        this.cmbVerunkrautung.setSelectedItem((Object)AustrichternModel.Verunkrautung.getDefault());
        this.cmbHangneigung.setSelectedItem((Object)AustrichternModel.Hangneigung.getDefault());
        this.cmbRueckegassenVorhanden.setSelectedItem((Object)AustrichternModel.RueckegassenVorhanden.getDefault());
        this.cmbSchutzsystem.setSelectedItem((Object)AustrichternModel.Schutzsystem.getDefault());
        this.cmbTemperatur.setSelectedItem((Object)AustrichternModel.Temperatur.getDefault());
        this.initListeners();
    }

    private void initListeners() {
        this.txtFlaeche_ha.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.cmbMaschinenGeraete.addActionListener(this.mainWindow.getDefaultActionListener());
        this.txtPflanzabstandInReihen_m.addChangeListener(e -> this.calculateAnzahlPflanzen());
        this.txtPflanzabstandZwischenReihen_m.addChangeListener(e -> this.calculateAnzahlPflanzen());
        this.txtAnzahlPflanzenProHektar.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.chkDirekteingabe.addItemListener(event -> {
            if (this.chkDirekteingabe.isSelected()) {
                this.txtPflanzabstandInReihen_m.setEnabled(false);
                this.txtPflanzabstandZwischenReihen_m.setEnabled(false);
                this.txtAnzahlPflanzenProHektar.setEnabled(true);
            } else {
                this.txtPflanzabstandInReihen_m.setEnabled(true);
                this.txtPflanzabstandZwischenReihen_m.setEnabled(true);
                this.txtAnzahlPflanzenProHektar.setEnabled(false);
            }
        });
        this.chkDirekteingabe.setSelected(true);
        this.chkDirekteingabe.setSelected(false);
        this.cmbVerunkrautung.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbHangneigung.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbRueckegassenVorhanden.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbSchutzsystem.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbTemperatur.addActionListener(this.mainWindow.getDefaultActionListener());
    }

    private void calculateAnzahlPflanzen() {
        if (!this.chkDirekteingabe.isSelected()) {
            Integer a = (Integer)this.txtPflanzabstandInReihen_m.getValue();
            Integer b = (Integer)this.txtPflanzabstandZwischenReihen_m.getValue();
            if (a != null && b != null) {
                this.txtAnzahlPflanzenProHektar.setValue((int)Math.round(10000.0 / (double)(a * b)));
            }
        }
    }

    public Double getFlaeche_ha() {
        return (Double)this.txtFlaeche_ha.getValue();
    }

    public AustrichternModel.MaschinenGeraete getMaschinenGeraete() {
        return this.cmbMaschinenGeraete.getItemAt(this.cmbMaschinenGeraete.getSelectedIndex());
    }

    private Integer getPflanzabstandInReihen_m() {
        return (Integer)this.txtPflanzabstandInReihen_m.getValue();
    }

    private Integer getPflanzabstandZwischenReihen_m() {
        return (Integer)this.txtPflanzabstandZwischenReihen_m.getValue();
    }

    public Integer getAnzahlPflanzenProHektar() {
        return (Integer)this.txtAnzahlPflanzenProHektar.getValue();
    }

    public AustrichternModel.Verunkrautung getVerunkrautung() {
        return this.cmbVerunkrautung.getItemAt(this.cmbVerunkrautung.getSelectedIndex());
    }

    public AustrichternModel.Hangneigung getHangneigung() {
        return this.cmbHangneigung.getItemAt(this.cmbHangneigung.getSelectedIndex());
    }

    public AustrichternModel.RueckegassenVorhanden getRueckegassenVorhanden() {
        return this.cmbRueckegassenVorhanden.getItemAt(this.cmbRueckegassenVorhanden.getSelectedIndex());
    }

    public AustrichternModel.Schutzsystem getSchutzsystem() {
        return this.cmbSchutzsystem.getItemAt(this.cmbSchutzsystem.getSelectedIndex());
    }

    public AustrichternModel.Temperatur getTemperatur() {
        return this.cmbTemperatur.getItemAt(this.cmbTemperatur.getSelectedIndex());
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Austrichtern.Bestand") + "\"> ");
        sb.append(this.getXmlEntry(Messages.getString("Austrichtern.Flaeche"), this.getFlaeche_ha()));
        sb.append(this.getXmlEntry(Messages.getString("Austrichtern.MaschinenOderGeraete"), (Object)this.getMaschinenGeraete()));
        if (!this.chkDirekteingabe.isSelected()) {
            sb.append(this.getXmlEntry(Messages.getString("Austrichtern.PflanzabstandInReihen"), this.getPflanzabstandInReihen_m()));
            sb.append(this.getXmlEntry(Messages.getString("Austrichtern.PflanzabstandZwischenReihen"), this.getPflanzabstandZwischenReihen_m()));
        }
        sb.append(this.getXmlEntry(Messages.getString("Austrichtern.AnzahlPflanzenProHa"), this.getAnzahlPflanzenProHektar()));
        sb.append(this.getXmlEntry(Messages.getString("Austrichtern.Verunkrautung"), (Object)this.getVerunkrautung()));
        sb.append(this.getXmlEntry(Messages.getString("Austrichtern.Hangneigung"), (Object)this.getHangneigung()));
        sb.append(this.getXmlEntry(Messages.getString("Austrichtern.RueckegassenVorhanden"), (Object)this.getRueckegassenVorhanden()));
        sb.append(this.getXmlEntry(Messages.getString("Austrichtern.Schutzsystem"), (Object)this.getSchutzsystem()));
        sb.append(this.getXmlEntry(Messages.getString("Austrichtern.Lufttemperatur"), (Object)this.getTemperatur()));
        sb.append("</section> ");
        return sb.toString();
    }
}

