/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.ergebnis;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.main.RueckegassenMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.ergebnis.AbstractErgebnisPanel;
import ch.wsl.fps.juwapfl.model.RueckegassenErgebnis;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class RueckegassenErgebnisPanel
extends AbstractErgebnisPanel<RueckegassenMainWindow, RueckegassenErgebnis> {
    private final JTextField txtZeitaufwandHauptpersonProHektar = RueckegassenErgebnisPanel.getNewLockedTextField();
    private final JTextField txtZeitaufwandHauptpersonGesamtflaeche = RueckegassenErgebnisPanel.getNewLockedTextField();
    private final JTextField txtZeitaufwandHilfskraftProHektar = RueckegassenErgebnisPanel.getNewLockedTextField();
    private final JTextField txtZeitaufwandHilfskraftGesamtflaeche = RueckegassenErgebnisPanel.getNewLockedTextField();
    private final JTextField txtKostenHauptpersonProHektar = RueckegassenErgebnisPanel.getNewLockedTextField();
    private final JTextField txtKostenHauptpersonGesamtflaeche = RueckegassenErgebnisPanel.getNewLockedTextField();
    private final JTextField txtKostenHilfskraftProHektar = RueckegassenErgebnisPanel.getNewLockedTextField();
    private final JTextField txtKostenHilfskraftGesamtflaeche = RueckegassenErgebnisPanel.getNewLockedTextField();
    private final JTextField txtKostenMaterialProHektar = RueckegassenErgebnisPanel.getNewLockedTextField();
    private final JTextField txtKostenMaterialGesamtflaeche = RueckegassenErgebnisPanel.getNewLockedTextField();
    private final JTextField txtKostenGesamtProHektar = RueckegassenErgebnisPanel.getNewLockedTextField();
    private final JTextField txtKostenGesamtGesamtflaeche = RueckegassenErgebnisPanel.getNewLockedTextFieldBold();

    public RueckegassenErgebnisPanel(RueckegassenMainWindow mainWindow) {
        super(mainWindow);
        AbstractMainWindow.initTitledBorder(this, Messages.getString("Common.TitelErgebnis"));
        this.setBackground(AbstractErgebnisPanel.ERGEBNIS_PANEL_BACKGROUND_COLOR);
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(), RueckegassenErgebnisPanel.getGBC(0, 0));
        this.add((Component)new JLabel("<html><center>" + Messages.getString("Common.PersonalzeitenWPPH") + "</center></html>", 0), RueckegassenErgebnisPanel.getGBC(1, 0, 2));
        this.add((Component)new JLabel(), RueckegassenErgebnisPanel.getGBC(3, 0));
        this.add((Component)this.lblKostenTitle, RueckegassenErgebnisPanel.getGBC(4, 0, 2));
        int row = 1;
        int col = 0;
        this.add((Component)new JLabel(), RueckegassenErgebnisPanel.getGBC(col++, row));
        this.add((Component)new JLabel("<html><center>" + Messages.getString("Rueckegassen.proHektare") + "</center></html>", 0), RueckegassenErgebnisPanel.getGBC(col++, row));
        this.add((Component)new JLabel("<html><center>" + Messages.getString("Rueckegassen.proGesamtflaeche") + "</center></html>", 0), RueckegassenErgebnisPanel.getGBC(col++, row));
        int n = ++col;
        this.add((Component)new JLabel("<html><center>" + Messages.getString("Rueckegassen.proHektare") + "</center></html>", 0), RueckegassenErgebnisPanel.getGBC(n, row));
        int n2 = ++col;
        ++col;
        this.add((Component)new JLabel("<html><center>" + Messages.getString("Rueckegassen.proGesamtflaeche") + "</center></html>", 0), RueckegassenErgebnisPanel.getGBC(n2, row));
        col = 0;
        this.add((Component)new JLabel(String.valueOf(Messages.getString("Rueckegassen.Hauptperson")) + "  ", 4), RueckegassenErgebnisPanel.getGBC(col++, ++row));
        this.add((Component)this.txtZeitaufwandHauptpersonProHektar, RueckegassenErgebnisPanel.getGBC(col++, row));
        this.add((Component)this.txtZeitaufwandHauptpersonGesamtflaeche, RueckegassenErgebnisPanel.getGBC(col++, row));
        int n3 = ++col;
        this.add((Component)this.txtKostenHauptpersonProHektar, RueckegassenErgebnisPanel.getGBC(n3, row));
        int n4 = ++col;
        ++col;
        this.add((Component)this.txtKostenHauptpersonGesamtflaeche, RueckegassenErgebnisPanel.getGBC(n4, row));
        col = 0;
        this.add((Component)new JLabel(String.valueOf(Messages.getString("Rueckegassen.Hilfskraft")) + "  ", 4), RueckegassenErgebnisPanel.getGBC(col++, ++row));
        this.add((Component)this.txtZeitaufwandHilfskraftProHektar, RueckegassenErgebnisPanel.getGBC(col++, row));
        this.add((Component)this.txtZeitaufwandHilfskraftGesamtflaeche, RueckegassenErgebnisPanel.getGBC(col++, row));
        int n5 = ++col;
        this.add((Component)this.txtKostenHilfskraftProHektar, RueckegassenErgebnisPanel.getGBC(n5, row));
        int n6 = ++col;
        ++col;
        this.add((Component)this.txtKostenHilfskraftGesamtflaeche, RueckegassenErgebnisPanel.getGBC(n6, row));
        col = 0;
        this.add((Component)new JLabel(String.valueOf(Messages.getString("Common.TitelMaterial")) + "  ", 4), RueckegassenErgebnisPanel.getGBC(col++, ++row));
        this.add((Component)RueckegassenErgebnisPanel.getNewLockedTextField(true), RueckegassenErgebnisPanel.getGBC(col++, row));
        this.add((Component)RueckegassenErgebnisPanel.getNewLockedTextField(true), RueckegassenErgebnisPanel.getGBC(col++, row));
        int n7 = ++col;
        this.add((Component)this.txtKostenMaterialProHektar, RueckegassenErgebnisPanel.getGBC(n7, row));
        int n8 = ++col;
        ++col;
        this.add((Component)this.txtKostenMaterialGesamtflaeche, RueckegassenErgebnisPanel.getGBC(n8, row));
        col = 0;
        this.add((Component)this.getLabelGesamt(), RueckegassenErgebnisPanel.getGBC(col++, ++row));
        this.add((Component)new JLabel(), RueckegassenErgebnisPanel.getGBC(col++, row));
        this.add((Component)new JLabel(), RueckegassenErgebnisPanel.getGBC(col++, row));
        int n9 = ++col;
        this.add((Component)this.txtKostenGesamtProHektar, RueckegassenErgebnisPanel.getGBC(n9, row));
        int n10 = ++col;
        ++col;
        this.add((Component)this.txtKostenGesamtGesamtflaeche, RueckegassenErgebnisPanel.getGBC(n10, row));
        mainWindow.registerForCurrencyUpdates(this);
    }

    @Override
    protected JLabel getLabelGesamt() {
        String infoButtonText = Utilities.normalizeTooltipText(Messages.getString("Rueckegassen.InfoButtonRundung"));
        JLabel lblGesamt = Utilities.getInfoButtonBlue(infoButtonText);
        lblGesamt.setText(String.valueOf(Messages.getString("Common.ErgebnisGesamt")) + "  ");
        lblGesamt.setHorizontalAlignment(4);
        lblGesamt.setHorizontalTextPosition(4);
        return lblGesamt;
    }

    @Override
    public void setErgebnis(RueckegassenErgebnis ergebnis) {
        this.txtZeitaufwandHauptpersonProHektar.setText(RueckegassenErgebnisPanel.formatMinutes(ergebnis.getZeitaufwandHauptperson_minProHektar()));
        this.txtZeitaufwandHauptpersonGesamtflaeche.setText(RueckegassenErgebnisPanel.formatMinutes(ergebnis.getZeitaufwandHauptperson_minGesamtflaeche()));
        this.txtZeitaufwandHilfskraftProHektar.setText(RueckegassenErgebnisPanel.formatMinutes(ergebnis.getZeitaufwandHilfskraft_minProHektar()));
        this.txtZeitaufwandHilfskraftGesamtflaeche.setText(RueckegassenErgebnisPanel.formatMinutes(ergebnis.getZeitaufwandHilfskraft_minGesamtflaeche()));
        this.txtKostenHauptpersonProHektar.setText(RueckegassenErgebnisPanel.format(ergebnis.getKostenHauptperson_proHektar()));
        this.txtKostenHauptpersonGesamtflaeche.setText(RueckegassenErgebnisPanel.format(ergebnis.getKostenHauptperson_Gesamtflaeche()));
        this.txtKostenHilfskraftProHektar.setText(RueckegassenErgebnisPanel.format(ergebnis.getKostenHilfskraft_proHektar()));
        this.txtKostenHilfskraftGesamtflaeche.setText(RueckegassenErgebnisPanel.format(ergebnis.getKostenHilfskraft_Gesamtflaeche()));
        this.txtKostenMaterialProHektar.setText(RueckegassenErgebnisPanel.format(ergebnis.getKostenMaterial_proHektar()));
        this.txtKostenMaterialGesamtflaeche.setText(RueckegassenErgebnisPanel.format(ergebnis.getKostenMaterial_Gesamtflaeche()));
        this.txtKostenGesamtProHektar.setText(RueckegassenErgebnisPanel.format(ergebnis.getKostenGesamt_proHektar()));
        this.txtKostenGesamtGesamtflaeche.setText(RueckegassenErgebnisPanel.format(ergebnis.getKostenGesamt_Gesamtflaeche()));
    }

    @Override
    public String[][] getErgebnisAsStringArray() {
        String[][] strings = new String[][]{{Messages.getString("Rueckegassen.Hauptperson"), this.txtZeitaufwandHauptpersonProHektar.getText(), this.txtZeitaufwandHauptpersonGesamtflaeche.getText(), this.txtKostenHauptpersonProHektar.getText(), this.txtKostenHauptpersonGesamtflaeche.getText()}, {Messages.getString("Rueckegassen.Hilfskraft"), this.txtZeitaufwandHilfskraftProHektar.getText(), this.txtZeitaufwandHilfskraftGesamtflaeche.getText(), this.txtKostenHilfskraftProHektar.getText(), this.txtKostenHilfskraftGesamtflaeche.getText()}, {Messages.getString("Common.TitelMaterial"), "-", "-", this.txtKostenMaterialProHektar.getText(), this.txtKostenMaterialGesamtflaeche.getText()}, {Messages.getString("Common.ErgebnisGesamt"), "", "", this.txtKostenGesamtProHektar.getText(), "<b>" + this.txtKostenGesamtGesamtflaeche.getText() + "</b>"}};
        return strings;
    }
}

