/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.main;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.ergebnis.SchneegleitenErgebnisPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.SchneegleitenAbbauPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.SchneegleitenErstellenPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.SchneegleitenPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.SchneegleitenUnterhaltPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.SimplePersonalPanel;
import ch.wsl.fps.juwapfl.model.SchneegleitenErgebnis;
import ch.wsl.fps.juwapfl.model.SchneegleitenModel;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class SchneegleitenMainWindow
extends AbstractMainWindow {
    private SchneegleitenPanel panelSchneegleiten;
    private SchneegleitenErstellenPanel panelErstellen;
    private SchneegleitenUnterhaltPanel panelUnterhalt;
    private SchneegleitenAbbauPanel panelAbbau;
    private SimplePersonalPanel panelPersonal;
    private SchneegleitenErgebnisPanel panelErgebnis;

    public static void main(String[] args) {
        AbstractMainWindow.main(args, () -> {
            SchneegleitenMainWindow schneegleitenMainWindow = new SchneegleitenMainWindow();
        });
    }

    public SchneegleitenMainWindow() {
        this.setTitle(Messages.getString("Schneegleiten.FensterTitel"));
        this.setSize(this.getWindowSize(730), this.getWindowSize(800));
        this.init();
    }

    @Override
    protected String[] getDokuPdfFileNames() {
        String[] stringArray = new String[2];
        stringArray[0] = "DokuSchneegleiten.pdf";
        return stringArray;
    }

    @Override
    protected JPanel createPanelInput() {
        JPanel pnlInput = new JPanel();
        SchneegleitenMainWindow.initTitledBorder(pnlInput, Messages.getString("Common.TitelEingaben"));
        pnlInput.setLayout(new BoxLayout(pnlInput, 3));
        pnlInput.add(Box.createVerticalStrut(5));
        this.panelSchneegleiten = new SchneegleitenPanel(this);
        pnlInput.add(this.panelSchneegleiten);
        pnlInput.add(Box.createVerticalStrut(10));
        this.panelErstellen = new SchneegleitenErstellenPanel(this);
        pnlInput.add(this.panelErstellen);
        pnlInput.add(Box.createVerticalStrut(10));
        this.panelUnterhalt = new SchneegleitenUnterhaltPanel(this);
        pnlInput.add(this.panelUnterhalt);
        pnlInput.add(Box.createVerticalStrut(10));
        this.panelAbbau = new SchneegleitenAbbauPanel(this);
        pnlInput.add(this.panelAbbau);
        pnlInput.add(Box.createVerticalStrut(10));
        this.panelPersonal = new SimplePersonalPanel(this, false);
        pnlInput.add(this.panelPersonal);
        pnlInput.add(Box.createVerticalGlue());
        pnlInput.add(Box.createRigidArea(new Dimension(1, 220)));
        return pnlInput;
    }

    @Override
    protected JPanel createPanelOutput() {
        this.panelErgebnis = new SchneegleitenErgebnisPanel(this);
        return this.panelErgebnis;
    }

    @Override
    protected String getModelAsXmlString() {
        String xmlModelName = "<modellname>" + Messages.getString("Schneegleiten.Modellname") + "</modellname>";
        String xmlInfo = this.getMetaInformationAsXmlString();
        String xmlPdfTitles = this.getPdfTitlesAsXmlString();
        String xmlEingaben = "<eingaben>";
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelSchneegleiten.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelErstellen.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelUnterhalt.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelAbbau.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelPersonal.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + "</eingaben>";
        String xmlErgebnis = SchneegleitenMainWindow.getErgebnisAsXmlString(this.panelErgebnis);
        String result = String.valueOf(xmlModelName) + xmlInfo + xmlPdfTitles + xmlEingaben + xmlErgebnis;
        return result;
    }

    @Override
    protected String getXsltFilePath() {
        return "data/kalkulation2fo-schneegleiten.xsl";
    }

    @Override
    protected Map<String, String> getAdditionalPdfTitles() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("aufbau", Messages.getString("Schneegleiten.Pdf.ErgebnisAufbau"));
        result.put("unterhalt", Messages.getString("Schneegleiten.Pdf.ErgebnisUnterhalt"));
        result.put("abbau", Messages.getString("Schneegleiten.Pdf.ErgebnisAbbau"));
        result.put("gesamt", Messages.getString("Schneegleiten.Pdf.ErgebnisGesamt"));
        return result;
    }

    @Override
    protected void onInputChangedBeforeCalculation() {
        this.panelSchneegleiten.onInputChangedBeforeCalculation();
        this.panelErstellen.onInputChangedBeforeCalculation(this.panelSchneegleiten.getMassnahme());
        this.panelUnterhalt.onInputChangedBeforeCalculation(this.panelSchneegleiten.getMassnahme());
        boolean isBermen = this.panelSchneegleiten.getMassnahme() == SchneegleitenModel.Massnahme.BERMEN;
        this.panelAbbau.setEnabled(!isBermen);
        if (isBermen) {
            this.panelAbbau.setAllFieldsToZero();
        }
    }

    @Override
    protected void displayErgebnis() {
        SchneegleitenModel model = new SchneegleitenModel();
        model.setMassnahme(this.panelSchneegleiten.getMassnahme());
        model.setAnzahlBauten(this.panelSchneegleiten.getAnzahlBauten());
        model.setGelaendeverhaeltnisse(this.panelSchneegleiten.getGelaendeverhaeltnisse());
        model.setErstellenPersonalzeit_minProEinheit(this.panelErstellen.getPersonalzeit_minProEinheit());
        model.setErstellenMaterialkosten_ChfProEinheit(this.panelErstellen.getMaterialkosten_ChfProEinheit());
        model.setErstellenMaschinenkosten_ChfProEinheit(this.panelErstellen.getMaschinenkosten_ChfProEinheit());
        model.setErstellenTransportkosten_ChfProEinheit(this.panelErstellen.getTransportkosten_ChfProEinheit());
        model.setUnterhaltPersonalzeit_minProEinheit(this.panelUnterhalt.getPersonalzeit_minProEinheit());
        model.setUnterhaltFahrzeugkosten_ChfProEinheit(this.panelUnterhalt.getFahrzeugkosten_ChfProEinheit());
        model.setUnterhaltMaterialkosten_ChfProEinheit(this.panelUnterhalt.getMaterialkosten_ChfProEinheit());
        model.setAbbauPersonalzeit_minProEinheit(this.panelAbbau.getPersonalzeit_minProEinheit());
        model.setAbbauFahrzeugkosten_ChfProEinheit(this.panelAbbau.getFahrzeugkosten_ChfProEinheit());
        model.setAbbauEntsorgungsgebuehren_ChfProEinheit(this.panelAbbau.getEntsorgungsgebuehren_ChfProEinheit());
        model.setKostenPersonalProPerson(this.panelPersonal.getKostenPersonalProPerson_proH());
        model.setFaktorWegzeitenUndPausen(this.panelPersonal.getFaktorWegzeitenUndPausen());
        SchneegleitenErgebnis ergebnis = model.getErgebnis();
        this.panelErgebnis.setErgebnis(ergebnis);
    }
}

