/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.main;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.JFreeChartPreloader;
import ch.wsl.fps.juwapfl.gui.JuWaPflExceptionHandler;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.main.AustrichternMainWindow;
import ch.wsl.fps.juwapfl.gui.main.BegehungswegeMainWindow;
import ch.wsl.fps.juwapfl.gui.main.PflanzungMainWindow;
import ch.wsl.fps.juwapfl.gui.main.RueckegassenMainWindow;
import ch.wsl.fps.juwapfl.gui.main.SchneegleitenMainWindow;
import ch.wsl.fps.juwapfl.gui.main.WertastungMainWindow;
import ch.wsl.fps.juwapfl.gui.main.WildschutzMainWindow;
import ch.wsl.fps.juwapfl.gui.main.ZBaumDurchforstungMainWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.OverlayLayout;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JuWaPflMainWindow
extends JFrame {
    private static final String betaSuffix = " <font size=4 color=red>BETA</font>";
    private static final boolean isBeta = false;
    private static final String versionNr = "1.3";
    private static final LocalDate versionDate = LocalDate.of(2024, Month.AUGUST, 27);
    private static Locale locale = new Locale("de");
    private JTree tree = this.initJTree();
    private JLabel lblWait;

    static {
        JuWaPflMainWindow.setAllLocales(locale);
    }

    public static void main(String[] args) {
        JFreeChartPreloader.preload();
        AbstractMainWindow.main(args, () -> {
            JuWaPflMainWindow juWaPflMainWindow = new JuWaPflMainWindow();
        });
    }

    public JuWaPflMainWindow() {
        this.setSize((int)(380.0 * Math.pow(AbstractMainWindow.SIZE, 0.6) * (double)AbstractMainWindow.WIDTH_FACTOR), (int)(340.0 * Math.pow(AbstractMainWindow.SIZE, 0.6)));
        this.setMinimumSize(new Dimension(350, 200));
        this.setLocationByPlatform(true);
        this.setTitle("JuWaPfl");
        this.setDefaultCloseOperation(3);
        this.createMenu();
        this.initContent();
        this.setIconImage(JuWaPflMainWindow.getWslLogo().getImage());
        this.setVisible(true);
    }

    private void createMenu() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.setBorderPainted(false);
        this.setJMenuBar(menuBar);
        JMenu menuFile = new JMenu(Messages.getString("Common.MenuDatei"));
        menuBar.add(menuFile);
        JMenu menuLanguage = new JMenu(Messages.getString("Common.MenuSprache"));
        menuBar.add(menuLanguage);
        JMenu menuKontakt = new JMenu(Messages.getString("Common.MenuKontakt"));
        menuBar.add(menuKontakt);
        JMenu menuHelp = new JMenu(Messages.getString("Common.MenuInfo"));
        menuBar.add(menuHelp);
        menuFile.addSeparator();
        AbstractAction aMenuClose = new AbstractAction(Messages.getString("Common.MenuBeenden")){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        };
        menuFile.add(aMenuClose);
        ButtonGroup btnGroupLang = new ButtonGroup();
        ArrayList<Locale> listLanguages = new ArrayList<Locale>();
        listLanguages.add(new Locale("de"));
        listLanguages.add(new Locale("fr"));
        listLanguages.add(new Locale("it"));
        listLanguages.add(new Locale("en"));
        for (final Locale lang : listLanguages) {
            AbstractAction aMenuLanguageX = new AbstractAction(lang.toString()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JuWaPflMainWindow.this.changeLanguage(lang);
                }
            };
            JRadioButtonMenuItem menuLanguageX = new JRadioButtonMenuItem();
            menuLanguageX.setAction(aMenuLanguageX);
            menuLanguageX.setSelected(lang.equals(locale));
            menuLanguageX.setText(lang.getDisplayLanguage(locale));
            menuLanguageX.setName(lang.getLanguage());
            menuLanguage.add(menuLanguageX);
            btnGroupLang.add(menuLanguageX);
        }
        AbstractAction aMenuKontakt = new AbstractAction(Messages.getString("Common.MenuKontakt")){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringBuilder sb = new StringBuilder();
                sb.append("<html>");
                sb.append(String.valueOf(Messages.getString("Common.EidgForschungsanstaltWSL")) + "<br>");
                sb.append("Z\u00fcrcherstrasse 111<br>");
                sb.append("CH-8903 Birmensdorf<br>");
                sb.append("<br>");
                sb.append("<b>" + Messages.getString("Common.UeberschriftKontakt") + "</b><br>");
                sb.append("Janine Schweier / janine.schweier@wsl.ch / +41 44 739 24 78<br>");
                sb.append("<br>");
                sb.append("<b>" + Messages.getString("Common.UeberschriftSoftwareentwicklung") + "</b><br>");
                sb.append("\tStefan Holm / stefan.holm@wsl.ch / +41 44 739 22 63<br>");
                sb.append("</html>");
                JOptionPane.showMessageDialog(JuWaPflMainWindow.this, sb.toString(), Messages.getString("Common.MenuKontakt"), 1);
            }
        };
        menuKontakt.add(aMenuKontakt);
        AbstractAction aMenuInfo = new AbstractAction(Messages.getString("Common.MenuInfo")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int fontSize = (double)AbstractMainWindow.SIZE > 1.3 ? 6 : 5;
                StringBuilder sb1 = new StringBuilder();
                sb1.append("<html>");
                sb1.append("<b><font size=" + fontSize + " color=#006666>JuWaPfl v" + JuWaPflMainWindow.versionNr + " / " + JuWaPflMainWindow.this.getJuWaPflDate() + "</font></b><br>");
                sb1.append("<br>");
                sb1.append("<b>" + Messages.getString("Common.UeberschriftBereitgestelltDurch") + "</b><br>");
                sb1.append(String.valueOf(Messages.getString("Common.EidgForschungsanstaltWSL")) + "<br>");
                sb1.append("Z\u00fcrcherstrasse 111<br>");
                sb1.append("CH-8903 Birmensdorf<br>");
                sb1.append("<br>");
                sb1.append("<b>" + Messages.getString("Common.UeberschriftModelle") + "</b><br>");
                sb1.append("Janine Schweier, Marc Werder, Fritz Frutig, Renato Lemm, Peter Ammann, Oliver Thees, Anton B\u00fcrgi<br>");
                sb1.append("<br>");
                sb1.append("<b>" + Messages.getString("Common.UeberschriftSoftwareentwicklung") + "</b><br>");
                sb1.append("\tStefan Holm<br>");
                sb1.append("<br>");
                sb1.append("<b>" + Messages.getString("Common.UeberschriftUebersetzungen") + "</b><br>");
                sb1.append("\tFritz Frutig, Fran\u00e7ois Fahrni, Janine Schweier, Fabrizio Cioldi<br>");
                sb1.append("<br>");
                sb1.append("<b>" + Messages.getString("Common.UeberschriftZitierung") + "</b><br>");
                sb1.append("\t- " + Messages.getString("Common.EidgForschungsanstaltWSL") + ", " + versionDate.getYear() + ": " + Messages.getString("Common.Zitierung") + ", " + Messages.getString("Common.Version") + " " + JuWaPflMainWindow.versionNr + "<br>");
                sb1.append("</html>");
                JLabel label1 = new JLabel(sb1.toString());
                StringBuilder sb2 = new StringBuilder();
                sb2.append("<html>\t- <u style=\"color:blue;\">Holm, S., Werder, M., Thees, O., Lemm, R., & Schweier, J. (2023). JuWaPfl: A decision support tool </u><br>&nbsp;&nbsp;&nbsp;<u style=\"color:blue;\">to estimate times and costs of processes related to young-forest maintenance. SoftwareX, 24, 101581.</u><br><br>");
                sb2.append("</html>");
                JLabel label2 = new JLabel(sb2.toString());
                label2.setCursor(Cursor.getPredefinedCursor(12));
                label2.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        Desktop desktop;
                        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                            try {
                                URI uri = new URI("https://www.sciencedirect.com/science/article/pii/S2352711023002777");
                                desktop.browse(uri);
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                });
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 1));
                panel.add(label1);
                panel.add(label2);
                JOptionPane.showMessageDialog(JuWaPflMainWindow.this, panel, Messages.getString("Common.MenuInfo"), 1);
            }
        };
        menuHelp.add(aMenuInfo);
    }

    private void changeLanguage(Locale locale) {
        if (!locale.equals(JuWaPflMainWindow.locale)) {
            JuWaPflMainWindow.setAllLocales(locale);
            JuWaPflMainWindow mainWindow = new JuWaPflMainWindow();
            mainWindow.setLocation(this.getLocation());
            this.dispose();
        }
    }

    private static void setAllLocales(Locale newLocale) {
        locale = newLocale;
        JComponent.setDefaultLocale(locale);
        Messages.setLocale(locale);
    }

    private void initContent() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.insets = new Insets(10, 10, 10, 10);
        ImageIcon wslLogo = JuWaPflMainWindow.getWslLogo();
        int fontSize = (double)AbstractMainWindow.SIZE > 1.3 ? 6 : 5;
        String infoText = "<html><font size=" + fontSize + " color=#006666><b>" + Messages.getString("Common.TitelJungwaldpflege") + "<font size=0><br><br></font>" + Messages.getString("Common.Version") + " " + versionNr + " / " + this.getJuWaPflDate() + "</b></font></html>";
        JLabel lblWslInfo = new JLabel(infoText, wslLogo, 2);
        lblWslInfo.setIconTextGap(12);
        this.getContentPane().add((Component)lblWslInfo, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 100.0;
        c.weighty = 100.0;
        JScrollPane treeView = new JScrollPane(this.tree);
        this.tree.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.lblWait = new JLabel(this.getWaitImage());
        this.lblWait.setAlignmentX(0.5f);
        this.lblWait.setAlignmentY(0.5f);
        this.lblWait.setVisible(false);
        JPanel overlayPanel = new JPanel();
        overlayPanel.setLayout(new OverlayLayout(overlayPanel));
        overlayPanel.add(this.lblWait);
        overlayPanel.add(treeView);
        this.getContentPane().add((Component)overlayPanel, c);
    }

    private JTree initJTree() {
        final JTree tree = new JTree(this.getRootNode());
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.expandRow(2);
        tree.expandRow(0);
        tree.setCellRenderer(new DefaultTreeCellRenderer(){
            private final JPanel panel = new JPanel(new BorderLayout());
            {
                this.panel.setOpaque(false);
                this.panel.add((Component)this, "West");
                this.setBackgroundSelectionColor(null);
                this.setTextSelectionColor(null);
                this.setBorderSelectionColor(Color.LIGHT_GRAY);
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                label.setFont(tree.getFont());
                this.panel.removeAll();
                this.panel.add((Component)this, "West");
                this.panel.setToolTipText(null);
                return this.panel;
            }
        });
        tree.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int y;
                if (!tree.isEnabled()) {
                    return;
                }
                int x = (int)e.getPoint().getX();
                TreePath path = tree.getPathForLocation(x, y = (int)e.getPoint().getY());
                if (path != null && path.getLastPathComponent() instanceof ApplicationTreeNode) {
                    tree.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    tree.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int y;
                int x;
                TreePath path;
                if (tree.isEnabled() && (path = tree.getPathForLocation(x = (int)e.getPoint().getX(), y = (int)e.getPoint().getY())) != null && path.getLastPathComponent() instanceof ApplicationTreeNode) {
                    ApplicationTreeNode selectedNode = (ApplicationTreeNode)path.getLastPathComponent();
                    selectedNode.run();
                }
            }
        });
        tree.setFont(tree.getFont().deriveFont((float)tree.getFont().getSize() + 1.0f));
        tree.setRowHeight(20);
        ToolTipManager.sharedInstance().registerComponent(tree);
        return tree;
    }

    private TreeNode getRootNode() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("JuWaPFL");
        rootNode.add(new ApplicationTreeNode(WertastungMainWindow.class, Messages.getString("Common.TitelWertastung")));
        rootNode.add(new ApplicationTreeNode(ZBaumDurchforstungMainWindow.class, Messages.getString("Common.TitelZBaumDurchforstung")));
        rootNode.add(new ApplicationTreeNode(AustrichternMainWindow.class, Messages.getString("Common.TitelAustrichtern")));
        rootNode.add(new ApplicationTreeNode(WildschutzMainWindow.class, Messages.getString("Common.TitelWildschutz")));
        rootNode.add(new ApplicationTreeNode(SchneegleitenMainWindow.class, Messages.getString("Common.TitelSchneegleiten")));
        rootNode.add(new ApplicationTreeNode(BegehungswegeMainWindow.class, Messages.getString("Common.TitelBegehungswege")));
        rootNode.add(new ApplicationTreeNode(PflanzungMainWindow.class, Messages.getString("Common.TitelPflanzung")));
        rootNode.add(new ApplicationTreeNode(RueckegassenMainWindow.class, Messages.getString("Common.TitelRueckegassen")));
        return rootNode;
    }

    private ImageIcon getWaitImage() {
        return JuWaPflMainWindow.getImageIcon("data/loadinganimation.gif");
    }

    public static ImageIcon getWslLogo() {
        return JuWaPflMainWindow.getImageIcon("data/WSL64.png");
    }

    private static ImageIcon getImageIcon(String filePath) {
        URL imgURL = JuWaPflMainWindow.class.getClassLoader().getResource(filePath);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        return new ImageIcon(filePath);
    }

    private String getJuWaPflDate() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMMM yyyy", locale);
        String juwapflDate = formatter.format(versionDate);
        return juwapflDate;
    }

    public static void setJuWaPflLocale(Locale locale) {
        JuWaPflMainWindow.setAllLocales(locale);
    }

    private class ApplicationTreeNode
    extends DefaultMutableTreeNode {
        private static final boolean labelAsHtmlLink = true;
        private final Class<? extends AbstractMainWindow> clazz;
        private final String label;

        public ApplicationTreeNode(Class<? extends AbstractMainWindow> clazz, String label) {
            this.clazz = clazz;
            this.label = label;
        }

        public void run() {
            JuWaPflMainWindow.this.lblWait.setVisible(true);
            JuWaPflMainWindow.this.tree.setEnabled(false);
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                public Void doInBackground() {
                    try {
                        if (WildschutzMainWindow.class == ApplicationTreeNode.this.clazz && !JFreeChartPreloader.hasFinished()) {
                            System.out.println(LocalTime.now() + ": waiting for JFreeChartPreloader to finish...");
                            while (!JFreeChartPreloader.hasFinished()) {
                                Thread.sleep(100L);
                            }
                            System.out.println(LocalTime.now() + ": JFreeChartPreloader finished");
                        }
                        Constructor constructor = ApplicationTreeNode.this.clazz.getConstructor(new Class[0]);
                        constructor.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        JuWaPflExceptionHandler.handle(e);
                    }
                    return null;
                }

                @Override
                public void done() {
                    JuWaPflMainWindow.this.lblWait.setVisible(false);
                    JuWaPflMainWindow.this.tree.setEnabled(true);
                }
            };
            worker.execute();
        }

        @Override
        public String toString() {
            if (JuWaPflMainWindow.this.lblWait != null && JuWaPflMainWindow.this.lblWait.isVisible()) {
                return this.label;
            }
            return "<html><a href=\"\"><b>" + this.label + "</b></a></html>";
        }
    }
}

