/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.main;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.ergebnis.BegehungswegeErgebnisPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.BegehungswegePanel;
import ch.wsl.fps.juwapfl.gui.panel.input.BegehungswegePersonalPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.BegehungswegeZeitenPanel;
import ch.wsl.fps.juwapfl.model.BegehungswegeErgebnis;
import ch.wsl.fps.juwapfl.model.BegehungswegeModel;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class BegehungswegeMainWindow
extends AbstractMainWindow {
    private BegehungswegePanel panelBegehungswege;
    private BegehungswegeZeitenPanel panelZeiten;
    private BegehungswegePersonalPanel panelPersonal;
    private BegehungswegeErgebnisPanel panelErgebnis;

    public static void main(String[] args) {
        AbstractMainWindow.main(args, () -> {
            BegehungswegeMainWindow begehungswegeMainWindow = new BegehungswegeMainWindow();
        });
    }

    public BegehungswegeMainWindow() {
        this.setTitle(Messages.getString("Begehungswege.FensterTitel"));
        this.setSize(this.getWindowSize(540), this.getWindowSize(550));
        this.init();
    }

    @Override
    protected String[] getDokuPdfFileNames() {
        String[] stringArray = new String[2];
        stringArray[0] = "DokuBegehungswege.pdf";
        return stringArray;
    }

    @Override
    protected JPanel createPanelInput() {
        JPanel pnlInput = new JPanel();
        BegehungswegeMainWindow.initTitledBorder(pnlInput, Messages.getString("Common.TitelEingaben"));
        pnlInput.setLayout(new BoxLayout(pnlInput, 3));
        pnlInput.add(Box.createVerticalStrut(5));
        this.panelBegehungswege = new BegehungswegePanel(this);
        pnlInput.add(this.panelBegehungswege);
        pnlInput.add(Box.createVerticalStrut(10));
        this.panelZeiten = new BegehungswegeZeitenPanel(this);
        pnlInput.add(this.panelZeiten);
        pnlInput.add(Box.createVerticalStrut(10));
        this.panelPersonal = new BegehungswegePersonalPanel(this);
        pnlInput.add(this.panelPersonal);
        pnlInput.add(Box.createVerticalGlue());
        pnlInput.add(Box.createRigidArea(new Dimension(1, 220)));
        return pnlInput;
    }

    @Override
    protected JPanel createPanelOutput() {
        this.panelErgebnis = new BegehungswegeErgebnisPanel(this);
        return this.panelErgebnis;
    }

    @Override
    protected String getModelAsXmlString() {
        String xmlModelName = "<modellname>" + Messages.getString("Begehungswege.Titel") + "</modellname>";
        String xmlInfo = this.getMetaInformationAsXmlString();
        String xmlPdfTitles = this.getPdfTitlesAsXmlString();
        String xmlEingaben = "<eingaben>";
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelBegehungswege.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelZeiten.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelPersonal.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + "</eingaben>";
        String xmlErgebnis = BegehungswegeMainWindow.getErgebnisAsXmlString(this.panelErgebnis);
        String result = String.valueOf(xmlModelName) + xmlInfo + xmlPdfTitles + xmlEingaben + xmlErgebnis;
        return result;
    }

    @Override
    protected String getXsltFilePath() {
        return "data/kalkulation2fo-begehungswege.xsl";
    }

    @Override
    protected void onInputChangedBeforeCalculation() {
        this.panelZeiten.onInputChangedBeforeCalculation(this.panelBegehungswege.getBegehungsweg(), this.panelBegehungswege.getAusfuehrung(), this.panelBegehungswege.getGelaendeschwierigkeit());
    }

    @Override
    protected void displayErgebnis() {
        BegehungswegeModel model = new BegehungswegeModel();
        model.setBegehungsweg(this.panelBegehungswege.getBegehungsweg());
        model.setAusfuehrung(this.panelBegehungswege.getAusfuehrung());
        model.setAnzahlLaufmeter(this.panelBegehungswege.getAnzahlLaufmeter());
        model.setGelaendeSchwierigkeit(this.panelBegehungswege.getGelaendeschwierigkeit());
        model.setZeitaufwand_minProM(this.panelZeiten.getZeitaufwand_minProM());
        model.setKostenPersonal(this.panelPersonal.getKostenPersonal());
        model.setKostenMaschine(this.panelPersonal.getKostenMaschine());
        model.setFaktorWegzeitenUndPausen(this.panelPersonal.getFaktorWegzeitenUndPausen());
        BegehungswegeErgebnis ergebnis = model.getErgebnis();
        this.panelErgebnis.setErgebnis(ergebnis);
    }
}

