/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.main;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.ergebnis.AustrichternErgebnisPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.AustrichternBestandPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.AustrichternPersonalMaschinenPanel;
import ch.wsl.fps.juwapfl.model.AustrichternErgebnis;
import ch.wsl.fps.juwapfl.model.AustrichternModel;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class AustrichternMainWindow
extends AbstractMainWindow {
    private AustrichternBestandPanel panelBestand;
    private AustrichternPersonalMaschinenPanel panelPersonalMaschinen;
    private AustrichternErgebnisPanel panelErgebnis;

    public static void main(String[] args) {
        AbstractMainWindow.main(args, () -> {
            AustrichternMainWindow austrichternMainWindow = new AustrichternMainWindow();
        });
    }

    public AustrichternMainWindow() {
        this.setTitle(Messages.getString("Austrichtern.FensterTitel"));
        this.setSize(this.getWindowSize(520), this.getWindowSize(655));
        this.init();
    }

    @Override
    protected String[] getDokuPdfFileNames() {
        String[] stringArray = new String[2];
        stringArray[0] = "DokuAustrichtern.pdf";
        return stringArray;
    }

    @Override
    protected String getModelAsXmlString() {
        String xmlModelName = "<modellname>" + Messages.getString("Austrichtern.Titel") + "</modellname>";
        String xmlInfo = this.getMetaInformationAsXmlString();
        String xmlPdfTitles = this.getPdfTitlesAsXmlString();
        String xmlEingaben = "<eingaben>";
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelBestand.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + this.panelPersonalMaschinen.getAsXmlString();
        xmlEingaben = String.valueOf(xmlEingaben) + "</eingaben>";
        String xmlErgebnis = AustrichternMainWindow.getErgebnisAsXmlString(this.panelErgebnis);
        String result = String.valueOf(xmlModelName) + xmlInfo + xmlPdfTitles + xmlEingaben + xmlErgebnis;
        return result;
    }

    @Override
    protected String getXsltFilePath() {
        return "data/kalkulation2fo-austrichtern.xsl";
    }

    @Override
    protected Map<String, String> getAdditionalPdfTitles() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("pro-pflanze", Messages.getString("Austrichtern.proPflanze"));
        result.put("pro-hektare", Messages.getString("Austrichtern.proHektare"));
        result.put("bestand", Messages.getString("Austrichtern.Bestand"));
        return result;
    }

    @Override
    protected JPanel createPanelInput() {
        JPanel pnlInput = new JPanel();
        AustrichternMainWindow.initTitledBorder(pnlInput, Messages.getString("Common.TitelEingaben"));
        pnlInput.setLayout(new BoxLayout(pnlInput, 3));
        pnlInput.add(Box.createVerticalStrut(5));
        this.panelBestand = new AustrichternBestandPanel(this);
        pnlInput.add(this.panelBestand);
        pnlInput.add(Box.createVerticalStrut(10));
        this.panelPersonalMaschinen = new AustrichternPersonalMaschinenPanel(this, this.panelBestand);
        pnlInput.add(this.panelPersonalMaschinen);
        pnlInput.add(Box.createVerticalGlue());
        pnlInput.add(Box.createRigidArea(new Dimension(1, 220)));
        return pnlInput;
    }

    @Override
    protected void onInputChangedBeforeCalculation() {
        this.panelPersonalMaschinen.onInputChangedBeforeCalculation();
    }

    @Override
    protected void displayErgebnis() {
        AustrichternModel model = new AustrichternModel();
        model.setFlaeche_ha(this.panelBestand.getFlaeche_ha());
        model.setMaschinenGeraete(this.panelBestand.getMaschinenGeraete());
        model.setAnzahlPflanzenProHa(this.panelBestand.getAnzahlPflanzenProHektar());
        model.setVerunkrautung(this.panelBestand.getVerunkrautung());
        model.setHangneigung(this.panelBestand.getHangneigung());
        model.setRueckegassenVorhanden(this.panelBestand.getRueckegassenVorhanden());
        model.setSchutzsystem(this.panelBestand.getSchutzsystem());
        model.setTemperatur(this.panelBestand.getTemperatur());
        model.setKostenPersonal_proH(this.panelPersonalMaschinen.getKostenPersonalProPerson().intValue());
        model.setKostenMotorsaege_proLiter(this.panelPersonalMaschinen.getKostenMaschine());
        model.setKostenSichel_proHektar(this.panelPersonalMaschinen.getKostenSichel());
        model.setFaktorWegzeitenUndPausen(this.panelPersonalMaschinen.getFaktorWegzeitenUndPausen());
        AustrichternErgebnis ergebnis = model.getErgebnis();
        this.panelErgebnis.setErgebnis(ergebnis);
    }

    @Override
    protected JPanel createPanelOutput() {
        this.panelErgebnis = new AustrichternErgebnisPanel(this);
        return this.panelErgebnis;
    }
}

