/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.controls;

import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.controls.TitledBorderFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Path2D;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class TitledBorderWithInfoButton
extends AbstractBorder {
    private final String title;
    private Border border;
    private final JLabel label;
    private final JLabel infoButton;
    private static final int EDGE_SPACING = 2;
    private static final int TEXT_SPACING = 2;
    private static final int TEXT_INSET_H = 5;
    private final Rectangle infoButtonBounds = new Rectangle();

    public TitledBorderWithInfoButton(String title, boolean showInfoButton) {
        this.title = title;
        this.border = TitledBorderFactory.getBaseBorder();
        this.label = new JLabel();
        this.label.setOpaque(false);
        this.label.putClientProperty("html", null);
        this.infoButton = showInfoButton ? Utilities.getInfoButtonBlue("") : null;
    }

    public TitledBorderWithInfoButton(String title) {
        this(title, false);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Border border = this.getBorder();
        if (this.title != null && !this.title.isEmpty()) {
            JLabel label = this.getLabel(c);
            Dimension size = label.getPreferredSize();
            Insets insets = new Insets(0, 0, 0, 0);
            int borderX = x + 2;
            int borderY = y + 2;
            int borderW = width - 2 - 2;
            int borderH = height - 2 - 2;
            int labelY = y;
            int labelH = size.height;
            insets.top = 2 - labelH / 2;
            if (insets.top < 2) {
                borderY -= insets.top;
                borderH += insets.top;
            } else {
                labelY += insets.top;
            }
            insets.left += 7;
            insets.right += 7;
            int labelX = x;
            int labelW = width - insets.left - insets.right;
            if (labelW > size.width) {
                labelW = size.width;
            }
            labelX += insets.left;
            if (border != null) {
                Graphics g2 = g.create();
                if (g2 instanceof Graphics2D) {
                    Graphics2D g2d = (Graphics2D)g2;
                    Path2D.Float path = new Path2D.Float();
                    path.append(new Rectangle(borderX, borderY, borderW, labelY - borderY), false);
                    path.append(new Rectangle(borderX, labelY, labelX - borderX - 2, labelH), false);
                    path.append(new Rectangle(labelX + labelW + 2, labelY, borderX - labelX + borderW - labelW - 2, labelH), false);
                    path.append(new Rectangle(borderX, labelY + labelH, borderW, borderY - labelY + borderH - labelH), false);
                    g2d.clip(path);
                }
                border.paintBorder(c, g2, borderX, borderY, borderW, borderH);
                g2.dispose();
            }
            g.translate(labelX, labelY);
            label.setSize(labelW, labelH);
            label.paint(g);
            g.translate(-labelX, -labelY);
            if (this.infoButton != null) {
                int infoButtonX = labelX + labelW + 5;
                int infoButtonY = labelY;
                int infoButtonEdgeLength = 16;
                g.translate(infoButtonX, infoButtonY);
                this.infoButton.setSize(16, 16);
                this.infoButton.paint(g);
                g.translate(-infoButtonX, -infoButtonY);
                this.infoButtonBounds.setBounds(infoButtonX, infoButtonY, 16, 16);
            }
        } else if (border != null) {
            border.paintBorder(c, g, x, y, width, height);
        }
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        AbstractBorder border = (AbstractBorder)this.getBorder();
        insets = border.getBorderInsets(c, insets);
        if (this.title != null && !this.title.isEmpty()) {
            JLabel label = this.getLabel(c);
            Dimension size = label.getPreferredSize();
            if (insets.top < size.height) {
                insets.top = size.height - 2;
            }
            insets.top += 4;
            insets.left += 4;
            insets.right += 4;
            insets.bottom += 4;
        }
        return insets;
    }

    public Border getBorder() {
        return this.border != null ? this.border : UIManager.getBorder("TitledBorder.border");
    }

    @Override
    public int getBaseline(Component c, int width, int height) {
        if (c == null) {
            throw new NullPointerException("Must supply non-null component");
        }
        if (width < 0) {
            throw new IllegalArgumentException("Width must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("Height must be >= 0");
        }
        Border border = this.getBorder();
        if (this.title != null && !this.title.isEmpty()) {
            int edge = border instanceof TitledBorder ? 0 : 2;
            JLabel label = this.getLabel(c);
            Dimension size = label.getPreferredSize();
            int baseline = label.getBaseline(size.width, size.height);
            int topInset = edge + (0 - size.height) / 2;
            return topInset < edge ? baseline : baseline + topInset;
        }
        return -1;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(Component c) {
        super.getBaselineResizeBehavior(c);
        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
    }

    private JLabel getLabel(Component c) {
        this.label.setText(this.title);
        this.label.setFont(UIManager.getFont("TitledBorder.font").deriveFont(1));
        this.label.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        this.label.setComponentOrientation(c.getComponentOrientation());
        this.label.setEnabled(c.isEnabled());
        return this.label;
    }

    public Rectangle getInfoButtonBounds() {
        return this.infoButtonBounds;
    }
}

