/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Utilities {
    private static final int TOOLTIP_CHARS_PER_LINE = 75;
    private static ImageIcon imageIconBlue = null;

    public static ImageIcon getWslLogo() {
        return Utilities.getImageIcon("data/WSL64.png");
    }

    public static JPanel getPanelWithInfoButton(final JComponent inputField, String infoButtonText) {
        JPanel pnlInputFieldAndInfoButton = new JPanel((LayoutManager)new BorderLayout(5, 0)){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                inputField.setEnabled(enabled);
            }
        };
        pnlInputFieldAndInfoButton.setOpaque(false);
        pnlInputFieldAndInfoButton.add((Component)inputField, "Center");
        pnlInputFieldAndInfoButton.add((Component)Utilities.getInfoButtonBlue(infoButtonText), "East");
        return pnlInputFieldAndInfoButton;
    }

    public static JPanel getPanelWithoutInfoButton(final JComponent inputField) {
        JPanel pnlInputFieldAndInfoButton = new JPanel((LayoutManager)new BorderLayout(5, 0)){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                inputField.setEnabled(enabled);
            }
        };
        pnlInputFieldAndInfoButton.add((Component)inputField, "Center");
        JPanel infoButtonPlaceholder = new JPanel();
        infoButtonPlaceholder.setPreferredSize(new Dimension(16, 16));
        pnlInputFieldAndInfoButton.add((Component)infoButtonPlaceholder, "East");
        return pnlInputFieldAndInfoButton;
    }

    public static JLabel getInfoButtonBlue(String text) {
        JLabel label = new JLabel(Utilities.getInfoIconBlue());
        label.setToolTipText(Utilities.normalizeTooltipText(text));
        return label;
    }

    private static ImageIcon getInfoIconBlue() {
        if (imageIconBlue != null) {
            return imageIconBlue;
        }
        imageIconBlue = Utilities.getImageIcon("data/info.png");
        return imageIconBlue;
    }

    private static ImageIcon getImageIcon(String filePath) {
        URL imgURL = Utilities.class.getClassLoader().getResource(filePath);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        return new ImageIcon(filePath);
    }

    public static String normalizeTooltipText(String tooltipText) {
        return Utilities.wrap(tooltipText, 75);
    }

    private static String wrap(String text, int charsPerLine) {
        if (text.startsWith("<html>") || text.length() < charsPerLine) {
            return text;
        }
        String BREAK = "<br>";
        int startPos = 0;
        int latestCutPosition = startPos + charsPerLine;
        while (text.lastIndexOf("<br>", latestCutPosition) > startPos) {
            startPos = text.lastIndexOf("<br>", latestCutPosition) + "<br>".length();
            latestCutPosition = startPos + charsPerLine;
        }
        while (latestCutPosition < text.length()) {
            int indexOfLastSpace = text.lastIndexOf(" ", latestCutPosition);
            if (indexOfLastSpace == -1) {
                text = String.valueOf(text.substring(0, latestCutPosition)) + "-" + "<br>" + text.substring(latestCutPosition);
                startPos = latestCutPosition + 1 + "<br>".length();
                latestCutPosition = startPos + charsPerLine;
            } else {
                text = String.valueOf(text.substring(0, indexOfLastSpace)) + "<br>" + text.substring(indexOfLastSpace + 1);
                startPos = indexOfLastSpace + "<br>".length();
                latestCutPosition = startPos + charsPerLine;
            }
            while (text.lastIndexOf("<br>", latestCutPosition) > startPos) {
                startPos = text.lastIndexOf("<br>", latestCutPosition) + "<br>".length();
                latestCutPosition = startPos + charsPerLine;
            }
        }
        text = "<html>" + text + "</html>";
        return text;
    }
}

