/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui;

import ch.wsl.fps.juwapfl.Messages;
import java.awt.Desktop;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.jar.JarFile;
import javax.swing.JOptionPane;

public class DocumentionHelper {
    public static final String DOKU_DIR = "Dokumentation/";

    public static void openDocumentationPdfFile(String path) {
        if (!path.startsWith(DOKU_DIR)) {
            path = DOKU_DIR + path;
        }
        DocumentionHelper.copyFileFromJarToFilesystemIfNecessary(path);
        DocumentionHelper.generateReadMeFile();
        File file = new File(path);
        try {
            Desktop.getDesktop().open(file);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            JOptionPane.showMessageDialog(null, e1.getMessage(), Messages.getString("DocumentionHelper.FehlerBeimOeffnenDerDatei"), 0);
        }
    }

    private static void copyFileFromJarToFilesystemIfNecessary(String path) {
        if (!DocumentionHelper.isStartedFromJar()) {
            return;
        }
        File fileInFilesystem = new File(path);
        if (!fileInFilesystem.exists()) {
            System.out.println("File in file system does not exist. File will be copied from jar.");
            DocumentionHelper.copyFileFromJarToFilesystem(path);
        } else if (DocumentionHelper.hasFilesystemFileDifferentDateThanFileInJar(path)) {
            System.out.println("File in file system has different last-modified date than file in jar. File in file system will be replaced.");
            DocumentionHelper.copyFileFromJarToFilesystem(path);
        } else {
            return;
        }
    }

    private static boolean isStartedFromJar() {
        URL url = DocumentionHelper.class.getResource("DocumentionHelper.class");
        boolean isStartedFromJar = url.toString().startsWith("jar") || url.toString().startsWith("rsrc");
        return isStartedFromJar;
    }

    private static void copyFileFromJarToFilesystem(String path) {
        long lastModified;
        File fileInFilesystem;
        block18: {
            fileInFilesystem = new File(path);
            InputStream in = DocumentionHelper.class.getClassLoader().getResourceAsStream(path);
            if (in == null) {
                System.err.println("file '" + path + "' not found in jar");
                return;
            }
            String[] dirs = path.split("\\\\|/");
            String dir = "";
            int i = 0;
            while (i < dirs.length - 1) {
                dir = String.valueOf(dir) + dirs[i] + "/";
                ++i;
            }
            File f = new File(dir);
            f.mkdirs();
            FileOutputStream out = null;
            byte[] buffer = new byte[4096];
            try {
                try {
                    int readBytes;
                    out = new FileOutputStream(fileInFilesystem);
                    while ((readBytes = in.read(buffer)) > 0) {
                        out.write(buffer, 0, readBytes);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        in.close();
                        if (out != null) {
                            out.close();
                        }
                        break block18;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                in.close();
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((lastModified = DocumentionHelper.getJarFileLastModified(path)) >= 0L) {
            fileInFilesystem.setLastModified(lastModified);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static long getJarFileLastModified(String filePath) {
        block16: {
            filePath = "/" + filePath;
            jar = null;
            try {
                block17: {
                    jar = DocumentionHelper.getJarFile();
                    if (jar == null) break block16;
                    enumEntries = jar.entries();
                    break block17;
                    while (true) {
                        file = enumEntries.nextElement();
                        if (!file.getName().equals(filePath.substring(1))) break;
                        var7_6 = time = file.getTime();
                        return var7_6;
                    }
                }
                try {
                    if (enumEntries.hasMoreElements()) ** continue;
                }
                catch (Exception var2_3) {}
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException var9_7) {}
                }
            }
        }
        return -1L;
    }

    private static JarFile getJarFile() {
        JarFile jar = null;
        try {
            jar = new JarFile("JuWaPfl.jar");
            return jar;
        }
        catch (Exception e) {
            try {
                String fileName = Files.list(Paths.get(".", new String[0])).filter(p -> p.getFileName().toString().startsWith("JuWaPfl") && p.getFileName().toString().endsWith(".jar")).findAny().get().getFileName().toString();
                jar = new JarFile(fileName);
                return jar;
            }
            catch (Exception exception) {
                try {
                    String jarFilePath = ClassLoader.getSystemClassLoader().getResource(".").toURI().getPath().replaceFirst("/", "");
                    jar = new JarFile(String.valueOf(jarFilePath) + File.separator + "JuWaPfl.jar");
                    return jar;
                }
                catch (Exception exception2) {
                    return null;
                }
            }
        }
    }

    private static boolean hasFilesystemFileDifferentDateThanFileInJar(String path) {
        File fileInFilesystem = new File(path);
        long fileInFilesystemLastModified = -2L;
        long fileInJarLastModified = -2L;
        try {
            fileInFilesystemLastModified = fileInFilesystem.lastModified();
            fileInJarLastModified = DocumentionHelper.getJarFileLastModified(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        if (fileInFilesystemLastModified <= 0L || fileInJarLastModified <= 0L) {
            return true;
        }
        return fileInFilesystemLastModified != fileInJarLastModified;
    }

    private static void generateReadMeFile() {
        File file = new File("Dokumentation/README.txt");
        if (!file.exists()) {
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(file);
                writer.println(Messages.getString("DocumentionHelper.ReadmeTxtContent"));
                writer.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

