# ===============================================================================
# file            : mosaic_tiles_F3.R
# ===============================================================================

# This R script creates a mosaic from each predictor metrics tile set (output of 
# Python script 'Metriken_Holzvolumen_F3.py').

# It was devised within the scope of the "F3 - Flächendeckende 
# Fernerkundungsbasierte Forstliche Strukturdaten" (F3- Area-wide remote sensing 
# based forest structural data) project by project partners Forest Research 
# Institute of Baden-Württemberg (Forstliche Versuchs- und Forschungsanstalt 
# Baden-Württemberg - FVA) and Northwest German Forest Research Institute 
# (Nordwestdeutsche Forstliche Versuchsanstalt - NW-FVA).
# For further information go to www.waldwissen.net/technik/inventur/f3/ or contact
# Petra Adler, Petra.Adler@forst.bwl.de (FVA)
# Jörg Ackermann, Joerg.Ackermann@nw-fva.de (NW-FVA)

# This script is published under GNU General Public License Version 3, 29 June 2007.

# =================================================================================

library(raster)

setwd('D:/F3/Daten/Abgeleitete_Daten/Aus_Luftbildern/Metriken')

dir.create('Mosaike')
for (i in c('cctot6_20', 'cctot20_20', 'max_20', 'mean_20', 'perc75_20', 'perc95_20', 'std_20')){
      
      rastlist <- list.files(i, pattern="\\.tif$", full.names=T)
      allrasters <- lapply(rastlist, raster)
      allrasters$fun <- max
      mosaic1 <- do.call(mosaic, allrasters)
      
      writeRaster(mosaic1, filename=paste('Mosaike', paste(i,'_mosaic.tif', sep=''), sep='/'), format='GTiff', overwrite=F)
      }

